/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.google.common.annotations.VisibleForTesting;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskLockbox;
import io.druid.java.util.common.ISE;
import io.druid.timeline.DataSegment;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.ReadableInterval;

public class TaskActionPreconditions {
    static void checkLockCoversSegments(Task task, TaskLockbox taskLockbox, Collection<DataSegment> segments) {
        if (!TaskActionPreconditions.isLockCoversSegments(task, taskLockbox, segments)) {
            throw new ISE("Segments not covered by locks for task: %s", new Object[]{task.getId()});
        }
    }

    @VisibleForTesting
    static boolean isLockCoversSegments(Task task, TaskLockbox taskLockbox, Collection<DataSegment> segments) {
        NavigableMap<DateTime, TaskLock> taskLockMap = TaskActionPreconditions.getTaskLockMap(taskLockbox, task);
        if (taskLockMap.isEmpty()) {
            return false;
        }
        return segments.stream().allMatch(segment -> {
            Map.Entry entry = taskLockMap.floorEntry(segment.getInterval().getStart());
            if (entry == null) {
                return false;
            }
            TaskLock taskLock = (TaskLock)entry.getValue();
            return taskLock.getInterval().contains((ReadableInterval)segment.getInterval()) && taskLock.getDataSource().equals(segment.getDataSource()) && taskLock.getVersion().compareTo(segment.getVersion()) >= 0;
        });
    }

    private static NavigableMap<DateTime, TaskLock> getTaskLockMap(TaskLockbox taskLockbox, Task task) {
        List<TaskLock> taskLocks = taskLockbox.findLocksForTask(task);
        TreeMap<DateTime, TaskLock> taskLockMap = new TreeMap<DateTime, TaskLock>();
        taskLocks.forEach(taskLock -> taskLockMap.put(taskLock.getInterval().getStart(), (TaskLock)taskLock));
        return taskLockMap;
    }
}

