/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.index;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.druid.data.input.Committer;
import io.druid.data.input.InputRow;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.QueryableIndex;
import io.druid.segment.SegmentUtils;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.FireHydrant;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.PlumberSchool;
import io.druid.segment.realtime.plumber.Sink;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.joda.time.Interval;

@JsonTypeName(value="historical")
public class YeOldePlumberSchool
implements PlumberSchool {
    private final Interval interval;
    private final String version;
    private final DataSegmentPusher dataSegmentPusher;
    private final File tmpSegmentDir;
    private final IndexMergerV9 indexMergerV9;
    private final IndexIO indexIO;
    private static final Logger log = new Logger(YeOldePlumberSchool.class);

    @JsonCreator
    public YeOldePlumberSchool(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JacksonInject(value="segmentPusher") DataSegmentPusher dataSegmentPusher, @JacksonInject(value="tmpSegmentDir") File tmpSegmentDir, @JacksonInject IndexMergerV9 indexMergerV9, @JacksonInject IndexIO indexIO) {
        this.interval = interval;
        this.version = version;
        this.dataSegmentPusher = dataSegmentPusher;
        this.tmpSegmentDir = tmpSegmentDir;
        this.indexMergerV9 = (IndexMergerV9)Preconditions.checkNotNull((Object)indexMergerV9, (Object)"Null IndexMergerV9");
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
    }

    public Plumber findPlumber(final DataSchema schema, final RealtimeTuningConfig config, final FireDepartmentMetrics metrics) {
        final Sink theSink = new Sink(this.interval, schema, config.getShardSpec(), this.version, config.getMaxRowsInMemory(), config.isReportParseExceptions());
        final File persistDir = new File(this.tmpSegmentDir, theSink.getSegment().getIdentifier());
        final HashSet spilled = Sets.newHashSet();
        return new Plumber(){

            public Object startJob() {
                return null;
            }

            public int add(InputRow row, Supplier<Committer> committerSupplier) throws IndexSizeExceededException {
                Sink sink = this.getSink(row.getTimestampFromEpoch());
                if (sink == null) {
                    return -1;
                }
                int numRows = sink.add(row, false);
                if (!sink.canAppendRow()) {
                    this.persist((Committer)committerSupplier.get());
                }
                return numRows;
            }

            private Sink getSink(long timestamp) {
                if (theSink.getInterval().contains(timestamp)) {
                    return theSink;
                }
                return null;
            }

            public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
                throw new UnsupportedOperationException("Don't query me, bro.");
            }

            public void persist(Committer committer) {
                this.spillIfSwappable();
                committer.run();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void finishJob() {
                File fileToUpload = null;
                try {
                    Preconditions.checkState((!theSink.swappable() ? 1 : 0) != 0, (Object)"All data must be persisted before fininshing the job!");
                    if (spilled.size() == 0) {
                        throw new IllegalStateException("Nothing indexed?");
                    }
                    if (spilled.size() == 1) {
                        fileToUpload = (File)Iterables.getOnlyElement((Iterable)spilled);
                    } else {
                        ArrayList indexes = Lists.newArrayList();
                        for (File oneSpill : spilled) {
                            indexes.add(YeOldePlumberSchool.this.indexIO.loadIndex(oneSpill));
                        }
                        fileToUpload = new File(YeOldePlumberSchool.this.tmpSegmentDir, "merged");
                        YeOldePlumberSchool.this.indexMergerV9.mergeQueryableIndex((List)indexes, schema.getGranularitySpec().isRollup(), schema.getAggregators(), fileToUpload, config.getIndexSpec(), config.getSegmentWriteOutMediumFactory());
                    }
                    QueryableIndex mappedSegment = YeOldePlumberSchool.this.indexIO.loadIndex(fileToUpload);
                    DataSegment segmentToUpload = theSink.getSegment().withDimensions((List)ImmutableList.copyOf((Iterable)mappedSegment.getAvailableDimensions())).withBinaryVersion(SegmentUtils.getVersionFromDir((File)fileToUpload));
                    YeOldePlumberSchool.this.dataSegmentPusher.push(fileToUpload, segmentToUpload, true);
                    log.info("Uploaded segment[%s]", new Object[]{segmentToUpload.getIdentifier()});
                }
                catch (Exception e) {
                    try {
                        log.warn((Throwable)e, "Failed to merge and upload", new Object[0]);
                        throw Throwables.propagate((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fileToUpload == null) throw throwable;
                            log.info("Deleting Index File[%s]", new Object[]{fileToUpload});
                            FileUtils.deleteDirectory(fileToUpload);
                            throw throwable;
                        }
                        catch (IOException e2) {
                            log.warn((Throwable)e2, "Error deleting directory[%s]", new Object[]{fileToUpload});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (fileToUpload == null) return;
                    log.info("Deleting Index File[%s]", new Object[]{fileToUpload});
                    FileUtils.deleteDirectory((File)fileToUpload);
                    return;
                }
                catch (IOException e) {
                    log.warn((Throwable)e, "Error deleting directory[%s]", new Object[]{fileToUpload});
                    return;
                }
            }

            private void spillIfSwappable() {
                if (theSink.swappable()) {
                    FireHydrant indexToPersist = theSink.swap();
                    int rowsToPersist = indexToPersist.getIndex().size();
                    File dirToPersist = this.getSpillDir(indexToPersist.getCount());
                    log.info("Spilling index[%d] with rows[%d] to: %s", new Object[]{indexToPersist.getCount(), rowsToPersist, dirToPersist});
                    try {
                        YeOldePlumberSchool.this.indexMergerV9.persist(indexToPersist.getIndex(), dirToPersist, config.getIndexSpec(), config.getSegmentWriteOutMediumFactory());
                        indexToPersist.swapSegment(null);
                        metrics.incrementRowOutputCount((long)rowsToPersist);
                        spilled.add(dirToPersist);
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e, "Failed to spill index[%d]", new Object[]{indexToPersist.getCount()});
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }

            private File getSpillDir(int n) {
                return new File(persistDir, StringUtils.format((String)"spill%d", (Object[])new Object[]{n}));
            }
        };
    }
}

