/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.LockListAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.common.task.TaskResource;
import io.druid.java.util.common.DateTimes;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public abstract class AbstractTask
implements Task {
    private static final Joiner ID_JOINER = Joiner.on((String)"_");
    @JsonIgnore
    private final String id;
    @JsonIgnore
    private final String groupId;
    @JsonIgnore
    private final TaskResource taskResource;
    @JsonIgnore
    private final String dataSource;
    private final Map<String, Object> context;

    protected AbstractTask(String id, String dataSource, Map<String, Object> context) {
        this(id, null, null, dataSource, context);
    }

    protected AbstractTask(String id, String groupId, TaskResource taskResource, String dataSource, Map<String, Object> context) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.groupId = groupId == null ? id : groupId;
        this.taskResource = taskResource == null ? new TaskResource(id, 1) : taskResource;
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.context = context;
    }

    static String getOrMakeId(String id, String typeName, String dataSource) {
        return AbstractTask.getOrMakeId(id, typeName, dataSource, null);
    }

    static String getOrMakeId(String id, String typeName, String dataSource, @Nullable Interval interval) {
        if (id != null) {
            return id;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(typeName);
        objects.add(dataSource);
        if (interval != null) {
            objects.add(interval.getStart());
            objects.add(interval.getEnd());
        }
        objects.add(DateTimes.nowUtc().toString());
        return AbstractTask.joinId(objects);
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="resource")
    public TaskResource getTaskResource() {
        return this.taskResource;
    }

    @Override
    public String getNodeType() {
        return null;
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        return null;
    }

    @Override
    public String getClasspathPrefix() {
        return null;
    }

    @Override
    public boolean canRestore() {
        return false;
    }

    @Override
    public void stopGracefully() {
        throw new UnsupportedOperationException("Cannot stop gracefully");
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("type", (Object)this.getType()).add("dataSource", (Object)this.dataSource).toString();
    }

    static String joinId(List<Object> objects) {
        return ID_JOINER.join(objects);
    }

    static String joinId(Object ... objects) {
        return ID_JOINER.join(objects);
    }

    public TaskStatus success() {
        return TaskStatus.success(this.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTask that = (AbstractTask)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    static List<TaskLock> getTaskLocks(TaskActionClient client) throws IOException {
        return client.submit(new LockListAction());
    }

    @Override
    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }
}

