/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.druid.data.input.impl.DimensionSchema;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.DoubleDimensionSchema;
import io.druid.data.input.impl.FloatDimensionSchema;
import io.druid.data.input.impl.LongDimensionSchema;
import io.druid.data.input.impl.NoopInputRowParser;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.StringDimensionSchema;
import io.druid.data.input.impl.TimeAndDimsParseSpec;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.SegmentListUsedAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractTask;
import io.druid.indexing.common.task.IndexTask;
import io.druid.indexing.common.task.TaskResource;
import io.druid.indexing.firehose.IngestSegmentFirehoseFactory;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.JodaUtils;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.granularity.NoneGranularity;
import io.druid.java.util.common.guava.Comparators;
import io.druid.java.util.common.jackson.JacksonUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.DimensionHandler;
import io.druid.segment.IndexIO;
import io.druid.segment.QueryableIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.ValueType;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.PartitionHolder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class CompactionTask
extends AbstractTask {
    private static final Logger log = new Logger(CompactionTask.class);
    private static final String TYPE = "compact";
    private final Interval interval;
    private final List<DataSegment> segments;
    private final DimensionsSpec dimensionsSpec;
    private final IndexTask.IndexTuningConfig tuningConfig;
    private final ObjectMapper jsonMapper;
    @JsonIgnore
    private final SegmentProvider segmentProvider;
    @JsonIgnore
    private IndexTask indexTaskSpec;

    @JsonCreator
    public CompactionTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="dataSource") String dataSource, @Nullable @JsonProperty(value="interval") Interval interval, @Nullable @JsonProperty(value="segments") List<DataSegment> segments, @Nullable @JsonProperty(value="dimensions") DimensionsSpec dimensionsSpec, @Nullable @JsonProperty(value="tuningConfig") IndexTask.IndexTuningConfig tuningConfig, @Nullable @JsonProperty(value="context") Map<String, Object> context, @JacksonInject ObjectMapper jsonMapper) {
        super(CompactionTask.getOrMakeId(id, TYPE, dataSource), null, taskResource, dataSource, context);
        Preconditions.checkArgument((interval != null || segments != null ? 1 : 0) != 0, (Object)"interval or segments should be specified");
        Preconditions.checkArgument((interval == null || segments == null ? 1 : 0) != 0, (Object)"one of interval and segments should be null");
        this.interval = interval;
        this.segments = segments;
        this.dimensionsSpec = dimensionsSpec;
        this.tuningConfig = tuningConfig;
        this.jsonMapper = jsonMapper;
        this.segmentProvider = segments == null ? new SegmentProvider(dataSource, interval) : new SegmentProvider(segments);
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public List<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    @JsonProperty
    public IndexTask.IndexTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 25);
    }

    @VisibleForTesting
    SegmentProvider getSegmentProvider() {
        return this.segmentProvider;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        TreeSet<Interval> intervals = new TreeSet<Interval>(Comparators.intervalsByStartThenEnd());
        intervals.add(this.segmentProvider.interval);
        return IndexTask.isReady(taskActionClient, intervals);
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        if (this.indexTaskSpec == null) {
            IndexTask.IndexIngestionSpec ingestionSpec = CompactionTask.createIngestionSchema(toolbox, this.segmentProvider, this.dimensionsSpec, this.tuningConfig, this.jsonMapper);
            this.indexTaskSpec = new IndexTask(this.getId(), this.getGroupId(), this.getTaskResource(), this.getDataSource(), ingestionSpec, this.getContext());
        }
        if (this.indexTaskSpec.getIngestionSchema() == null) {
            log.info("Cannot find segments for interval", new Object[0]);
        }
        String json = this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.indexTaskSpec);
        log.info("Generated compaction task details: " + json, new Object[0]);
        return this.indexTaskSpec.run(toolbox);
    }

    @VisibleForTesting
    static IndexTask.IndexIngestionSpec createIngestionSchema(TaskToolbox toolbox, SegmentProvider segmentProvider, DimensionsSpec dimensionsSpec, IndexTask.IndexTuningConfig tuningConfig, ObjectMapper jsonMapper) throws IOException, SegmentLoadingException {
        Pair<Map<DataSegment, File>, List<TimelineObjectHolder<String, DataSegment>>> pair = CompactionTask.prepareSegments(toolbox, segmentProvider);
        Map segmentFileMap = (Map)pair.lhs;
        List timelineSegments = (List)pair.rhs;
        if (timelineSegments.size() == 0) {
            return null;
        }
        DataSchema dataSchema = CompactionTask.createDataSchema(segmentProvider.dataSource, segmentProvider.interval, dimensionsSpec, toolbox.getIndexIO(), jsonMapper, timelineSegments, segmentFileMap);
        return new IndexTask.IndexIngestionSpec(dataSchema, new IndexTask.IndexIOConfig(new IngestSegmentFirehoseFactory(segmentProvider.dataSource, segmentProvider.interval, null, dataSchema.getParser().getParseSpec().getDimensionsSpec().getDimensionNames(), Arrays.stream(dataSchema.getAggregators()).map(AggregatorFactory::getName).collect(Collectors.toList()), toolbox.getIndexIO()), false), tuningConfig);
    }

    private static Pair<Map<DataSegment, File>, List<TimelineObjectHolder<String, DataSegment>>> prepareSegments(TaskToolbox toolbox, SegmentProvider segmentProvider) throws IOException, SegmentLoadingException {
        List<DataSegment> usedSegments = segmentProvider.checkAndGetSegments(toolbox);
        Map<DataSegment, File> segmentFileMap = toolbox.fetchSegments(usedSegments);
        List timelineSegments = VersionedIntervalTimeline.forSegments(usedSegments).lookup(segmentProvider.interval);
        return Pair.of(segmentFileMap, (Object)timelineSegments);
    }

    private static DataSchema createDataSchema(String dataSource, Interval interval, DimensionsSpec dimensionsSpec, IndexIO indexIO, ObjectMapper jsonMapper, List<TimelineObjectHolder<String, DataSegment>> timelineSegments, Map<DataSegment, File> segmentFileMap) throws IOException, SegmentLoadingException {
        List<QueryableIndex> queryableIndices = CompactionTask.loadSegments(timelineSegments, segmentFileMap, indexIO);
        List aggregatorFactories = queryableIndices.stream().map(index -> index.getMetadata().getAggregators()).collect(Collectors.toList());
        AggregatorFactory[] mergedAggregators = AggregatorFactory.mergeAggregators(aggregatorFactories);
        if (mergedAggregators == null) {
            throw new ISE("Failed to merge aggregators[%s]", new Object[]{aggregatorFactories});
        }
        boolean rollup = queryableIndices.stream().allMatch(index -> index.getMetadata().isRollup());
        ArbitraryGranularitySpec granularitySpec = new ArbitraryGranularitySpec((Granularity)new NoneGranularity(), Boolean.valueOf(rollup), (List)ImmutableList.of((Object)interval));
        DimensionsSpec finalDimensionsSpec = dimensionsSpec == null ? CompactionTask.createDimensionsSpec(queryableIndices) : dimensionsSpec;
        NoopInputRowParser parser = new NoopInputRowParser((ParseSpec)new TimeAndDimsParseSpec(null, finalDimensionsSpec));
        return new DataSchema(dataSource, (Map)jsonMapper.convertValue((Object)parser, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT), mergedAggregators, (GranularitySpec)granularitySpec, null, jsonMapper);
    }

    private static DimensionsSpec createDimensionsSpec(List<QueryableIndex> queryableIndices) {
        HashBiMap uniqueDims = HashBiMap.create();
        HashMap<String, DimensionSchema> dimensionSchemaMap = new HashMap<String, DimensionSchema>();
        int index = 0;
        for (QueryableIndex queryableIndex : Lists.reverse(queryableIndices)) {
            Map dimensionHandlerMap = queryableIndex.getDimensionHandlers();
            for (String dimension : queryableIndex.getAvailableDimensions()) {
                Column column = (Column)Preconditions.checkNotNull((Object)queryableIndex.getColumn(dimension), (String)"Cannot find column for dimension[%s]", (Object[])new Object[]{dimension});
                if (uniqueDims.containsKey((Object)dimension)) continue;
                DimensionHandler dimensionHandler = (DimensionHandler)Preconditions.checkNotNull(dimensionHandlerMap.get(dimension), (String)"Cannot find dimensionHandler for dimension[%s]", (Object[])new Object[]{dimension});
                uniqueDims.put((Object)dimension, (Object)index++);
                dimensionSchemaMap.put(dimension, CompactionTask.createDimensionSchema(column.getCapabilities().getType(), dimension, dimensionHandler.getMultivalueHandling()));
            }
        }
        BiMap orderedDims = uniqueDims.inverse();
        List dimensionSchemas = IntStream.range(0, orderedDims.size()).mapToObj(i -> {
            String dimName = (String)orderedDims.get((Object)i);
            return (DimensionSchema)Preconditions.checkNotNull(dimensionSchemaMap.get(dimName), (String)"Cannot find dimension[%s] from dimensionSchemaMap", (Object[])new Object[]{dimName});
        }).collect(Collectors.toList());
        return new DimensionsSpec(dimensionSchemas, null, null);
    }

    private static List<QueryableIndex> loadSegments(List<TimelineObjectHolder<String, DataSegment>> timelineSegments, Map<DataSegment, File> segmentFileMap, IndexIO indexIO) throws IOException {
        ArrayList<QueryableIndex> segments = new ArrayList<QueryableIndex>();
        for (TimelineObjectHolder<String, DataSegment> timelineSegment : timelineSegments) {
            PartitionHolder partitionHolder = timelineSegment.getObject();
            for (PartitionChunk chunk : partitionHolder) {
                DataSegment segment = (DataSegment)chunk.getObject();
                segments.add(indexIO.loadIndex((File)Preconditions.checkNotNull((Object)segmentFileMap.get(segment), (String)"File for segment %s", (Object[])new Object[]{segment.getIdentifier()})));
            }
        }
        return segments;
    }

    private static DimensionSchema createDimensionSchema(ValueType type, String name, DimensionSchema.MultiValueHandling multiValueHandling) {
        switch (type) {
            case FLOAT: {
                Preconditions.checkArgument((multiValueHandling == null ? 1 : 0) != 0, (String)"multi-value dimension [%s] is not supported for float type yet", (Object[])new Object[]{name});
                return new FloatDimensionSchema(name);
            }
            case LONG: {
                Preconditions.checkArgument((multiValueHandling == null ? 1 : 0) != 0, (String)"multi-value dimension [%s] is not supported for long type yet", (Object[])new Object[]{name});
                return new LongDimensionSchema(name);
            }
            case DOUBLE: {
                Preconditions.checkArgument((multiValueHandling == null ? 1 : 0) != 0, (String)"multi-value dimension [%s] is not supported for double type yet", (Object[])new Object[]{name});
                return new DoubleDimensionSchema(name);
            }
            case STRING: {
                return new StringDimensionSchema(name, multiValueHandling);
            }
        }
        throw new ISE("Unsupported value type[%s] for dimension[%s]", new Object[]{type, name});
    }

    @VisibleForTesting
    static class SegmentProvider {
        private final String dataSource;
        private final Interval interval;
        private final List<DataSegment> segments;

        SegmentProvider(String dataSource, Interval interval) {
            this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource);
            this.interval = (Interval)Preconditions.checkNotNull((Object)interval);
            this.segments = null;
        }

        SegmentProvider(List<DataSegment> segments) {
            Preconditions.checkArgument((segments != null && !segments.isEmpty() ? 1 : 0) != 0);
            String dataSource = segments.get(0).getDataSource();
            Preconditions.checkArgument((boolean)segments.stream().allMatch(segment -> segment.getDataSource().equals(dataSource)), (Object)"segments should have the same dataSource");
            this.segments = segments;
            this.dataSource = dataSource;
            this.interval = JodaUtils.umbrellaInterval((Iterable)segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
        }

        List<DataSegment> getSegments() {
            return this.segments;
        }

        List<DataSegment> checkAndGetSegments(TaskToolbox toolbox) throws IOException {
            List<DataSegment> usedSegments = toolbox.getTaskActionClient().submit(new SegmentListUsedAction(this.dataSource, this.interval, null));
            if (this.segments != null) {
                Collections.sort(usedSegments);
                Collections.sort(this.segments);
                Preconditions.checkState((boolean)usedSegments.equals(this.segments), (String)"Specified segments[%s] are different from the current used segments[%s]", (Object[])new Object[]{this.segments, usedSegments});
            }
            return usedSegments;
        }
    }
}

