/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.SegmentInsertAction;
import io.druid.indexing.common.actions.SegmentListUsedAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractFixedIntervalTask;
import io.druid.indexing.common.task.Task;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.guava.FunctionalIterable;
import io.druid.java.util.common.logger.Logger;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexSpec;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class ConvertSegmentTask
extends AbstractFixedIntervalTask {
    private static final String TYPE = "convert_segment";
    private static final Integer CURR_VERSION_INTEGER = 9;
    private static final Logger log = new Logger(ConvertSegmentTask.class);
    @JsonIgnore
    private final DataSegment segment;
    private final IndexSpec indexSpec;
    private final boolean force;
    private final boolean validate;
    @Nullable
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

    public static ConvertSegmentTask create(String dataSource, Interval interval, IndexSpec indexSpec, boolean force, boolean validate, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, Map<String, Object> context) {
        String id = ConvertSegmentTask.makeId(dataSource, interval);
        return new ConvertSegmentTask(id, dataSource, interval, null, indexSpec, force, validate, segmentWriteOutMediumFactory, context);
    }

    public static ConvertSegmentTask create(DataSegment segment, IndexSpec indexSpec, boolean force, boolean validate, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, Map<String, Object> context) {
        Interval interval = segment.getInterval();
        String dataSource = segment.getDataSource();
        String id = ConvertSegmentTask.makeId(dataSource, interval);
        return new ConvertSegmentTask(id, dataSource, interval, segment, indexSpec, force, validate, segmentWriteOutMediumFactory, context);
    }

    protected static String makeId(String dataSource, Interval interval) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)interval, (Object)"interval");
        return ConvertSegmentTask.joinId(TYPE, dataSource, interval.getStart(), interval.getEnd(), DateTimes.nowUtc());
    }

    @JsonCreator
    private static ConvertSegmentTask createFromJson(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="segment") DataSegment segment, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="force") Boolean force, @JsonProperty(value="validate") Boolean validate, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        boolean isValidate;
        boolean isForce = force == null ? false : force;
        boolean bl = isValidate = validate == null ? true : validate;
        if (id == null) {
            if (segment == null) {
                return ConvertSegmentTask.create(dataSource, interval, indexSpec, isForce, isValidate, segmentWriteOutMediumFactory, context);
            }
            return ConvertSegmentTask.create(segment, indexSpec, isForce, isValidate, segmentWriteOutMediumFactory, context);
        }
        return new ConvertSegmentTask(id, dataSource, interval, segment, indexSpec, isForce, isValidate, segmentWriteOutMediumFactory, context);
    }

    ConvertSegmentTask(String id, String dataSource, Interval interval, DataSegment segment, IndexSpec indexSpec, boolean force, boolean validate, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, Map<String, Object> context) {
        super(id, dataSource, interval, context);
        this.segment = segment;
        this.indexSpec = indexSpec == null ? new IndexSpec() : indexSpec;
        this.force = force;
        this.validate = validate;
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
    }

    @JsonProperty
    public boolean isForce() {
        return this.force;
    }

    @JsonProperty
    public boolean isValidate() {
        return this.validate;
    }

    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @JsonProperty
    public DataSegment getSegment() {
        return this.segment;
    }

    @JsonProperty
    @Nullable
    public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
        return this.segmentWriteOutMediumFactory;
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        FunctionalIterable segmentsToUpdate;
        if (this.segment == null) {
            List<DataSegment> segments = toolbox.getTaskActionClient().submit(new SegmentListUsedAction(this.getDataSource(), this.getInterval(), null));
            segmentsToUpdate = FunctionalIterable.create(segments).filter((Predicate)new Predicate<DataSegment>(){

                public boolean apply(DataSegment segment) {
                    Integer segmentVersion = segment.getBinaryVersion();
                    if (!CURR_VERSION_INTEGER.equals(segmentVersion)) {
                        return true;
                    }
                    if (ConvertSegmentTask.this.force) {
                        log.info("Segment[%s] already at version[%s], forcing conversion", new Object[]{segment.getIdentifier(), segmentVersion});
                        return true;
                    }
                    log.info("Skipping[%s], already version[%s]", new Object[]{segment.getIdentifier(), segmentVersion});
                    return false;
                }
            });
        } else {
            log.info("I'm in a subless mood.", new Object[0]);
            segmentsToUpdate = Collections.singleton(this.segment);
        }
        for (Task subTask : this.generateSubTasks(this.getGroupId(), (Iterable<DataSegment>)segmentsToUpdate, this.indexSpec, this.force, this.validate, this.getContext())) {
            TaskStatus status = subTask.run(toolbox);
            if (status.isSuccess()) continue;
            return TaskStatus.fromCode(this.getId(), status.getStatusCode());
        }
        return this.success();
    }

    protected Iterable<Task> generateSubTasks(final String groupId, Iterable<DataSegment> segments, final IndexSpec indexSpec, final boolean force, final boolean validate, final Map<String, Object> context) {
        return Iterables.transform(segments, (Function)new Function<DataSegment, Task>(){

            public Task apply(DataSegment input) {
                return new SubTask(groupId, input, indexSpec, force, validate, ConvertSegmentTask.this.segmentWriteOutMediumFactory, context);
            }
        });
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConvertSegmentTask that = (ConvertSegmentTask)o;
        if (this.segment != null ? !this.segment.equals((Object)that.segment) : that.segment != null) {
            return false;
        }
        return super.equals(o);
    }

    public static class SubTask
    extends AbstractFixedIntervalTask {
        @JsonIgnore
        private final DataSegment segment;
        private final IndexSpec indexSpec;
        private final boolean force;
        private final boolean validate;
        @Nullable
        private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

        @JsonCreator
        public SubTask(@JsonProperty(value="groupId") String groupId, @JsonProperty(value="segment") DataSegment segment, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="force") Boolean force, @JsonProperty(value="validate") Boolean validate, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="context") Map<String, Object> context) {
            super(SubTask.joinId(groupId, "sub", segment.getInterval().getStart(), segment.getInterval().getEnd(), segment.getShardSpec().getPartitionNum()), groupId, segment.getDataSource(), segment.getInterval(), context);
            this.segment = segment;
            this.indexSpec = indexSpec == null ? new IndexSpec() : indexSpec;
            this.force = force == null ? false : force;
            this.validate = validate == null ? true : validate;
            this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        }

        @JsonProperty
        public boolean isValidate() {
            return this.validate;
        }

        @JsonProperty
        public boolean isForce() {
            return this.force;
        }

        @JsonProperty
        public DataSegment getSegment() {
            return this.segment;
        }

        @Override
        public String getType() {
            return "version_converter_sub";
        }

        @Override
        public TaskStatus run(TaskToolbox toolbox) throws Exception {
            log.info("Subs are good!  Italian BMT and Meatball are probably my favorite.", new Object[0]);
            try {
                this.convertSegment(toolbox);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Conversion failed.", new Object[0]);
                throw e;
            }
            return this.success();
        }

        private void convertSegment(TaskToolbox toolbox) throws SegmentLoadingException, IOException {
            log.info("Converting segment[%s]", new Object[]{this.segment});
            TaskActionClient actionClient = toolbox.getTaskActionClient();
            List<DataSegment> currentSegments = actionClient.submit(new SegmentListUsedAction(this.segment.getDataSource(), this.segment.getInterval(), null));
            for (DataSegment currentSegment : currentSegments) {
                String version = currentSegment.getVersion();
                Integer binaryVersion = currentSegment.getBinaryVersion();
                if (this.force || !version.startsWith(this.segment.getVersion()) || !CURR_VERSION_INTEGER.equals(binaryVersion)) continue;
                log.info("Skipping already updated segment[%s].", new Object[]{this.segment});
                return;
            }
            Map<DataSegment, File> localSegments = toolbox.fetchSegments(Collections.singletonList(this.segment));
            File location = localSegments.get(this.segment);
            File outLocation = new File(location, "v9_out");
            IndexIO indexIO = toolbox.getIndexIO();
            if (indexIO.convertSegment(location, outLocation, this.indexSpec, this.force, this.validate, this.segmentWriteOutMediumFactory)) {
                int outVersion = IndexIO.getVersionFromDir((File)outLocation);
                DataSegment updatedSegment = this.segment.withVersion(StringUtils.format((String)"%s_v%s", (Object[])new Object[]{this.segment.getVersion(), outVersion}));
                updatedSegment = toolbox.getSegmentPusher().push(outLocation, updatedSegment, true);
                actionClient.submit(new SegmentInsertAction(Sets.newHashSet((Object[])new DataSegment[]{updatedSegment})));
            } else {
                log.info("Conversion failed.", new Object[0]);
            }
        }
    }
}

