/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import io.druid.guice.ExtensionsConfig;
import io.druid.guice.GuiceInjectors;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.task.AbstractTask;
import io.druid.indexing.common.task.HadoopIndexTask;
import io.druid.initialization.Initialization;
import io.druid.java.util.common.logger.Logger;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class HadoopTask
extends AbstractTask {
    private static final Logger log = new Logger(HadoopTask.class);
    private static final ExtensionsConfig extensionsConfig;
    static final Injector injector;
    private final List<String> hadoopDependencyCoordinates;
    protected static final Predicate<URL> IS_DRUID_URL;

    protected HadoopTask(String id, String dataSource, List<String> hadoopDependencyCoordinates, Map<String, Object> context) {
        super(id, dataSource, context);
        this.hadoopDependencyCoordinates = hadoopDependencyCoordinates;
    }

    public List<String> getHadoopDependencyCoordinates() {
        return this.hadoopDependencyCoordinates == null ? null : ImmutableList.copyOf(this.hadoopDependencyCoordinates);
    }

    protected ClassLoader buildClassLoader(TaskToolbox toolbox) throws MalformedURLException {
        return HadoopTask.buildClassLoader(this.hadoopDependencyCoordinates, toolbox.getConfig().getDefaultHadoopCoordinates());
    }

    public static ClassLoader buildClassLoader(List<String> hadoopDependencyCoordinates, List<String> defaultHadoopCoordinates) throws MalformedURLException {
        String hadoopContainerDruidClasspathJars;
        List<String> finalHadoopDependencyCoordinates = hadoopDependencyCoordinates != null ? hadoopDependencyCoordinates : defaultHadoopCoordinates;
        ArrayList jobURLs = Lists.newArrayList(Arrays.asList(((URLClassLoader)HadoopIndexTask.class.getClassLoader()).getURLs()));
        ArrayList extensionURLs = Lists.newArrayList();
        for (File extension : Initialization.getExtensionFilesToLoad((ExtensionsConfig)extensionsConfig)) {
            URLClassLoader extensionLoader = Initialization.getClassLoaderForExtension((File)extension);
            extensionURLs.addAll(Arrays.asList(extensionLoader.getURLs()));
        }
        jobURLs.addAll(extensionURLs);
        ArrayList<URL> localClassLoaderURLs = new ArrayList<URL>(jobURLs);
        for (File hadoopDependency : Initialization.getHadoopDependencyFilesToLoad(finalHadoopDependencyCoordinates, (ExtensionsConfig)extensionsConfig)) {
            URLClassLoader hadoopLoader = Initialization.getClassLoaderForExtension((File)hadoopDependency);
            localClassLoaderURLs.addAll(Arrays.asList(hadoopLoader.getURLs()));
        }
        URLClassLoader classLoader = new URLClassLoader(localClassLoaderURLs.toArray(new URL[localClassLoaderURLs.size()]), null);
        if (extensionsConfig.getHadoopContainerDruidClasspath() == null) {
            hadoopContainerDruidClasspathJars = Joiner.on((String)File.pathSeparator).join((Iterable)jobURLs);
        } else {
            ArrayList hadoopContainerURLs = Lists.newArrayList((Iterable)Initialization.getURLsForClasspath((String)extensionsConfig.getHadoopContainerDruidClasspath()));
            if (extensionsConfig.getAddExtensionsToHadoopContainer()) {
                hadoopContainerURLs.addAll(extensionURLs);
            }
            hadoopContainerDruidClasspathJars = Joiner.on((String)File.pathSeparator).join((Iterable)hadoopContainerURLs);
        }
        log.info("Hadoop Container Druid Classpath is set to [%s]", new Object[]{hadoopContainerDruidClasspathJars});
        System.setProperty("druid.hadoop.internal.classpath", hadoopContainerDruidClasspathJars);
        return classLoader;
    }

    public static <InputType, OutputType> OutputType invokeForeignLoader(String clazzName, InputType input, ClassLoader loader) {
        log.debug("Launching [%s] on class loader [%s] with input class [%s]", new Object[]{clazzName, loader, input.getClass()});
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> clazz = loader.loadClass(clazzName);
            Method method = clazz.getMethod("runTask", input.getClass());
            Object object = method.invoke(null, input);
            return (OutputType)object;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    static {
        injector = GuiceInjectors.makeStartupInjector();
        extensionsConfig = (ExtensionsConfig)injector.getInstance(ExtensionsConfig.class);
        IS_DRUID_URL = new Predicate<URL>(){

            public boolean apply(@Nullable URL input) {
                try {
                    if (input == null) {
                        return false;
                    }
                    String fName = Paths.get(input.toURI()).getFileName().toString();
                    return fName.startsWith("druid") && fName.endsWith(".jar") && !fName.endsWith("selfcontained.jar");
                }
                catch (URISyntaxException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }
}

