/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ListenableFuture;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.data.input.Rows;
import io.druid.hll.HyperLogLogCollector;
import io.druid.indexing.appenderator.ActionBasedUsedSegmentChecker;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractTask;
import io.druid.indexing.common.task.TaskResource;
import io.druid.indexing.common.task.Tasks;
import io.druid.indexing.firehose.IngestSegmentFirehoseFactory;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.JodaUtils;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.guava.Comparators;
import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.common.parsers.ParseException;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexSpec;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.IOConfig;
import io.druid.segment.indexing.IngestionSpec;
import io.druid.segment.indexing.TuningConfig;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.appenderator.Appenderator;
import io.druid.segment.realtime.appenderator.AppenderatorConfig;
import io.druid.segment.realtime.appenderator.Appenderators;
import io.druid.segment.realtime.appenderator.BatchAppenderatorDriver;
import io.druid.segment.realtime.appenderator.SegmentAllocator;
import io.druid.segment.realtime.appenderator.SegmentIdentifier;
import io.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import io.druid.segment.realtime.appenderator.UsedSegmentChecker;
import io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import io.druid.timeline.partition.HashBasedNumberedShardSpec;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.NumberedShardSpec;
import io.druid.timeline.partition.ShardSpec;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.codehaus.plexus.util.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInterval;

public class IndexTask
extends AbstractTask {
    private static final Logger log = new Logger(IndexTask.class);
    private static final HashFunction hashFunction = Hashing.murmur3_128();
    private static final String TYPE = "index";
    @JsonIgnore
    private final IndexIngestionSpec ingestionSchema;

    private static String makeGroupId(IndexIngestionSpec ingestionSchema) {
        return IndexTask.makeGroupId(ingestionSchema.ioConfig.appendToExisting, ingestionSchema.dataSchema.getDataSource());
    }

    private static String makeGroupId(boolean isAppendToExisting, String dataSource) {
        if (isAppendToExisting) {
            return StringUtils.format((String)"%s_append_%s", (Object[])new Object[]{TYPE, dataSource});
        }
        return null;
    }

    @JsonCreator
    public IndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="spec") IndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context) {
        this(id, IndexTask.makeGroupId(ingestionSchema), taskResource, ingestionSchema.dataSchema.getDataSource(), ingestionSchema, context);
    }

    IndexTask(String id, String groupId, TaskResource resource, String dataSource, IndexIngestionSpec ingestionSchema, Map<String, Object> context) {
        super(IndexTask.getOrMakeId(id, TYPE, dataSource), groupId, resource, dataSource, context);
        this.ingestionSchema = ingestionSchema;
    }

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 50);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        Optional intervals = this.ingestionSchema.getDataSchema().getGranularitySpec().bucketIntervals();
        if (intervals.isPresent()) {
            return IndexTask.isReady(taskActionClient, (SortedSet)intervals.get());
        }
        return true;
    }

    static boolean isReady(TaskActionClient actionClient, SortedSet<Interval> intervals) throws IOException {
        List<TaskLock> locks = IndexTask.getTaskLocks(actionClient);
        if (locks.size() == 0) {
            try {
                Tasks.tryAcquireExclusiveLocks(actionClient, intervals);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    @JsonProperty(value="spec")
    public IndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        DataSchema dataSchema;
        Map<Interval, String> versions;
        boolean determineIntervals = !this.ingestionSchema.getDataSchema().getGranularitySpec().bucketIntervals().isPresent();
        FirehoseFactory firehoseFactory = this.ingestionSchema.getIOConfig().getFirehoseFactory();
        if (firehoseFactory instanceof IngestSegmentFirehoseFactory) {
            ((IngestSegmentFirehoseFactory)firehoseFactory).setTaskToolbox(toolbox);
        }
        File firehoseTempDir = toolbox.getFirehoseTemporaryDir();
        FileUtils.forceMkdir((File)firehoseTempDir);
        ShardSpecs shardSpecs = this.determineShardSpecs(toolbox, firehoseFactory, firehoseTempDir);
        if (determineIntervals) {
            TreeSet<Interval> intervals = new TreeSet<Interval>(Comparators.intervalsByStartThenEnd());
            intervals.addAll(shardSpecs.getIntervals());
            Map<Interval, TaskLock> locks = Tasks.tryAcquireExclusiveLocks(toolbox.getTaskActionClient(), intervals);
            versions = locks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TaskLock)entry.getValue()).getVersion()));
            dataSchema = this.ingestionSchema.getDataSchema().withGranularitySpec(this.ingestionSchema.getDataSchema().getGranularitySpec().withIntervals((List)JodaUtils.condenseIntervals(shardSpecs.getIntervals())));
        } else {
            versions = IndexTask.getTaskLocks(toolbox.getTaskActionClient()).stream().collect(Collectors.toMap(TaskLock::getInterval, TaskLock::getVersion));
            dataSchema = this.ingestionSchema.getDataSchema();
        }
        if (this.generateAndPublishSegments(toolbox, dataSchema, shardSpecs, versions, firehoseFactory, firehoseTempDir)) {
            return TaskStatus.success(this.getId());
        }
        return TaskStatus.failure(this.getId());
    }

    private static String findVersion(Map<Interval, String> versions, Interval interval) {
        return versions.entrySet().stream().filter(entry -> ((Interval)entry.getKey()).contains((ReadableInterval)interval)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new ISE("Cannot find a version for interval[%s]", new Object[]{interval}));
    }

    private static boolean isGuaranteedRollup(IndexIOConfig ioConfig, IndexTuningConfig tuningConfig) {
        Preconditions.checkState((!tuningConfig.isForceGuaranteedRollup() || !tuningConfig.isForceExtendableShardSpecs() && !ioConfig.isAppendToExisting() ? 1 : 0) != 0, (Object)"Perfect rollup cannot be guaranteed with extendable shardSpecs");
        return tuningConfig.isForceGuaranteedRollup();
    }

    private static boolean isExtendableShardSpecs(IndexIOConfig ioConfig, IndexTuningConfig tuningConfig) {
        return !IndexTask.isGuaranteedRollup(ioConfig, tuningConfig);
    }

    private ShardSpecs determineShardSpecs(TaskToolbox toolbox, FirehoseFactory firehoseFactory, File firehoseTempDir) throws IOException {
        boolean determineNumPartitions;
        ObjectMapper jsonMapper = toolbox.getObjectMapper();
        IndexTuningConfig tuningConfig = this.ingestionSchema.getTuningConfig();
        IndexIOConfig ioConfig = this.ingestionSchema.getIOConfig();
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        boolean determineIntervals = !granularitySpec.bucketIntervals().isPresent();
        boolean bl = determineNumPartitions = tuningConfig.getNumShards() == null && IndexTask.isGuaranteedRollup(ioConfig, tuningConfig);
        if (!determineNumPartitions && !determineIntervals) {
            log.info("Skipping determine partition scan", new Object[0]);
            return IndexTask.createShardSpecWithoutInputScan(jsonMapper, granularitySpec, ioConfig, tuningConfig);
        }
        return IndexTask.createShardSpecsFromInput(jsonMapper, this.ingestionSchema, firehoseFactory, firehoseTempDir, granularitySpec, tuningConfig, determineIntervals, determineNumPartitions);
    }

    private static ShardSpecs createShardSpecWithoutInputScan(ObjectMapper jsonMapper, GranularitySpec granularitySpec, IndexIOConfig ioConfig, IndexTuningConfig tuningConfig) {
        HashMap<Interval, List<ShardSpec>> shardSpecs = new HashMap<Interval, List<ShardSpec>>();
        SortedSet intervals = (SortedSet)granularitySpec.bucketIntervals().get();
        if (IndexTask.isGuaranteedRollup(ioConfig, tuningConfig)) {
            int numShards = tuningConfig.getNumShards() == null ? 1 : tuningConfig.getNumShards();
            BiFunction<Integer, Integer, ShardSpec> shardSpecCreateFn = IndexTask.getShardSpecCreateFunction(numShards, jsonMapper);
            for (Interval interval : intervals) {
                List intervalShardSpecs = IntStream.range(0, numShards).mapToObj(shardId -> (ShardSpec)shardSpecCreateFn.apply(shardId, numShards)).collect(Collectors.toList());
                shardSpecs.put(interval, intervalShardSpecs);
            }
        } else {
            for (Interval interval : intervals) {
                shardSpecs.put(interval, (List<ShardSpec>)ImmutableList.of());
            }
        }
        return new ShardSpecs(shardSpecs);
    }

    private static ShardSpecs createShardSpecsFromInput(ObjectMapper jsonMapper, IndexIngestionSpec ingestionSchema, FirehoseFactory firehoseFactory, File firehoseTempDir, GranularitySpec granularitySpec, IndexTuningConfig tuningConfig, boolean determineIntervals, boolean determineNumPartitions) throws IOException {
        log.info("Determining intervals and shardSpecs", new Object[0]);
        long determineShardSpecsStartMillis = System.currentTimeMillis();
        Map<Interval, Optional<HyperLogLogCollector>> hllCollectors = IndexTask.collectIntervalsAndShardSpecs(jsonMapper, ingestionSchema, firehoseFactory, firehoseTempDir, granularitySpec, determineIntervals, determineNumPartitions);
        HashMap<Interval, List<ShardSpec>> intervalToShardSpecs = new HashMap<Interval, List<ShardSpec>>();
        int defaultNumShards = tuningConfig.getNumShards() == null ? 1 : tuningConfig.getNumShards();
        for (Map.Entry<Interval, Optional<HyperLogLogCollector>> entry : hllCollectors.entrySet()) {
            int numShards;
            Interval interval = entry.getKey();
            HyperLogLogCollector collector = (HyperLogLogCollector)entry.getValue().orNull();
            if (determineNumPartitions) {
                long numRows = collector.estimateCardinalityRound();
                numShards = (int)Math.ceil((double)numRows / (double)tuningConfig.getTargetPartitionSize().intValue());
                log.info("Estimated [%,d] rows of data for interval [%s], creating [%,d] shards", new Object[]{numRows, interval, numShards});
            } else {
                numShards = defaultNumShards;
                log.info("Creating [%,d] shards for interval [%s]", new Object[]{numShards, interval});
            }
            if (IndexTask.isGuaranteedRollup(ingestionSchema.getIOConfig(), ingestionSchema.getTuningConfig())) {
                BiFunction<Integer, Integer, ShardSpec> shardSpecCreateFn = IndexTask.getShardSpecCreateFunction(numShards, jsonMapper);
                List intervalShardSpecs = IntStream.range(0, numShards).mapToObj(shardId -> (ShardSpec)shardSpecCreateFn.apply(shardId, numShards)).collect(Collectors.toList());
                intervalToShardSpecs.put(interval, intervalShardSpecs);
                continue;
            }
            intervalToShardSpecs.put(interval, (List<ShardSpec>)ImmutableList.of());
        }
        log.info("Found intervals and shardSpecs in %,dms", new Object[]{System.currentTimeMillis() - determineShardSpecsStartMillis});
        return new ShardSpecs(intervalToShardSpecs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<Interval, Optional<HyperLogLogCollector>> collectIntervalsAndShardSpecs(ObjectMapper jsonMapper, IndexIngestionSpec ingestionSchema, FirehoseFactory firehoseFactory, File firehoseTempDir, GranularitySpec granularitySpec, boolean determineIntervals, boolean determineNumPartitions) throws IOException {
        TreeMap<Interval, Optional<HyperLogLogCollector>> hllCollectors = new TreeMap<Interval, Optional<HyperLogLogCollector>>(Comparators.intervalsByStartThenEnd());
        int thrownAway = 0;
        int unparseable = 0;
        Granularity queryGranularity = granularitySpec.getQueryGranularity();
        try (Firehose firehose = firehoseFactory.connect(ingestionSchema.getDataSchema().getParser(), firehoseTempDir);){
            while (firehose.hasMore()) {
                try {
                    Interval interval;
                    InputRow inputRow = firehose.nextRow();
                    if (inputRow == null) continue;
                    if (determineIntervals) {
                        interval = granularitySpec.getSegmentGranularity().bucket(inputRow.getTimestamp());
                    } else {
                        Optional optInterval = granularitySpec.bucketInterval(inputRow.getTimestamp());
                        if (!optInterval.isPresent()) {
                            ++thrownAway;
                            continue;
                        }
                        interval = (Interval)optInterval.get();
                    }
                    if (determineNumPartitions) {
                        if (!hllCollectors.containsKey(interval)) {
                            hllCollectors.put(interval, (Optional<HyperLogLogCollector>)Optional.of((Object)HyperLogLogCollector.makeLatestCollector()));
                        }
                        List groupKey = Rows.toGroupKey((long)queryGranularity.bucketStart(inputRow.getTimestamp()).getMillis(), (InputRow)inputRow);
                        ((HyperLogLogCollector)((Optional)hllCollectors.get(interval)).get()).add(hashFunction.hashBytes(jsonMapper.writeValueAsBytes((Object)groupKey)).asBytes());
                        continue;
                    }
                    if (hllCollectors.containsKey(interval)) continue;
                    hllCollectors.put(interval, (Optional<HyperLogLogCollector>)Optional.absent());
                }
                catch (ParseException e) {
                    if (ingestionSchema.getTuningConfig().isReportParseExceptions()) {
                        throw e;
                    }
                    ++unparseable;
                }
            }
        }
        if (thrownAway > 0) {
            log.warn("Unable to find a matching interval for [%,d] events", new Object[]{thrownAway});
        }
        if (unparseable > 0) {
            log.warn("Unable to parse [%,d] events", new Object[]{unparseable});
        }
        return hllCollectors;
    }

    private static BiFunction<Integer, Integer, ShardSpec> getShardSpecCreateFunction(Integer numShards, ObjectMapper jsonMapper) {
        Preconditions.checkNotNull((Object)numShards, (Object)"numShards");
        if (numShards == 1) {
            return (shardId, totalNumShards) -> NoneShardSpec.instance();
        }
        return (shardId, totalNumShards) -> new HashBasedNumberedShardSpec(shardId.intValue(), totalNumShards.intValue(), null, jsonMapper);
    }

    /*
     * Exception decompiling
     */
    private boolean generateAndPublishSegments(TaskToolbox toolbox, DataSchema dataSchema, ShardSpecs shardSpecs, Map<Interval, String> versions, FirehoseFactory firehoseFactory, File firehoseTempDir) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean exceedMaxRowsInSegment(int numRowsInSegment, IndexTuningConfig indexTuningConfig) {
        Integer maxRowsInSegment = indexTuningConfig.getTargetPartitionSize();
        return maxRowsInSegment != null && maxRowsInSegment <= numRowsInSegment;
    }

    private static boolean exceedMaxRowsInAppenderator(long numRowsInAppenderator, IndexTuningConfig indexTuningConfig) {
        Long maxRowsInAppenderator = indexTuningConfig.getMaxTotalRows();
        return maxRowsInAppenderator != null && maxRowsInAppenderator <= numRowsInAppenderator;
    }

    private static SegmentsAndMetadata awaitPublish(ListenableFuture<SegmentsAndMetadata> publishFuture, long publishTimeout) throws ExecutionException, InterruptedException, TimeoutException {
        if (publishTimeout == 0L) {
            return (SegmentsAndMetadata)publishFuture.get();
        }
        return (SegmentsAndMetadata)publishFuture.get(publishTimeout, TimeUnit.MILLISECONDS);
    }

    private static Appenderator newAppenderator(FireDepartmentMetrics metrics, TaskToolbox toolbox, DataSchema dataSchema, IndexTuningConfig tuningConfig) {
        return Appenderators.createOffline((DataSchema)dataSchema, (AppenderatorConfig)tuningConfig.withBasePersistDirectory(toolbox.getPersistDir()), (FireDepartmentMetrics)metrics, (DataSegmentPusher)toolbox.getSegmentPusher(), (ObjectMapper)toolbox.getObjectMapper(), (IndexIO)toolbox.getIndexIO(), (IndexMerger)toolbox.getIndexMergerV9());
    }

    private static BatchAppenderatorDriver newDriver(Appenderator appenderator, TaskToolbox toolbox, SegmentAllocator segmentAllocator) {
        return new BatchAppenderatorDriver(appenderator, segmentAllocator, (UsedSegmentChecker)new ActionBasedUsedSegmentChecker(toolbox.getTaskActionClient()));
    }

    private static /* synthetic */ boolean lambda$generateAndPublishSegments$10(TaskToolbox toolbox, Set segments, Object commitMetadata) throws IOException {
        SegmentTransactionalInsertAction action = new SegmentTransactionalInsertAction(segments);
        return toolbox.getTaskActionClient().submit(action).isSuccess();
    }

    private /* synthetic */ SegmentIdentifier lambda$generateAndPublishSegments$9(GranularitySpec granularitySpec, ShardSpecs shardSpecs, Map counters, Map versions, InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) throws IOException {
        DateTime timestamp = row.getTimestamp();
        Optional maybeInterval = granularitySpec.bucketInterval(timestamp);
        if (!maybeInterval.isPresent()) {
            throw new ISE("Could not find interval for timestamp [%s]", new Object[]{timestamp});
        }
        Interval interval = (Interval)maybeInterval.get();
        if (!shardSpecs.getMap().containsKey(interval)) {
            throw new ISE("Could not find shardSpec for interval[%s]", new Object[]{interval});
        }
        int partitionNum = counters.computeIfAbsent(interval, x -> new AtomicInteger()).getAndIncrement();
        return new SegmentIdentifier(this.getDataSource(), interval, IndexTask.findVersion(versions, interval), (ShardSpec)new NumberedShardSpec(partitionNum, 0));
    }

    private static /* synthetic */ SegmentIdentifier lambda$generateAndPublishSegments$7(Map lookup, InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) throws IOException {
        return (SegmentIdentifier)lookup.get(sequenceName);
    }

    @JsonTypeName(value="index")
    public static class IndexTuningConfig
    implements TuningConfig,
    AppenderatorConfig {
        private static final int DEFAULT_MAX_ROWS_IN_MEMORY = 75000;
        private static final int DEFAULT_MAX_TOTAL_ROWS = 20000000;
        private static final IndexSpec DEFAULT_INDEX_SPEC = new IndexSpec();
        private static final int DEFAULT_MAX_PENDING_PERSISTS = 0;
        private static final boolean DEFAULT_FORCE_EXTENDABLE_SHARD_SPECS = false;
        private static final boolean DEFAULT_GUARANTEE_ROLLUP = false;
        private static final boolean DEFAULT_REPORT_PARSE_EXCEPTIONS = false;
        private static final long DEFAULT_PUSH_TIMEOUT = 0L;
        static final int DEFAULT_TARGET_PARTITION_SIZE = 5000000;
        private final Integer targetPartitionSize;
        private final int maxRowsInMemory;
        private final Long maxTotalRows;
        private final Integer numShards;
        private final IndexSpec indexSpec;
        private final File basePersistDirectory;
        private final int maxPendingPersists;
        private final boolean forceExtendableShardSpecs;
        private final boolean forceGuaranteedRollup;
        private final boolean reportParseExceptions;
        private final long pushTimeout;
        @Nullable
        private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

        @JsonCreator
        public IndexTuningConfig(@JsonProperty(value="targetPartitionSize") @Nullable Integer targetPartitionSize, @JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxTotalRows") @Nullable Long maxTotalRows, @JsonProperty(value="rowFlushBoundary") @Nullable Integer rowFlushBoundary_forBackCompatibility, @JsonProperty(value="numShards") @Nullable Integer numShards, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="buildV9Directly") @Nullable Boolean buildV9Directly, @JsonProperty(value="forceExtendableShardSpecs") @Nullable Boolean forceExtendableShardSpecs, @JsonProperty(value="forceGuaranteedRollup") @Nullable Boolean forceGuaranteedRollup, @JsonProperty(value="reportParseExceptions") @Nullable Boolean reportParseExceptions, @JsonProperty(value="publishTimeout") @Nullable Long publishTimeout, @JsonProperty(value="pushTimeout") @Nullable Long pushTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
            this(targetPartitionSize, maxRowsInMemory != null ? maxRowsInMemory : rowFlushBoundary_forBackCompatibility, maxTotalRows, numShards, indexSpec, maxPendingPersists, forceExtendableShardSpecs, forceGuaranteedRollup, reportParseExceptions, pushTimeout != null ? pushTimeout : publishTimeout, null, segmentWriteOutMediumFactory);
        }

        private IndexTuningConfig() {
            this(null, null, null, null, null, null, null, null, null, null, null, null);
        }

        private IndexTuningConfig(@Nullable Integer targetPartitionSize, @Nullable Integer maxRowsInMemory, @Nullable Long maxTotalRows, @Nullable Integer numShards, @Nullable IndexSpec indexSpec, @Nullable Integer maxPendingPersists, @Nullable Boolean forceExtendableShardSpecs, @Nullable Boolean forceGuaranteedRollup, @Nullable Boolean reportParseExceptions, @Nullable Long pushTimeout, @Nullable File basePersistDirectory, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
            Preconditions.checkArgument((targetPartitionSize == null || targetPartitionSize.equals(-1) || numShards == null || numShards.equals(-1) ? 1 : 0) != 0, (Object)"targetPartitionSize and numShards cannot both be set");
            this.targetPartitionSize = IndexTuningConfig.initializeTargetPartitionSize(numShards, targetPartitionSize);
            this.maxRowsInMemory = maxRowsInMemory == null ? 75000 : maxRowsInMemory;
            this.maxTotalRows = IndexTuningConfig.initializeMaxTotalRows(numShards, maxTotalRows);
            this.numShards = numShards == null || numShards.equals(-1) ? null : numShards;
            this.indexSpec = indexSpec == null ? DEFAULT_INDEX_SPEC : indexSpec;
            this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
            this.forceExtendableShardSpecs = forceExtendableShardSpecs == null ? false : forceExtendableShardSpecs;
            this.forceGuaranteedRollup = forceGuaranteedRollup == null ? false : forceGuaranteedRollup;
            this.reportParseExceptions = reportParseExceptions == null ? false : reportParseExceptions;
            this.pushTimeout = pushTimeout == null ? 0L : pushTimeout;
            this.basePersistDirectory = basePersistDirectory;
            Preconditions.checkArgument((!this.forceExtendableShardSpecs || !this.forceGuaranteedRollup ? 1 : 0) != 0, (Object)"Perfect rollup cannot be guaranteed with extendable shardSpecs");
            this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        }

        private static Integer initializeTargetPartitionSize(Integer numShards, Integer targetPartitionSize) {
            if (numShards == null || numShards == -1) {
                return targetPartitionSize == null || targetPartitionSize.equals(-1) ? 5000000 : targetPartitionSize;
            }
            return null;
        }

        private static Long initializeMaxTotalRows(Integer numShards, Long maxTotalRows) {
            if (numShards == null || numShards == -1) {
                return maxTotalRows == null ? 20000000L : maxTotalRows;
            }
            return null;
        }

        public IndexTuningConfig withBasePersistDirectory(File dir) {
            return new IndexTuningConfig(this.targetPartitionSize, this.maxRowsInMemory, this.maxTotalRows, this.numShards, this.indexSpec, this.maxPendingPersists, this.forceExtendableShardSpecs, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, dir, this.segmentWriteOutMediumFactory);
        }

        @JsonProperty
        public Integer getTargetPartitionSize() {
            return this.targetPartitionSize;
        }

        @JsonProperty
        public int getMaxRowsInMemory() {
            return this.maxRowsInMemory;
        }

        @JsonProperty
        public Long getMaxTotalRows() {
            return this.maxTotalRows;
        }

        @JsonProperty
        public Integer getNumShards() {
            return this.numShards;
        }

        @JsonProperty
        public IndexSpec getIndexSpec() {
            return this.indexSpec;
        }

        public File getBasePersistDirectory() {
            return this.basePersistDirectory;
        }

        @JsonProperty
        public int getMaxPendingPersists() {
            return this.maxPendingPersists;
        }

        @Deprecated
        @JsonProperty
        public boolean isBuildV9Directly() {
            return true;
        }

        @JsonProperty
        public boolean isForceExtendableShardSpecs() {
            return this.forceExtendableShardSpecs;
        }

        @JsonProperty
        public boolean isForceGuaranteedRollup() {
            return this.forceGuaranteedRollup;
        }

        @JsonProperty
        public boolean isReportParseExceptions() {
            return this.reportParseExceptions;
        }

        @JsonProperty
        public long getPushTimeout() {
            return this.pushTimeout;
        }

        public Period getIntermediatePersistPeriod() {
            return new Period(Integer.MAX_VALUE);
        }

        @Nullable
        @JsonProperty
        public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
            return this.segmentWriteOutMediumFactory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexTuningConfig that = (IndexTuningConfig)o;
            return this.maxRowsInMemory == that.maxRowsInMemory && Objects.equals(this.maxTotalRows, that.maxTotalRows) && this.maxPendingPersists == that.maxPendingPersists && this.forceExtendableShardSpecs == that.forceExtendableShardSpecs && this.forceGuaranteedRollup == that.forceGuaranteedRollup && this.reportParseExceptions == that.reportParseExceptions && this.pushTimeout == that.pushTimeout && Objects.equals(this.targetPartitionSize, that.targetPartitionSize) && Objects.equals(this.numShards, that.numShards) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.basePersistDirectory, that.basePersistDirectory) && Objects.equals(this.segmentWriteOutMediumFactory, that.segmentWriteOutMediumFactory);
        }

        public int hashCode() {
            return Objects.hash(this.targetPartitionSize, this.maxRowsInMemory, this.maxTotalRows, this.numShards, this.indexSpec, this.basePersistDirectory, this.maxPendingPersists, this.forceExtendableShardSpecs, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, this.segmentWriteOutMediumFactory);
        }
    }

    @JsonTypeName(value="index")
    public static class IndexIOConfig
    implements IOConfig {
        private static final boolean DEFAULT_APPEND_TO_EXISTING = false;
        private final FirehoseFactory firehoseFactory;
        private final boolean appendToExisting;

        @JsonCreator
        public IndexIOConfig(@JsonProperty(value="firehose") FirehoseFactory firehoseFactory, @JsonProperty(value="appendToExisting") @Nullable Boolean appendToExisting) {
            this.firehoseFactory = firehoseFactory;
            this.appendToExisting = appendToExisting == null ? false : appendToExisting;
        }

        @JsonProperty(value="firehose")
        public FirehoseFactory getFirehoseFactory() {
            return this.firehoseFactory;
        }

        @JsonProperty(value="appendToExisting")
        public boolean isAppendToExisting() {
            return this.appendToExisting;
        }
    }

    public static class IndexIngestionSpec
    extends IngestionSpec<IndexIOConfig, IndexTuningConfig> {
        private final DataSchema dataSchema;
        private final IndexIOConfig ioConfig;
        private final IndexTuningConfig tuningConfig;

        @JsonCreator
        public IndexIngestionSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") IndexIOConfig ioConfig, @JsonProperty(value="tuningConfig") IndexTuningConfig tuningConfig) {
            super(dataSchema, (IOConfig)ioConfig, (TuningConfig)tuningConfig);
            this.dataSchema = dataSchema;
            this.ioConfig = ioConfig;
            this.tuningConfig = tuningConfig == null ? new IndexTuningConfig() : tuningConfig;
        }

        @JsonProperty(value="dataSchema")
        public DataSchema getDataSchema() {
            return this.dataSchema;
        }

        @JsonProperty(value="ioConfig")
        public IndexIOConfig getIOConfig() {
            return this.ioConfig;
        }

        @JsonProperty(value="tuningConfig")
        public IndexTuningConfig getTuningConfig() {
            return this.tuningConfig;
        }

        static /* synthetic */ IndexTuningConfig access$300(IndexIngestionSpec x0) {
            return x0.tuningConfig;
        }
    }

    static class ShardSpecs {
        private final Map<Interval, List<ShardSpec>> map;

        ShardSpecs(Map<Interval, List<ShardSpec>> map) {
            this.map = map;
        }

        Map<Interval, List<ShardSpec>> getMap() {
            return this.map;
        }

        Set<Interval> getIntervals() {
            return this.map.keySet();
        }

        ShardSpec getShardSpec(Interval interval, InputRow row) {
            List<ShardSpec> shardSpecs = this.map.get(interval);
            if (shardSpecs == null || shardSpecs.isEmpty()) {
                throw new ISE("Failed to get shardSpec for interval[%s]", new Object[]{interval});
            }
            return shardSpecs.get(0).getLookup(shardSpecs).getShardSpec(row.getTimestampFromEpoch(), row);
        }
    }
}

