/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.data.input.Committer;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.discovery.DiscoveryDruidNode;
import io.druid.discovery.LookupNodeService;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskLockType;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.LockAcquireAction;
import io.druid.indexing.common.actions.LockReleaseAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractTask;
import io.druid.indexing.common.task.TaskResource;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.guava.CloseQuietly;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.java.util.metrics.Monitor;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QueryToolChest;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeIOConfig;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.realtime.FireDepartment;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.RealtimeMetricsMonitor;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.segment.realtime.firehose.ClippedFirehoseFactory;
import io.druid.segment.realtime.firehose.EventReceiverFirehoseFactory;
import io.druid.segment.realtime.firehose.TimedShutoffFirehoseFactory;
import io.druid.segment.realtime.plumber.Committers;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.Plumbers;
import io.druid.segment.realtime.plumber.RealtimePlumberSchool;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.DataSegment;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class RealtimeIndexTask
extends AbstractTask {
    public static final String CTX_KEY_LOOKUP_TIER = "lookupTier";
    private static final EmittingLogger log = new EmittingLogger(RealtimeIndexTask.class);
    private static final Random random = new Random();
    @JsonIgnore
    private final FireDepartment spec;
    @JsonIgnore
    private volatile Plumber plumber = null;
    @JsonIgnore
    private volatile Firehose firehose = null;
    @JsonIgnore
    private volatile FireDepartmentMetrics metrics = null;
    @JsonIgnore
    private volatile boolean gracefullyStopped = false;
    @JsonIgnore
    private volatile boolean finishingJob = false;
    @JsonIgnore
    private volatile Thread runThread = null;
    @JsonIgnore
    private volatile QueryRunnerFactoryConglomerate queryRunnerFactoryConglomerate = null;

    private static String makeTaskId(FireDepartment fireDepartment) {
        return RealtimeIndexTask.makeTaskId(fireDepartment.getDataSchema().getDataSource(), fireDepartment.getTuningConfig().getShardSpec().getPartitionNum(), DateTimes.nowUtc(), random.nextInt());
    }

    static String makeTaskId(String dataSource, int partitionNumber, DateTime timestamp, int randomBits) {
        StringBuilder suffix = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            suffix.append((char)(97 + (randomBits >>> i * 4 & 0xF)));
        }
        return StringUtils.format((String)"index_realtime_%s_%d_%s_%s", (Object[])new Object[]{dataSource, partitionNumber, timestamp, suffix});
    }

    private static String makeDatasource(FireDepartment fireDepartment) {
        return fireDepartment.getDataSchema().getDataSource();
    }

    @JsonCreator
    public RealtimeIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="spec") FireDepartment fireDepartment, @JsonProperty(value="context") Map<String, Object> context) {
        super(id == null ? RealtimeIndexTask.makeTaskId(fireDepartment) : id, StringUtils.format((String)"index_realtime_%s", (Object[])new Object[]{RealtimeIndexTask.makeDatasource(fireDepartment)}), taskResource, RealtimeIndexTask.makeDatasource(fireDepartment), context);
        this.spec = fireDepartment;
    }

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 75);
    }

    @Override
    public String getType() {
        return "index_realtime";
    }

    @Override
    public String getNodeType() {
        return "realtime";
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        if (this.plumber != null) {
            QueryRunnerFactory factory = this.queryRunnerFactoryConglomerate.findFactory(query);
            QueryToolChest toolChest = factory.getToolchest();
            return new FinalizeResultsQueryRunner(this.plumber.getQueryRunner(query), toolChest);
        }
        return null;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public TaskStatus run(final TaskToolbox toolbox) throws Exception {
        DiscoveryDruidNode discoveryDruidNode;
        Supplier committerSupplier;
        RealtimeMetricsMonitor metricsMonitor;
        DataSchema dataSchema;
        boolean normalExit;
        block40: {
            this.runThread = Thread.currentThread();
            if (this.plumber != null) {
                throw new IllegalStateException("WTF?!? run with non-null plumber??!");
            }
            this.setupTimeoutAlert();
            normalExit = true;
            TaskActionSegmentPublisher segmentPublisher = new TaskActionSegmentPublisher(toolbox);
            final long lockTimeoutMs = this.getContextValue("taskLockTimeout", 300000L);
            DataSegmentAnnouncer lockingSegmentAnnouncer = new DataSegmentAnnouncer(){

                public void announceSegment(DataSegment segment) throws IOException {
                    Preconditions.checkNotNull((Object)toolbox.getTaskActionClient().submit(new LockAcquireAction(TaskLockType.EXCLUSIVE, segment.getInterval(), lockTimeoutMs)), (String)"Cannot acquire a lock for interval[%s]", (Object[])new Object[]{segment.getInterval()});
                    toolbox.getSegmentAnnouncer().announceSegment(segment);
                }

                public void unannounceSegment(DataSegment segment) throws IOException {
                    try {
                        toolbox.getSegmentAnnouncer().unannounceSegment(segment);
                    }
                    finally {
                        toolbox.getTaskActionClient().submit(new LockReleaseAction(segment.getInterval()));
                    }
                }

                public void announceSegments(Iterable<DataSegment> segments) throws IOException {
                    for (DataSegment segment : segments) {
                        Preconditions.checkNotNull((Object)toolbox.getTaskActionClient().submit(new LockAcquireAction(TaskLockType.EXCLUSIVE, segment.getInterval(), lockTimeoutMs)), (String)"Cannot acquire a lock for interval[%s]", (Object[])new Object[]{segment.getInterval()});
                    }
                    toolbox.getSegmentAnnouncer().announceSegments(segments);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void unannounceSegments(Iterable<DataSegment> segments) throws IOException {
                    try {
                        toolbox.getSegmentAnnouncer().unannounceSegments(segments);
                    }
                    finally {
                        for (DataSegment segment : segments) {
                            toolbox.getTaskActionClient().submit(new LockReleaseAction(segment.getInterval()));
                        }
                    }
                }
            };
            VersioningPolicy versioningPolicy = new VersioningPolicy(){

                public String getVersion(Interval interval) {
                    try {
                        LockAcquireAction action = new LockAcquireAction(TaskLockType.EXCLUSIVE, interval, lockTimeoutMs);
                        TaskLock lock = (TaskLock)Preconditions.checkNotNull((Object)toolbox.getTaskActionClient().submit(action), (String)"Cannot acquire a lock for interval[%s]", (Object[])new Object[]{interval});
                        return lock.getVersion();
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            };
            dataSchema = this.spec.getDataSchema();
            RealtimeIOConfig realtimeIOConfig = this.spec.getIOConfig();
            RealtimeTuningConfig tuningConfig = this.spec.getTuningConfig().withBasePersistDirectory(toolbox.getPersistDir()).withVersioningPolicy(versioningPolicy);
            FireDepartment fireDepartment = new FireDepartment(dataSchema, realtimeIOConfig, tuningConfig);
            this.metrics = fireDepartment.getMetrics();
            metricsMonitor = new RealtimeMetricsMonitor((List)ImmutableList.of((Object)fireDepartment), (Map)ImmutableMap.of((Object)"taskId", (Object)new String[]{this.getId()}));
            this.queryRunnerFactoryConglomerate = toolbox.getQueryRunnerFactoryConglomerate();
            RealtimePlumberSchool plumberSchool = new RealtimePlumberSchool(toolbox.getEmitter(), toolbox.getQueryRunnerFactoryConglomerate(), toolbox.getSegmentPusher(), lockingSegmentAnnouncer, (SegmentPublisher)segmentPublisher, toolbox.getSegmentHandoffNotifierFactory(), toolbox.getQueryExecutorService(), toolbox.getIndexMergerV9(), toolbox.getIndexIO(), toolbox.getCache(), toolbox.getCacheConfig(), toolbox.getObjectMapper());
            this.plumber = plumberSchool.findPlumber(dataSchema, tuningConfig, this.metrics);
            committerSupplier = null;
            File firehoseTempDir = toolbox.getFirehoseTemporaryDir();
            LookupNodeService lookupNodeService = this.getContextValue(CTX_KEY_LOOKUP_TIER) == null ? toolbox.getLookupNodeService() : new LookupNodeService((String)this.getContextValue(CTX_KEY_LOOKUP_TIER));
            discoveryDruidNode = new DiscoveryDruidNode(toolbox.getDruidNode(), "peon", (Map)ImmutableMap.of((Object)toolbox.getDataNodeService().getName(), (Object)toolbox.getDataNodeService(), (Object)lookupNodeService.getName(), (Object)lookupNodeService));
            toolbox.getDataSegmentServerAnnouncer().announce();
            toolbox.getDruidNodeAnnouncer().announce(discoveryDruidNode);
            this.plumber.startJob();
            toolbox.getMonitorScheduler().addMonitor((Monitor)metricsMonitor);
            FileUtils.forceMkdir((File)firehoseTempDir);
            FirehoseFactory firehoseFactory = this.spec.getIOConfig().getFirehoseFactory();
            boolean firehoseDrainableByClosing = this.isFirehoseDrainableByClosing(firehoseFactory);
            RealtimeIndexTask realtimeIndexTask = this;
            // MONITORENTER : realtimeIndexTask
            if (!this.gracefullyStopped) {
                this.firehose = firehoseFactory.connect(this.spec.getDataSchema().getParser(), firehoseTempDir);
                committerSupplier = Committers.supplierFromFirehose((Firehose)this.firehose);
            }
            // MONITOREXIT : realtimeIndexTask
            while (this.firehose != null && (!this.gracefullyStopped || firehoseDrainableByClosing) && this.firehose.hasMore()) {
                Plumbers.addNextRow((Supplier)committerSupplier, (Firehose)this.firehose, (Plumber)this.plumber, (boolean)tuningConfig.isReportParseExceptions(), (FireDepartmentMetrics)this.metrics);
            }
            if (!normalExit) break block40;
            try {
                if (this.firehose != null) {
                    log.info("Persisting remaining data.", new Object[0]);
                    Committer committer = (Committer)committerSupplier.get();
                    CountDownLatch persistLatch = new CountDownLatch(1);
                    this.plumber.persist(new Committer(committer, persistLatch){
                        final /* synthetic */ Committer val$committer;
                        final /* synthetic */ CountDownLatch val$persistLatch;
                        {
                            this.val$committer = committer;
                            this.val$persistLatch = countDownLatch;
                        }

                        public Object getMetadata() {
                            return this.val$committer.getMetadata();
                        }

                        public void run() {
                            try {
                                this.val$committer.run();
                            }
                            finally {
                                this.val$persistLatch.countDown();
                            }
                        }
                    });
                    persistLatch.await();
                }
                if (this.gracefullyStopped) {
                    log.info("Gracefully stopping.", new Object[0]);
                    break block40;
                }
                log.info("Finishing the job.", new Object[0]);
                RealtimeIndexTask realtimeIndexTask2 = this;
                // MONITORENTER : realtimeIndexTask2
                if (this.gracefullyStopped) {
                    log.info("Gracefully stopping.", new Object[0]);
                } else {
                    this.finishingJob = true;
                }
                // MONITOREXIT : realtimeIndexTask2
                if (this.finishingJob) {
                    this.plumber.finishJob();
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug((Throwable)interruptedException, "Interrupted while finishing the job", new Object[0]);
            }
            catch (Exception exception) {
                log.makeAlert((Throwable)exception, "Failed to finish realtime task", new Object[0]).emit();
                throw exception;
            }
            finally {
                if (this.firehose != null) {
                    CloseQuietly.close((Closeable)this.firehose);
                }
                toolbox.getMonitorScheduler().removeMonitor((Monitor)metricsMonitor);
            }
        }
        toolbox.getDataSegmentServerAnnouncer().unannounce();
        toolbox.getDruidNodeAnnouncer().unannounce(discoveryDruidNode);
        log.info("Job done!", new Object[0]);
        return TaskStatus.success(this.getId());
        catch (Throwable throwable) {
            try {
                normalExit = false;
                log.makeAlert(throwable, "Exception aborted realtime processing[%s]", new Object[]{dataSchema.getDataSource()}).emit();
                throw throwable;
            }
            catch (Throwable throwable2) {
                block41: {
                    if (normalExit) {
                        try {
                            if (this.firehose != null) {
                                log.info("Persisting remaining data.", new Object[0]);
                                Committer committer = (Committer)committerSupplier.get();
                                CountDownLatch persistLatch = new CountDownLatch(1);
                                this.plumber.persist(new /* invalid duplicate definition of identical inner class */);
                                persistLatch.await();
                            }
                            if (this.gracefullyStopped) {
                                log.info("Gracefully stopping.", new Object[0]);
                                break block41;
                            }
                            log.info("Finishing the job.", new Object[0]);
                            RealtimeIndexTask realtimeIndexTask = this;
                            // MONITORENTER : realtimeIndexTask
                            if (this.gracefullyStopped) {
                                log.info("Gracefully stopping.", new Object[0]);
                            } else {
                                this.finishingJob = true;
                            }
                            // MONITOREXIT : realtimeIndexTask
                            if (this.finishingJob) {
                                this.plumber.finishJob();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            log.debug((Throwable)interruptedException, "Interrupted while finishing the job", new Object[0]);
                        }
                        catch (Exception exception) {
                            log.makeAlert((Throwable)exception, "Failed to finish realtime task", new Object[0]).emit();
                            throw exception;
                        }
                        finally {
                            if (this.firehose != null) {
                                CloseQuietly.close((Closeable)this.firehose);
                            }
                            toolbox.getMonitorScheduler().removeMonitor((Monitor)metricsMonitor);
                        }
                    }
                }
                toolbox.getDataSegmentServerAnnouncer().unannounce();
                toolbox.getDruidNodeAnnouncer().unannounce(discoveryDruidNode);
                throw throwable2;
            }
        }
    }

    @Override
    public boolean canRestore() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGracefully() {
        try {
            RealtimeIndexTask realtimeIndexTask = this;
            synchronized (realtimeIndexTask) {
                if (!this.gracefullyStopped) {
                    this.gracefullyStopped = true;
                    if (this.firehose == null) {
                        log.info("stopGracefully: Firehose not started yet, so nothing to stop.", new Object[0]);
                    } else if (this.finishingJob) {
                        log.info("stopGracefully: Interrupting finishJob.", new Object[0]);
                        this.runThread.interrupt();
                    } else if (this.isFirehoseDrainableByClosing(this.spec.getIOConfig().getFirehoseFactory())) {
                        log.info("stopGracefully: Draining firehose.", new Object[0]);
                        this.firehose.close();
                    } else {
                        log.info("stopGracefully: Cannot drain firehose by closing, interrupting run thread.", new Object[0]);
                        this.runThread.interrupt();
                    }
                }
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @JsonIgnore
    public Firehose getFirehose() {
        return this.firehose;
    }

    @JsonIgnore
    public FireDepartmentMetrics getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="spec")
    public FireDepartment getRealtimeIngestionSchema() {
        return this.spec;
    }

    protected boolean isFirehoseDrainableByClosing(FirehoseFactory firehoseFactory) {
        return firehoseFactory instanceof EventReceiverFirehoseFactory || firehoseFactory instanceof TimedShutoffFirehoseFactory && this.isFirehoseDrainableByClosing(((TimedShutoffFirehoseFactory)firehoseFactory).getDelegateFactory()) || firehoseFactory instanceof ClippedFirehoseFactory && this.isFirehoseDrainableByClosing(((ClippedFirehoseFactory)firehoseFactory).getDelegate());
    }

    private void setupTimeoutAlert() {
        if (this.spec.getTuningConfig().getAlertTimeout() > 0L) {
            Timer timer = new Timer("RealtimeIndexTask-Timer", true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    log.makeAlert("RealtimeIndexTask for dataSource [%s] hasn't finished in configured time [%d] ms.", new Object[]{RealtimeIndexTask.this.spec.getDataSchema().getDataSource(), RealtimeIndexTask.this.spec.getTuningConfig().getAlertTimeout()}).emit();
                }
            }, this.spec.getTuningConfig().getAlertTimeout());
        }
    }

    public static class TaskActionSegmentPublisher
    implements SegmentPublisher {
        final TaskToolbox taskToolbox;

        public TaskActionSegmentPublisher(TaskToolbox taskToolbox) {
            this.taskToolbox = taskToolbox;
        }

        public void publishSegment(DataSegment segment) throws IOException {
            this.taskToolbox.publishSegments((Iterable<DataSegment>)ImmutableList.of((Object)segment));
        }
    }
}

