/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.SegmentListUnusedAction;
import io.druid.indexing.common.actions.SegmentMetadataUpdateAction;
import io.druid.indexing.common.task.AbstractFixedIntervalTask;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.logger.Logger;
import io.druid.timeline.DataSegment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.Interval;

public class RestoreTask
extends AbstractFixedIntervalTask {
    private static final Logger log = new Logger(RestoreTask.class);

    public RestoreTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="context") Map<String, Object> context) {
        super(RestoreTask.getOrMakeId(id, "restore", dataSource, interval), dataSource, interval, context);
    }

    @Override
    public String getType() {
        return "restore";
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        TaskLock myLock = (TaskLock)Iterables.getOnlyElement(RestoreTask.getTaskLocks(toolbox.getTaskActionClient()));
        if (!myLock.getDataSource().equals(this.getDataSource())) {
            throw new ISE("WTF?! Lock dataSource[%s] != task dataSource[%s]", new Object[]{myLock.getDataSource(), this.getDataSource()});
        }
        if (!myLock.getInterval().equals((Object)this.getInterval())) {
            throw new ISE("WTF?! Lock interval[%s] != task interval[%s]", new Object[]{myLock.getInterval(), this.getInterval()});
        }
        List<DataSegment> unusedSegments = toolbox.getTaskActionClient().submit(new SegmentListUnusedAction(myLock.getDataSource(), myLock.getInterval()));
        for (DataSegment unusedSegment : unusedSegments) {
            if (unusedSegment.getVersion().compareTo(myLock.getVersion()) > 0) {
                throw new ISE("WTF?! Unused segment[%s] has version[%s] > task version[%s]", new Object[]{unusedSegment.getIdentifier(), unusedSegment.getVersion(), myLock.getVersion()});
            }
            log.info("OK to restore segment: %s", new Object[]{unusedSegment.getIdentifier()});
        }
        ArrayList<DataSegment> restoredSegments = new ArrayList<DataSegment>();
        for (DataSegment segment : unusedSegments) {
            DataSegment restored = toolbox.getDataSegmentArchiver().restore(segment);
            if (restored != null) {
                restoredSegments.add(restored);
                continue;
            }
            log.info("Segment [%s] did not move, not updating metadata", new Object[]{segment});
        }
        if (restoredSegments.isEmpty()) {
            log.info("No segments restored", new Object[0]);
        } else {
            toolbox.getTaskActionClient().submit(new SegmentMetadataUpdateAction((Set<DataSegment>)ImmutableSet.copyOf(restoredSegments)));
        }
        return TaskStatus.success(this.getId());
    }
}

