/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AppendTask;
import io.druid.indexing.common.task.ArchiveTask;
import io.druid.indexing.common.task.CompactionTask;
import io.druid.indexing.common.task.ConvertSegmentBackwardsCompatibleTask;
import io.druid.indexing.common.task.ConvertSegmentTask;
import io.druid.indexing.common.task.HadoopConverterTask;
import io.druid.indexing.common.task.HadoopIndexTask;
import io.druid.indexing.common.task.IndexTask;
import io.druid.indexing.common.task.KillTask;
import io.druid.indexing.common.task.MergeTask;
import io.druid.indexing.common.task.MoveTask;
import io.druid.indexing.common.task.NoopTask;
import io.druid.indexing.common.task.RealtimeIndexTask;
import io.druid.indexing.common.task.RestoreTask;
import io.druid.indexing.common.task.SameIntervalMergeTask;
import io.druid.indexing.common.task.TaskResource;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import java.util.Map;
import javax.annotation.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="append", value=AppendTask.class), @JsonSubTypes.Type(name="merge", value=MergeTask.class), @JsonSubTypes.Type(name="kill", value=KillTask.class), @JsonSubTypes.Type(name="move", value=MoveTask.class), @JsonSubTypes.Type(name="archive", value=ArchiveTask.class), @JsonSubTypes.Type(name="restore", value=RestoreTask.class), @JsonSubTypes.Type(name="index", value=IndexTask.class), @JsonSubTypes.Type(name="index_hadoop", value=HadoopIndexTask.class), @JsonSubTypes.Type(name="hadoop_convert_segment", value=HadoopConverterTask.class), @JsonSubTypes.Type(name="hadoop_convert_segment_sub", value=HadoopConverterTask.ConverterSubTask.class), @JsonSubTypes.Type(name="index_realtime", value=RealtimeIndexTask.class), @JsonSubTypes.Type(name="noop", value=NoopTask.class), @JsonSubTypes.Type(name="version_converter", value=ConvertSegmentBackwardsCompatibleTask.class), @JsonSubTypes.Type(name="version_converter_sub", value=ConvertSegmentBackwardsCompatibleTask.SubTask.class), @JsonSubTypes.Type(name="convert_segment", value=ConvertSegmentTask.class), @JsonSubTypes.Type(name="convert_segment_sub", value=ConvertSegmentTask.SubTask.class), @JsonSubTypes.Type(name="same_interval_merge", value=SameIntervalMergeTask.class), @JsonSubTypes.Type(name="compact", value=CompactionTask.class)})
public interface Task {
    public String getId();

    public String getGroupId();

    default public int getPriority() {
        return this.getContextValue("priority", 0);
    }

    public TaskResource getTaskResource();

    public String getType();

    public String getNodeType();

    public String getDataSource();

    public <T> QueryRunner<T> getQueryRunner(Query<T> var1);

    public String getClasspathPrefix();

    public boolean isReady(TaskActionClient var1) throws Exception;

    public boolean canRestore();

    public void stopGracefully();

    public TaskStatus run(TaskToolbox var1) throws Exception;

    public Map<String, Object> getContext();

    @Nullable
    default public <ContextValueType> ContextValueType getContextValue(String key) {
        return (ContextValueType)(this.getContext() == null ? null : this.getContext().get(key));
    }

    default public <ContextValueType> ContextValueType getContextValue(String key, ContextValueType defaultValue) {
        ContextValueType value = this.getContextValue(key);
        return value == null ? defaultValue : value;
    }
}

