/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskLockType;
import io.druid.indexing.common.actions.LockTryAcquireAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.java.util.common.JodaUtils;
import io.druid.java.util.common.guava.Comparators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class Tasks {
    public static final int DEFAULT_REALTIME_TASK_PRIORITY = 75;
    public static final int DEFAULT_BATCH_INDEX_TASK_PRIORITY = 50;
    public static final int DEFAULT_MERGE_TASK_PRIORITY = 25;
    public static final int DEFAULT_TASK_PRIORITY = 0;
    public static final long DEFAULT_LOCK_TIMEOUT = 300000L;
    public static final String PRIORITY_KEY = "priority";
    public static final String LOCK_TIMEOUT_KEY = "taskLockTimeout";

    public static Map<Interval, TaskLock> tryAcquireExclusiveLocks(TaskActionClient client, SortedSet<Interval> intervals) throws IOException {
        HashMap<Interval, TaskLock> lockMap = new HashMap<Interval, TaskLock>();
        for (Interval interval : Tasks.computeCompactIntervals(intervals)) {
            TaskLock lock = (TaskLock)Preconditions.checkNotNull((Object)client.submit(new LockTryAcquireAction(TaskLockType.EXCLUSIVE, interval)), (String)"Cannot acquire a lock for interval[%s]", (Object[])new Object[]{interval});
            lockMap.put(interval, lock);
        }
        return lockMap;
    }

    public static SortedSet<Interval> computeCompactIntervals(SortedSet<Interval> intervals) {
        TreeSet<Interval> compactIntervals = new TreeSet<Interval>(Comparators.intervalsByStartThenEnd());
        ArrayList toBeAccumulated = new ArrayList();
        for (Interval interval : intervals) {
            if (toBeAccumulated.size() == 0) {
                toBeAccumulated.add(interval);
                continue;
            }
            if (((Interval)toBeAccumulated.get(toBeAccumulated.size() - 1)).abuts((ReadableInterval)interval)) {
                toBeAccumulated.add(interval);
                continue;
            }
            compactIntervals.add(JodaUtils.umbrellaInterval(toBeAccumulated));
            toBeAccumulated = Lists.newArrayList((Object[])new Interval[]{interval});
        }
        if (toBeAccumulated.size() > 0) {
            compactIntervals.add(JodaUtils.umbrellaInterval(toBeAccumulated));
        }
        return compactIntervals;
    }
}

