/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.tasklogs;

import com.google.common.base.Optional;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.inject.Inject;
import io.druid.indexing.common.config.FileTaskLogsConfig;
import io.druid.indexing.common.tasklogs.LogUtils;
import io.druid.java.util.common.IOE;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.tasklogs.TaskLogs;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class FileTaskLogs
implements TaskLogs {
    private static final Logger log = new Logger(FileTaskLogs.class);
    private final FileTaskLogsConfig config;

    @Inject
    public FileTaskLogs(FileTaskLogsConfig config) {
        this.config = config;
    }

    public void pushTaskLog(String taskid, File file) throws IOException {
        if (!this.config.getDirectory().exists() && !this.config.getDirectory().mkdirs()) {
            throw new IOE("Unable to create task log dir[%s]", new Object[]{this.config.getDirectory()});
        }
        File outputFile = this.fileForTask(taskid);
        Files.copy((File)file, (File)outputFile);
        log.info("Wrote task log to: %s", new Object[]{outputFile});
    }

    public Optional<ByteSource> streamTaskLog(String taskid, final long offset) throws IOException {
        final File file = this.fileForTask(taskid);
        if (file.exists()) {
            return Optional.of((Object)new ByteSource(){

                public InputStream openStream() throws IOException {
                    return LogUtils.streamFile(file, offset);
                }
            });
        }
        return Optional.absent();
    }

    private File fileForTask(String taskid) {
        return new File(this.config.getDirectory(), StringUtils.format((String)"%s.log", (Object[])new Object[]{taskid}));
    }

    public void killAll() throws IOException {
        log.info("Deleting all task logs from local dir [%s].", new Object[]{this.config.getDirectory().getAbsolutePath()});
        FileUtils.deleteDirectory((File)this.config.getDirectory());
    }

    public void killOlderThan(final long timestamp) throws IOException {
        File taskLogDir = this.config.getDirectory();
        if (taskLogDir.exists()) {
            File[] files;
            if (!taskLogDir.isDirectory()) {
                throw new IOE("taskLogDir [%s] must be a directory.", new Object[]{taskLogDir});
            }
            for (File file : files = taskLogDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.lastModified() < timestamp;
                }
            })) {
                log.info("Deleting local task log [%s].", new Object[]{file.getAbsolutePath()});
                FileUtils.forceDelete((File)file);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new IOException(new InterruptedException("Thread interrupted. Couldn't delete all tasklogs."));
            }
        }
    }
}

