/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import io.druid.indexing.overlord.TaskStorageQueryAdapter;
import io.druid.java.util.common.DateTimes;
import java.util.Comparator;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class IndexerMetadataStorageAdapter {
    private final TaskStorageQueryAdapter taskStorageQueryAdapter;
    private final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;

    @Inject
    public IndexerMetadataStorageAdapter(TaskStorageQueryAdapter taskStorageQueryAdapter, IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator) {
        this.taskStorageQueryAdapter = taskStorageQueryAdapter;
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
    }

    public int deletePendingSegments(String dataSource, Interval deleteInterval) {
        Optional<DateTime> minCreatedDateOfActiveTasks = this.taskStorageQueryAdapter.getActiveTasks().stream().map(task -> (DateTime)Preconditions.checkNotNull((Object)this.taskStorageQueryAdapter.getCreatedTime(task.getId()), (String)"Can't find the createdTime for task[%s]", (Object[])new Object[]{task.getId()})).min(Comparator.naturalOrder());
        Interval activeTaskInterval = new Interval((ReadableInstant)minCreatedDateOfActiveTasks.orElse(DateTimes.MAX), (ReadableInstant)DateTimes.MAX);
        Preconditions.checkArgument((!deleteInterval.overlaps((ReadableInterval)activeTaskInterval) ? 1 : 0) != 0, (String)"Cannot delete pendingSegments because there is at least one active task created at %s", (Object[])new Object[]{activeTaskInterval.getStart()});
        return this.indexerMetadataStorageCoordinator.deletePendingSegments(dataSource, deleteInterval);
    }
}

