/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.config.TaskStorageConfig;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.metadata.EntryExistsException;
import io.druid.metadata.MetadataStorageActionHandler;
import io.druid.metadata.MetadataStorageActionHandlerFactory;
import io.druid.metadata.MetadataStorageActionHandlerTypes;
import io.druid.metadata.MetadataStorageConnector;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;

public class MetadataTaskStorage
implements TaskStorage {
    private static final MetadataStorageActionHandlerTypes<Task, TaskStatus, TaskAction, TaskLock> TASK_TYPES = new MetadataStorageActionHandlerTypes<Task, TaskStatus, TaskAction, TaskLock>(){

        public TypeReference<Task> getEntryType() {
            return new TypeReference<Task>(){};
        }

        public TypeReference<TaskStatus> getStatusType() {
            return new TypeReference<TaskStatus>(){};
        }

        public TypeReference<TaskAction> getLogType() {
            return new TypeReference<TaskAction>(){};
        }

        public TypeReference<TaskLock> getLockType() {
            return new TypeReference<TaskLock>(){};
        }
    };
    private final MetadataStorageConnector metadataStorageConnector;
    private final TaskStorageConfig config;
    private final MetadataStorageActionHandler<Task, TaskStatus, TaskAction, TaskLock> handler;
    private static final EmittingLogger log = new EmittingLogger(MetadataTaskStorage.class);

    @Inject
    public MetadataTaskStorage(MetadataStorageConnector metadataStorageConnector, TaskStorageConfig config, MetadataStorageActionHandlerFactory factory) {
        this.metadataStorageConnector = metadataStorageConnector;
        this.config = config;
        this.handler = factory.create("task", TASK_TYPES);
    }

    @LifecycleStart
    public void start() {
        this.metadataStorageConnector.createTaskTables();
    }

    @LifecycleStop
    public void stop() {
    }

    @Override
    public void insert(Task task, TaskStatus status) throws EntryExistsException {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkArgument((boolean)task.getId().equals(status.getId()), (String)"Task/Status ID mismatch[%s/%s]", (Object[])new Object[]{task.getId(), status.getId()});
        log.info("Inserting task %s with status: %s", new Object[]{task.getId(), status});
        try {
            this.handler.insert(task.getId(), DateTimes.nowUtc(), task.getDataSource(), (Object)task, status.isRunnable(), (Object)status);
        }
        catch (Exception e) {
            if (e instanceof EntryExistsException) {
                throw (EntryExistsException)e;
            }
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void setStatus(TaskStatus status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        log.info("Updating task %s to status: %s", new Object[]{status.getId(), status});
        boolean set = this.handler.setStatus(status.getId(), status.isRunnable(), (Object)status);
        if (!set) {
            throw new ISE("Active task not found: %s", new Object[]{status.getId()});
        }
    }

    @Override
    public Optional<Task> getTask(String taskId) {
        return this.handler.getEntry(taskId);
    }

    @Override
    public Optional<TaskStatus> getStatus(String taskId) {
        return this.handler.getStatus(taskId);
    }

    @Override
    public List<Task> getActiveTasks() {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)this.handler.getActiveEntriesWithStatus(), (Predicate)new Predicate<Pair<Task, TaskStatus>>(){

            public boolean apply(@Nullable Pair<Task, TaskStatus> input) {
                return ((TaskStatus)input.rhs).isRunnable();
            }
        }), (Function)new Function<Pair<Task, TaskStatus>, Task>(){

            @Nullable
            public Task apply(@Nullable Pair<Task, TaskStatus> input) {
                return (Task)input.lhs;
            }
        }));
    }

    @Override
    public List<TaskStatus> getRecentlyFinishedTaskStatuses(@Nullable Integer maxTaskStatuses) {
        return ImmutableList.copyOf((Collection)this.handler.getInactiveStatusesSince(DateTimes.nowUtc().minus((ReadableDuration)this.config.getRecentlyFinishedThreshold()), maxTaskStatuses).stream().filter(TaskStatus::isComplete).collect(Collectors.toList()));
    }

    @Override
    @Nullable
    public Pair<DateTime, String> getCreatedDateTimeAndDataSource(String taskId) {
        return this.handler.getCreatedDateAndDataSource(taskId);
    }

    @Override
    public void addLock(String taskid, TaskLock taskLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLock, (Object)"taskLock");
        log.info("Adding lock on interval[%s] version[%s] for task: %s", new Object[]{taskLock.getInterval(), taskLock.getVersion(), taskid});
        this.handler.addLock(taskid, (Object)taskLock);
    }

    @Override
    public void replaceLock(String taskid, TaskLock oldLock, TaskLock newLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)oldLock, (Object)"oldLock");
        Preconditions.checkNotNull((Object)newLock, (Object)"newLock");
        log.info("Replacing lock on interval[%s] version[%s] for task: %s", new Object[]{oldLock.getInterval(), oldLock.getVersion(), taskid});
        Long oldLockId = this.handler.getLockId(taskid, (Object)oldLock);
        if (oldLockId == null) {
            throw new ISE("Cannot find lock[%s]", new Object[]{oldLock});
        }
        this.handler.replaceLock(taskid, oldLockId.longValue(), (Object)newLock);
    }

    @Override
    public void removeLock(String taskid, TaskLock taskLockToRemove) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLockToRemove, (Object)"taskLockToRemove");
        Long lockId = this.handler.getLockId(taskid, (Object)taskLockToRemove);
        if (lockId == null) {
            log.warn("Cannot find lock[%s]", new Object[]{taskLockToRemove});
        } else {
            log.info("Deleting TaskLock with id[%d]: %s", new Object[]{lockId, taskLockToRemove});
            this.handler.removeLock(lockId.longValue());
        }
    }

    @Override
    public List<TaskLock> getLocks(String taskid) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.getLocksWithIds(taskid).entrySet(), (Function)new Function<Map.Entry<Long, TaskLock>, TaskLock>(){

            public TaskLock apply(Map.Entry<Long, TaskLock> e) {
                return e.getValue();
            }
        }));
    }

    @Override
    public <T> void addAuditLog(Task task, TaskAction<T> taskAction) {
        Preconditions.checkNotNull(taskAction, (Object)"taskAction");
        log.info("Logging action for task[%s]: %s", new Object[]{task.getId(), taskAction});
        this.handler.addLog(task.getId(), taskAction);
    }

    @Override
    public List<TaskAction> getAuditLogs(String taskId) {
        return this.handler.getLogs(taskId);
    }

    private Map<Long, TaskLock> getLocksWithIds(String taskid) {
        return this.handler.getLocks(taskid);
    }
}

