/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.collect.Sets;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Pair;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.Set;

public class PortFinder {
    private final Set<Integer> usedPorts = Sets.newHashSet();
    private final int startPort;

    public PortFinder(int startPort) {
        this.startPort = startPort;
    }

    private static boolean canBind(int portNum) {
        try {
            new ServerSocket(portNum).close();
            return true;
        }
        catch (BindException be) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized int findUnusedPort() {
        int port = this.chooseNext(this.startPort);
        while (!PortFinder.canBind(port)) {
            port = this.chooseNext(port + 1);
        }
        this.usedPorts.add(port);
        return port;
    }

    public synchronized Pair<Integer, Integer> findTwoConsecutiveUnusedPorts() {
        int firstPort = this.chooseNext(this.startPort);
        while (!PortFinder.canBind(firstPort) || !PortFinder.canBind(firstPort + 1)) {
            firstPort = this.chooseNext(firstPort + 1);
        }
        this.usedPorts.add(firstPort);
        this.usedPorts.add(firstPort + 1);
        return new Pair((Object)firstPort, (Object)(firstPort + 1));
    }

    public synchronized void markPortUnused(int port) {
        this.usedPorts.remove(port);
    }

    private int chooseNext(int start) {
        for (int i = start; i <= 65535; ++i) {
            if (this.usedPorts.contains(i)) continue;
            return i;
        }
        throw new ISE("All ports are Used..", new Object[0]);
    }
}

