/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import io.druid.curator.cache.PathChildrenCacheFactory;
import io.druid.guice.annotations.EscalatedGlobal;
import io.druid.indexing.overlord.RemoteTaskRunner;
import io.druid.indexing.overlord.TaskRunnerFactory;
import io.druid.indexing.overlord.autoscaling.NoopProvisioningStrategy;
import io.druid.indexing.overlord.autoscaling.ProvisioningSchedulerConfig;
import io.druid.indexing.overlord.autoscaling.ProvisioningStrategy;
import io.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import io.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import io.druid.java.util.http.client.HttpClient;
import io.druid.server.initialization.IndexerZkConfig;
import org.apache.curator.framework.CuratorFramework;

public class RemoteTaskRunnerFactory
implements TaskRunnerFactory<RemoteTaskRunner> {
    public static final String TYPE_NAME = "remote";
    private final CuratorFramework curator;
    private final RemoteTaskRunnerConfig remoteTaskRunnerConfig;
    private final IndexerZkConfig zkPaths;
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final Supplier<WorkerBehaviorConfig> workerConfigRef;
    private final ProvisioningSchedulerConfig provisioningSchedulerConfig;
    private final ProvisioningStrategy provisioningStrategy;

    @Inject
    public RemoteTaskRunnerFactory(CuratorFramework curator, RemoteTaskRunnerConfig remoteTaskRunnerConfig, IndexerZkConfig zkPaths, ObjectMapper jsonMapper, @EscalatedGlobal HttpClient httpClient, Supplier<WorkerBehaviorConfig> workerConfigRef, ProvisioningSchedulerConfig provisioningSchedulerConfig, ProvisioningStrategy provisioningStrategy) {
        this.curator = curator;
        this.remoteTaskRunnerConfig = remoteTaskRunnerConfig;
        this.zkPaths = zkPaths;
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.workerConfigRef = workerConfigRef;
        this.provisioningSchedulerConfig = provisioningSchedulerConfig;
        this.provisioningStrategy = provisioningStrategy;
    }

    @Override
    public RemoteTaskRunner build() {
        return new RemoteTaskRunner(this.jsonMapper, this.remoteTaskRunnerConfig, this.zkPaths, this.curator, new PathChildrenCacheFactory.Builder().withCompressed(true), this.httpClient, this.workerConfigRef, this.provisioningSchedulerConfig.isDoAutoscale() ? this.provisioningStrategy : new NoopProvisioningStrategy());
    }
}

