/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskLockType;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.CriticalAction;
import io.druid.indexing.overlord.LockResult;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.guava.Comparators;
import io.druid.java.util.emitter.EmittingLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class TaskLockbox {
    private final Map<String, NavigableMap<Interval, List<TaskLockPosse>>> running = Maps.newHashMap();
    private final TaskStorage taskStorage;
    private final ReentrantLock giant = new ReentrantLock(true);
    private final Condition lockReleaseCondition = this.giant.newCondition();
    private static final EmittingLogger log = new EmittingLogger(TaskLockbox.class);
    private final Set<String> activeTasks = Sets.newHashSet();

    @Inject
    public TaskLockbox(TaskStorage taskStorage) {
        this.taskStorage = taskStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncFromStorage() {
        this.giant.lock();
        try {
            HashSet storedActiveTasks = Sets.newHashSet();
            ArrayList storedLocks = Lists.newArrayList();
            for (Task task : this.taskStorage.getActiveTasks()) {
                storedActiveTasks.add(task.getId());
                for (TaskLock taskLock : this.taskStorage.getLocks(task.getId())) {
                    storedLocks.add(Pair.of((Object)task, (Object)taskLock));
                }
            }
            Ordering<Pair<Task, TaskLock>> byVersionOrdering = new Ordering<Pair<Task, TaskLock>>(){

                public int compare(Pair<Task, TaskLock> left, Pair<Task, TaskLock> right) {
                    return ComparisonChain.start().compare((Comparable)((Object)((TaskLock)left.rhs).getVersion()), (Comparable)((Object)((TaskLock)right.rhs).getVersion())).compare((Comparable)((Object)((Task)left.lhs).getId()), (Comparable)((Object)((Task)right.lhs).getId())).result();
                }
            };
            this.running.clear();
            this.activeTasks.clear();
            this.activeTasks.addAll(storedActiveTasks);
            int taskLockCount = 0;
            for (Pair taskAndLock : byVersionOrdering.sortedCopy((Iterable)storedLocks)) {
                Task task = (Task)taskAndLock.lhs;
                TaskLock savedTaskLock = (TaskLock)taskAndLock.rhs;
                if (savedTaskLock.getInterval().toDurationMillis() <= 0L) {
                    log.warn("WTF?! Got lock with empty interval for task: %s", new Object[]{task.getId()});
                    continue;
                }
                TaskLockPosse taskLockPosse = this.createOrFindLockPosse(task, savedTaskLock.getInterval(), savedTaskLock.getVersion(), savedTaskLock.getType());
                if (taskLockPosse != null) {
                    taskLockPosse.addTask(task);
                    TaskLock taskLock = taskLockPosse.getTaskLock();
                    if (savedTaskLock.getVersion().equals(taskLock.getVersion())) {
                        ++taskLockCount;
                        log.info("Reacquired lock on interval[%s] version[%s] for task: %s", new Object[]{savedTaskLock.getInterval(), savedTaskLock.getVersion(), task.getId()});
                        continue;
                    }
                    ++taskLockCount;
                    log.info("Could not reacquire lock on interval[%s] version[%s] (got version[%s] instead) for task: %s", new Object[]{savedTaskLock.getInterval(), savedTaskLock.getVersion(), taskLock.getVersion(), task.getId()});
                    continue;
                }
                throw new ISE("Could not reacquire lock on interval[%s] version[%s] for task: %s", new Object[]{savedTaskLock.getInterval(), savedTaskLock.getVersion(), task.getId()});
            }
            log.info("Synced %,d locks for %,d activeTasks from storage (%,d locks ignored).", new Object[]{taskLockCount, this.activeTasks.size(), storedLocks.size() - taskLockCount});
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResult lock(TaskLockType lockType, Task task, Interval interval) throws InterruptedException {
        this.giant.lockInterruptibly();
        try {
            LockResult lockResult;
            while (!(lockResult = this.tryLock(lockType, task, interval)).isOk()) {
                if (lockResult.isRevoked()) {
                    LockResult lockResult2 = lockResult;
                    return lockResult2;
                }
                this.lockReleaseCondition.await();
            }
            LockResult lockResult3 = lockResult;
            return lockResult3;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResult lock(TaskLockType lockType, Task task, Interval interval, long timeoutMs) throws InterruptedException {
        long nanos = TimeUnit.MILLISECONDS.toNanos(timeoutMs);
        this.giant.lockInterruptibly();
        try {
            LockResult lockResult;
            while (!(lockResult = this.tryLock(lockType, task, interval)).isOk()) {
                if (nanos <= 0L || lockResult.isRevoked()) {
                    LockResult lockResult2 = lockResult;
                    return lockResult2;
                }
                nanos = this.lockReleaseCondition.awaitNanos(nanos);
            }
            LockResult lockResult3 = lockResult;
            return lockResult3;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public LockResult tryLock(TaskLockType lockType, Task task, Interval interval) {
        this.giant.lock();
        try {
            if (!this.activeTasks.contains(task.getId())) {
                throw new ISE("Unable to grant lock to inactive Task [%s]", new Object[]{task.getId()});
            }
            Preconditions.checkArgument((interval.toDurationMillis() > 0L ? 1 : 0) != 0, (Object)"interval empty");
            TaskLockPosse posseToUse = this.createOrFindLockPosse(task, interval, lockType);
            if (posseToUse != null && !posseToUse.getTaskLock().isRevoked()) {
                if (posseToUse.addTask(task)) {
                    log.info("Added task[%s] to TaskLock[%s]", new Object[]{task.getId(), posseToUse.getTaskLock().getGroupId()});
                    try {
                        this.taskStorage.addLock(task.getId(), posseToUse.getTaskLock());
                        LockResult lockResult = LockResult.ok(posseToUse.getTaskLock());
                        return lockResult;
                    }
                    catch (Exception e) {
                        log.makeAlert("Failed to persist lock in storage", new Object[0]).addData("task", (Object)task.getId()).addData("dataSource", (Object)posseToUse.getTaskLock().getDataSource()).addData("interval", (Object)posseToUse.getTaskLock().getInterval()).addData("version", (Object)posseToUse.getTaskLock().getVersion()).emit();
                        this.unlock(task, interval);
                        LockResult lockResult = LockResult.fail(false);
                        this.giant.unlock();
                        return lockResult;
                    }
                }
                log.info("Task[%s] already present in TaskLock[%s]", new Object[]{task.getId(), posseToUse.getTaskLock().getGroupId()});
                LockResult e = LockResult.ok(posseToUse.getTaskLock());
                return e;
            }
            boolean lockRevoked = posseToUse != null && posseToUse.getTaskLock().isRevoked();
            LockResult lockResult = LockResult.fail(lockRevoked);
            return lockResult;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    @Nullable
    private TaskLockPosse createOrFindLockPosse(Task task, Interval interval, TaskLockType lockType) {
        return this.createOrFindLockPosse(task, interval, null, lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TaskLockPosse createOrFindLockPosse(Task task, Interval interval, @Nullable String preferredVersion, TaskLockType lockType) {
        this.giant.lock();
        try {
            String dataSource = task.getDataSource();
            int priority = task.getPriority();
            List<TaskLockPosse> foundPosses = this.findLockPossesOverlapsInterval(dataSource, interval);
            if (foundPosses.size() > 0) {
                List filteredPosses = foundPosses.stream().filter(posse -> TaskLockbox.matchGroupIdAndContainInterval(((TaskLockPosse)posse).taskLock, task, interval)).collect(Collectors.toList());
                if (filteredPosses.size() == 0) {
                    if (lockType.equals((Object)TaskLockType.SHARED) && TaskLockbox.isAllSharedLocks(foundPosses)) {
                        TaskLockPosse taskLockPosse = this.createNewTaskLockPosse(lockType, task.getGroupId(), dataSource, interval, preferredVersion, priority);
                        return taskLockPosse;
                    }
                    if (TaskLockbox.isAllRevocable(foundPosses, priority)) {
                        foundPosses.forEach(this::revokeLock);
                        TaskLockPosse taskLockPosse = this.createNewTaskLockPosse(lockType, task.getGroupId(), dataSource, interval, preferredVersion, priority);
                        return taskLockPosse;
                    }
                    log.info("Cannot create a new taskLockPosse because some locks of same or higher priorities exist", new Object[0]);
                    TaskLockPosse taskLockPosse = null;
                    return taskLockPosse;
                }
                if (filteredPosses.size() == 1) {
                    TaskLockPosse foundPosse = (TaskLockPosse)filteredPosses.get(0);
                    if (lockType.equals((Object)foundPosse.getTaskLock().getType())) {
                        TaskLockPosse taskLockPosse = foundPosse;
                        return taskLockPosse;
                    }
                    throw new ISE("Task[%s] already acquired a lock for interval[%s] but different type[%s]", new Object[]{task.getId(), interval, foundPosse.getTaskLock().getType()});
                }
                throw new ISE("Task group[%s] has multiple locks for the same interval[%s]?", new Object[]{task.getGroupId(), interval});
            }
            TaskLockPosse taskLockPosse = this.createNewTaskLockPosse(lockType, task.getGroupId(), dataSource, interval, preferredVersion, priority);
            return taskLockPosse;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskLockPosse createNewTaskLockPosse(TaskLockType lockType, String groupId, String dataSource, Interval interval, @Nullable String preferredVersion, int priority) {
        this.giant.lock();
        try {
            String version = preferredVersion != null ? preferredVersion : DateTimes.nowUtc().toString();
            TaskLockPosse posseToUse = new TaskLockPosse(new TaskLock(lockType, groupId, dataSource, interval, version, priority));
            this.running.computeIfAbsent(dataSource, k -> new TreeMap(Comparators.intervalsByStartThenEnd())).computeIfAbsent(interval, k -> new ArrayList()).add(posseToUse);
            TaskLockPosse taskLockPosse = posseToUse;
            return taskLockPosse;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doInCriticalSection(Task task, List<Interval> intervals, CriticalAction<T> action) throws Exception {
        this.giant.lockInterruptibly();
        try {
            T t = action.perform(this.isTaskLocksValid(task, intervals));
            return t;
        }
        finally {
            this.giant.unlock();
        }
    }

    private boolean isTaskLocksValid(Task task, List<Interval> intervals) {
        return intervals.stream().allMatch(interval -> {
            TaskLock lock = this.getOnlyTaskLockPosseContainingInterval(task, (Interval)interval).getTaskLock();
            return !lock.isRevoked() && lock.getType() != TaskLockType.SHARED;
        });
    }

    private void revokeLock(TaskLockPosse lockPosse) {
        this.giant.lock();
        try {
            lockPosse.forEachTask(taskId -> this.revokeLock((String)taskId, lockPosse.getTaskLock()));
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeLock(String taskId, TaskLock lock) {
        this.giant.lock();
        try {
            if (!this.activeTasks.contains(taskId)) {
                throw new ISE("Cannot revoke lock for inactive task[%s]", new Object[]{taskId});
            }
            Task task = (Task)this.taskStorage.getTask(taskId).orNull();
            if (task == null) {
                throw new ISE("Cannot revoke lock for unknown task[%s]", new Object[]{taskId});
            }
            log.info("Revoking task lock[%s] for task[%s]", new Object[]{lock, taskId});
            if (lock.isRevoked()) {
                log.warn("TaskLock[%s] is already revoked", new Object[]{lock});
            } else {
                TaskLock revokedLock = lock.revokedCopy();
                this.taskStorage.replaceLock(taskId, lock, revokedLock);
                List possesHolder = (List)this.running.get(task.getDataSource()).get(lock.getInterval());
                TaskLockPosse foundPosse = possesHolder.stream().filter(posse -> posse.getTaskLock().equals(lock)).findFirst().orElseThrow(() -> new ISE("Failed to find lock posse for lock[%s]", new Object[]{lock}));
                possesHolder.remove(foundPosse);
                possesHolder.add(foundPosse.withTaskLock(revokedLock));
                log.info("Revoked taskLock[%s]", new Object[]{lock});
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    public List<TaskLock> findLocksForTask(Task task) {
        this.giant.lock();
        try {
            List list = Lists.transform(this.findLockPossesForTask(task), (Function)new Function<TaskLockPosse, TaskLock>(){

                public TaskLock apply(TaskLockPosse taskLockPosse) {
                    return taskLockPosse.getTaskLock();
                }
            });
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Task task, Interval interval) {
        this.giant.lock();
        try {
            String dataSource = task.getDataSource();
            NavigableMap<Interval, List<TaskLockPosse>> dsRunning = this.running.get(task.getDataSource());
            if (dsRunning == null || dsRunning.isEmpty()) {
                return;
            }
            List possesHolder = (List)dsRunning.get(interval);
            if (possesHolder == null || possesHolder.isEmpty()) {
                return;
            }
            List posses = possesHolder.stream().filter(posse -> posse.containsTask(task)).collect(Collectors.toList());
            for (TaskLockPosse taskLockPosse : posses) {
                TaskLock taskLock = taskLockPosse.getTaskLock();
                log.info("Removing task[%s] from TaskLock[%s]", new Object[]{task.getId(), taskLock.getGroupId()});
                boolean removed = taskLockPosse.removeTask(task);
                if (taskLockPosse.isTasksEmpty()) {
                    log.info("TaskLock is now empty: %s", new Object[]{taskLock});
                    possesHolder.remove(taskLockPosse);
                }
                if (possesHolder.size() == 0) {
                    dsRunning.remove(interval);
                }
                if (this.running.get(dataSource).size() == 0) {
                    this.running.remove(dataSource);
                }
                this.lockReleaseCondition.signalAll();
                try {
                    this.taskStorage.removeLock(task.getId(), taskLock);
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to clean up lock from storage", new Object[0]).addData("task", (Object)task.getId()).addData("dataSource", (Object)taskLock.getDataSource()).addData("interval", (Object)taskLock.getInterval()).addData("version", (Object)taskLock.getVersion()).emit();
                }
                if (removed) continue;
                log.makeAlert("Lock release without acquire", new Object[0]).addData("task", (Object)task.getId()).addData("interval", (Object)interval).emit();
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Task task) {
        this.giant.lock();
        try {
            try {
                log.info("Removing task[%s] from activeTasks", new Object[]{task.getId()});
                for (TaskLockPosse taskLockPosse : this.findLockPossesForTask(task)) {
                    this.unlock(task, taskLockPosse.getTaskLock().getInterval());
                }
            }
            finally {
                this.activeTasks.remove(task.getId());
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskLockPosse> findLockPossesForTask(Task task) {
        this.giant.lock();
        try {
            NavigableMap<Interval, List<TaskLockPosse>> dsRunning = this.running.get(task.getDataSource());
            if (dsRunning == null) {
                ImmutableList immutableList = ImmutableList.of();
                return immutableList;
            }
            List<TaskLockPosse> list = dsRunning.values().stream().flatMap(Collection::stream).filter(taskLockPosse -> taskLockPosse.containsTask(task)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskLockPosse> findLockPossesContainingInterval(String dataSource, Interval interval) {
        this.giant.lock();
        try {
            List<TaskLockPosse> intervalOverlapsPosses = this.findLockPossesOverlapsInterval(dataSource, interval);
            List<TaskLockPosse> list = intervalOverlapsPosses.stream().filter(taskLockPosse -> ((TaskLockPosse)taskLockPosse).taskLock.getInterval().contains((ReadableInterval)interval)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskLockPosse> findLockPossesOverlapsInterval(String dataSource, Interval interval) {
        this.giant.lock();
        try {
            NavigableMap<Interval, List<TaskLockPosse>> dsRunning = this.running.get(dataSource);
            if (dsRunning == null) {
                List<TaskLockPosse> list = Collections.emptyList();
                return list;
            }
            NavigableSet<Interval> dsLockbox = dsRunning.navigableKeySet();
            Iterable searchIntervals = Iterables.concat(Collections.singletonList(dsLockbox.floor(new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)DateTimes.MAX))), dsLockbox.subSet(new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)DateTimes.MAX), false, new Interval((ReadableInstant)interval.getEnd(), (ReadableInstant)interval.getEnd()), false));
            List<TaskLockPosse> list = StreamSupport.stream(searchIntervals.spliterator(), false).filter(searchInterval -> searchInterval != null && searchInterval.overlaps((ReadableInterval)interval)).flatMap(searchInterval -> ((List)dsRunning.get(searchInterval)).stream()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    public void add(Task task) {
        this.giant.lock();
        try {
            log.info("Adding task[%s] to activeTasks", new Object[]{task.getId()});
            this.activeTasks.add(task.getId());
        }
        finally {
            this.giant.unlock();
        }
    }

    private static boolean matchGroupIdAndContainInterval(TaskLock existingLock, Task task, Interval interval) {
        return existingLock.getInterval().contains((ReadableInterval)interval) && existingLock.getGroupId().equals(task.getGroupId());
    }

    private static boolean isAllSharedLocks(List<TaskLockPosse> lockPosses) {
        return lockPosses.stream().allMatch(taskLockPosse -> taskLockPosse.getTaskLock().getType().equals((Object)TaskLockType.SHARED));
    }

    private static boolean isAllRevocable(List<TaskLockPosse> lockPosses, int tryLockPriority) {
        return lockPosses.stream().allMatch(taskLockPosse -> TaskLockbox.isRevocable(taskLockPosse, tryLockPriority));
    }

    private static boolean isRevocable(TaskLockPosse lockPosse, int tryLockPriority) {
        TaskLock existingLock = lockPosse.getTaskLock();
        return existingLock.isRevoked() || existingLock.getPriority() < tryLockPriority;
    }

    private TaskLockPosse getOnlyTaskLockPosseContainingInterval(Task task, Interval interval) {
        List filteredPosses = this.findLockPossesContainingInterval(task.getDataSource(), interval).stream().filter(lockPosse -> lockPosse.containsTask(task)).collect(Collectors.toList());
        if (filteredPosses.isEmpty()) {
            throw new ISE("Cannot find locks for task[%s] and interval[%s]", new Object[]{task.getId(), interval});
        }
        if (filteredPosses.size() > 1) {
            throw new ISE("There are multiple lockPosses for task[%s] and interval[%s]?", new Object[]{task.getId(), interval});
        }
        return (TaskLockPosse)filteredPosses.get(0);
    }

    @VisibleForTesting
    Set<String> getActiveTasks() {
        return this.activeTasks;
    }

    @VisibleForTesting
    public Map<String, NavigableMap<Interval, List<TaskLockPosse>>> getAllLocks() {
        return this.running;
    }

    static class TaskLockPosse {
        private final TaskLock taskLock;
        private final Set<String> taskIds;

        TaskLockPosse(TaskLock taskLock) {
            this.taskLock = taskLock;
            this.taskIds = new HashSet<String>();
        }

        private TaskLockPosse(TaskLock taskLock, Set<String> taskIds) {
            this.taskLock = taskLock;
            this.taskIds = new HashSet<String>(taskIds);
        }

        TaskLockPosse withTaskLock(TaskLock taskLock) {
            return new TaskLockPosse(taskLock, this.taskIds);
        }

        TaskLock getTaskLock() {
            return this.taskLock;
        }

        boolean addTask(Task task) {
            Preconditions.checkArgument((boolean)this.taskLock.getGroupId().equals(task.getGroupId()));
            Preconditions.checkArgument((this.taskLock.getPriority() == task.getPriority() ? 1 : 0) != 0);
            return this.taskIds.add(task.getId());
        }

        boolean containsTask(Task task) {
            Preconditions.checkNotNull((Object)task, (Object)"task");
            return this.taskIds.contains(task.getId());
        }

        boolean removeTask(Task task) {
            Preconditions.checkNotNull((Object)task, (Object)"task");
            return this.taskIds.remove(task.getId());
        }

        boolean isTasksEmpty() {
            return this.taskIds.isEmpty();
        }

        void forEachTask(Consumer<String> action) {
            Preconditions.checkNotNull(action);
            this.taskIds.forEach(action);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            TaskLockPosse that = (TaskLockPosse)o;
            if (!this.taskLock.equals(that.taskLock)) {
                return false;
            }
            return this.taskIds.equals(that.taskIds);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.taskLock, this.taskIds});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("taskLock", (Object)this.taskLock).add("taskIds", this.taskIds).toString();
        }
    }
}

