/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.druid.client.indexing.IndexingService;
import io.druid.curator.discovery.ServiceAnnouncer;
import io.druid.discovery.DruidLeaderSelector;
import io.druid.guice.annotations.Self;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskLockbox;
import io.druid.indexing.overlord.TaskQueue;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerFactory;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.indexing.overlord.autoscaling.ScalingStats;
import io.druid.indexing.overlord.config.TaskQueueConfig;
import io.druid.indexing.overlord.helpers.OverlordHelperManager;
import io.druid.indexing.overlord.supervisor.SupervisorManager;
import io.druid.java.util.common.lifecycle.Lifecycle;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.server.DruidNode;
import io.druid.server.coordinator.CoordinatorOverlordServiceConfig;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class TaskMaster {
    private final DruidLeaderSelector overlordLeaderSelector;
    private final DruidLeaderSelector.Listener leadershipListener;
    private final ReentrantLock giant = new ReentrantLock(true);
    private final TaskActionClientFactory taskActionClientFactory;
    private final SupervisorManager supervisorManager;
    private final AtomicReference<Lifecycle> leaderLifecycleRef = new AtomicReference<Object>(null);
    private volatile TaskRunner taskRunner;
    private volatile TaskQueue taskQueue;
    private static final EmittingLogger log = new EmittingLogger(TaskMaster.class);

    @Inject
    public TaskMaster(final TaskQueueConfig taskQueueConfig, final TaskLockbox taskLockbox, final TaskStorage taskStorage, final TaskActionClientFactory taskActionClientFactory, @Self DruidNode selfNode, final TaskRunnerFactory runnerFactory, final ServiceAnnouncer serviceAnnouncer, CoordinatorOverlordServiceConfig coordinatorOverlordServiceConfig, final ServiceEmitter emitter, final SupervisorManager supervisorManager, final OverlordHelperManager overlordHelperManager, @IndexingService DruidLeaderSelector overlordLeaderSelector) {
        this.supervisorManager = supervisorManager;
        this.taskActionClientFactory = taskActionClientFactory;
        this.overlordLeaderSelector = overlordLeaderSelector;
        final DruidNode node = coordinatorOverlordServiceConfig.getOverlordService() == null ? selfNode : selfNode.withService(coordinatorOverlordServiceConfig.getOverlordService());
        this.leadershipListener = new DruidLeaderSelector.Listener(){

            public void becomeLeader() {
                TaskMaster.this.giant.lock();
                log.info("By the power of Grayskull, I have the power!", new Object[0]);
                try {
                    taskLockbox.syncFromStorage();
                    TaskMaster.this.taskRunner = runnerFactory.build();
                    TaskMaster.this.taskQueue = new TaskQueue(taskQueueConfig, taskStorage, TaskMaster.this.taskRunner, taskActionClientFactory, taskLockbox, emitter);
                    Lifecycle leaderLifecycle = new Lifecycle();
                    if (TaskMaster.this.leaderLifecycleRef.getAndSet(leaderLifecycle) != null) {
                        log.makeAlert("TaskMaster set a new Lifecycle without the old one being cleared!  Race condition", new Object[0]).emit();
                    }
                    leaderLifecycle.addManagedInstance((Object)TaskMaster.this.taskRunner);
                    leaderLifecycle.addManagedInstance((Object)TaskMaster.this.taskQueue);
                    leaderLifecycle.addManagedInstance((Object)supervisorManager);
                    leaderLifecycle.addManagedInstance((Object)overlordHelperManager);
                    leaderLifecycle.addHandler(new Lifecycle.Handler(){

                        public void start() throws Exception {
                            serviceAnnouncer.announce(node);
                        }

                        public void stop() {
                            serviceAnnouncer.unannounce(node);
                        }
                    });
                    leaderLifecycle.start();
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
                finally {
                    TaskMaster.this.giant.unlock();
                }
            }

            public void stopBeingLeader() {
                TaskMaster.this.giant.lock();
                try {
                    Lifecycle leaderLifecycle = TaskMaster.this.leaderLifecycleRef.getAndSet(null);
                    if (leaderLifecycle != null) {
                        leaderLifecycle.stop();
                    }
                }
                finally {
                    TaskMaster.this.giant.unlock();
                }
            }
        };
    }

    @LifecycleStart
    public void start() {
        this.giant.lock();
        try {
            this.overlordLeaderSelector.registerListener(this.leadershipListener);
        }
        finally {
            this.giant.unlock();
        }
    }

    @LifecycleStop
    public void stop() {
        this.giant.lock();
        try {
            this.overlordLeaderSelector.unregisterListener();
        }
        finally {
            this.giant.unlock();
        }
    }

    public boolean isLeader() {
        return this.overlordLeaderSelector.isLeader();
    }

    public String getCurrentLeader() {
        return this.overlordLeaderSelector.getCurrentLeader();
    }

    public Optional<TaskRunner> getTaskRunner() {
        if (this.overlordLeaderSelector.isLeader()) {
            return Optional.of((Object)this.taskRunner);
        }
        return Optional.absent();
    }

    public Optional<TaskQueue> getTaskQueue() {
        if (this.overlordLeaderSelector.isLeader()) {
            return Optional.of((Object)this.taskQueue);
        }
        return Optional.absent();
    }

    public Optional<TaskActionClient> getTaskActionClient(Task task) {
        if (this.overlordLeaderSelector.isLeader()) {
            return Optional.of((Object)this.taskActionClientFactory.create(task));
        }
        return Optional.absent();
    }

    public Optional<ScalingStats> getScalingStats() {
        if (this.overlordLeaderSelector.isLeader()) {
            return this.taskRunner.getScalingStats();
        }
        return Optional.absent();
    }

    public Optional<SupervisorManager> getSupervisorManager() {
        if (this.overlordLeaderSelector.isLeader()) {
            return Optional.of((Object)this.supervisorManager);
        }
        return Optional.absent();
    }
}

