/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.SegmentInsertAction;
import io.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.java.util.common.Pair;
import io.druid.timeline.DataSegment;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class TaskStorageQueryAdapter {
    private final TaskStorage storage;

    @Inject
    public TaskStorageQueryAdapter(TaskStorage storage) {
        this.storage = storage;
    }

    public List<Task> getActiveTasks() {
        return this.storage.getActiveTasks();
    }

    public List<TaskStatus> getRecentlyFinishedTaskStatuses(@Nullable Integer maxTaskStatuses) {
        return this.storage.getRecentlyFinishedTaskStatuses(maxTaskStatuses);
    }

    @Nullable
    public DateTime getCreatedTime(String taskId) {
        Pair<DateTime, String> pair = this.storage.getCreatedDateTimeAndDataSource(taskId);
        return pair == null ? null : (DateTime)pair.lhs;
    }

    public Optional<Task> getTask(String taskid) {
        return this.storage.getTask(taskid);
    }

    public Optional<TaskStatus> getStatus(String taskid) {
        return this.storage.getStatus(taskid);
    }

    public Set<DataSegment> getInsertedSegments(String taskid) {
        HashSet segments = Sets.newHashSet();
        for (TaskAction action : this.storage.getAuditLogs(taskid)) {
            if (action instanceof SegmentInsertAction) {
                segments.addAll(((SegmentInsertAction)action).getSegments());
                continue;
            }
            if (!(action instanceof SegmentTransactionalInsertAction)) continue;
            segments.addAll(((SegmentTransactionalInsertAction)action).getSegments());
        }
        return segments;
    }
}

