/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.autoscaling;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.druid.indexing.overlord.ImmutableWorkerInfo;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.overlord.WorkerTaskRunner;
import io.druid.indexing.overlord.autoscaling.AbstractWorkerProvisioningStrategy;
import io.druid.indexing.overlord.autoscaling.AutoScalingData;
import io.druid.indexing.overlord.autoscaling.PendingTaskBasedWorkerProvisioningStrategy;
import io.druid.indexing.overlord.autoscaling.Provisioner;
import io.druid.indexing.overlord.autoscaling.ProvisioningSchedulerConfig;
import io.druid.indexing.overlord.autoscaling.ProvisioningUtil;
import io.druid.indexing.overlord.autoscaling.ScalingStats;
import io.druid.indexing.overlord.autoscaling.SimpleWorkerProvisioningConfig;
import io.druid.indexing.overlord.setup.DefaultWorkerBehaviorConfig;
import io.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import io.druid.indexing.worker.Worker;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.concurrent.ScheduledExecutors;
import io.druid.java.util.emitter.EmittingLogger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class SimpleWorkerProvisioningStrategy
extends AbstractWorkerProvisioningStrategy {
    private static final EmittingLogger log = new EmittingLogger(SimpleWorkerProvisioningStrategy.class);
    private final SimpleWorkerProvisioningConfig config;
    private final Supplier<WorkerBehaviorConfig> workerConfigRef;

    @Inject
    public SimpleWorkerProvisioningStrategy(SimpleWorkerProvisioningConfig config, Supplier<WorkerBehaviorConfig> workerConfigRef, ProvisioningSchedulerConfig provisioningSchedulerConfig) {
        this(config, workerConfigRef, provisioningSchedulerConfig, new Supplier<ScheduledExecutorService>(){

            public ScheduledExecutorService get() {
                return ScheduledExecutors.fixed((int)1, (String)"SimpleResourceManagement-manager--%d");
            }
        });
    }

    public SimpleWorkerProvisioningStrategy(SimpleWorkerProvisioningConfig config, Supplier<WorkerBehaviorConfig> workerConfigRef, ProvisioningSchedulerConfig provisioningSchedulerConfig, Supplier<ScheduledExecutorService> execFactory) {
        super(provisioningSchedulerConfig, execFactory);
        this.config = config;
        this.workerConfigRef = workerConfigRef;
    }

    @Override
    public Provisioner makeProvisioner(WorkerTaskRunner runner) {
        return new SimpleProvisioner(runner);
    }

    private class SimpleProvisioner
    implements Provisioner {
        private final WorkerTaskRunner runner;
        private final ScalingStats scalingStats;
        private final Set<String> currentlyProvisioning;
        private final Set<String> currentlyTerminating;
        private int targetWorkerCount;
        private DateTime lastProvisionTime;
        private DateTime lastTerminateTime;

        SimpleProvisioner(WorkerTaskRunner runner) {
            this.scalingStats = new ScalingStats(SimpleWorkerProvisioningStrategy.this.config.getNumEventsToTrack());
            this.currentlyProvisioning = Sets.newHashSet();
            this.currentlyTerminating = Sets.newHashSet();
            this.targetWorkerCount = -1;
            this.lastTerminateTime = this.lastProvisionTime = DateTimes.nowUtc();
            this.runner = runner;
        }

        @Override
        public synchronized boolean doProvision() {
            AutoScalingData provisioned;
            Collection<? extends TaskRunnerWorkItem> pendingTasks = this.runner.getPendingTasks();
            Collection<ImmutableWorkerInfo> workers = this.runner.getWorkers();
            boolean didProvision = false;
            DefaultWorkerBehaviorConfig workerConfig = PendingTaskBasedWorkerProvisioningStrategy.getDefaultWorkerBehaviorConfig((Supplier<WorkerBehaviorConfig>)SimpleWorkerProvisioningStrategy.this.workerConfigRef, "provision", log);
            if (workerConfig == null) {
                return false;
            }
            Predicate<ImmutableWorkerInfo> isValidWorker = ProvisioningUtil.createValidWorkerPredicate(SimpleWorkerProvisioningStrategy.this.config);
            int currValidWorkers = Collections2.filter(workers, isValidWorker).size();
            List<String> workerNodeIds = workerConfig.getAutoScaler().ipToIdLookup(Lists.newArrayList((Iterable)Iterables.transform(workers, (Function)new Function<ImmutableWorkerInfo, String>(){

                public String apply(ImmutableWorkerInfo input) {
                    return input.getWorker().getIp();
                }
            })));
            this.currentlyProvisioning.removeAll(workerNodeIds);
            this.updateTargetWorkerCount(workerConfig, pendingTasks, workers);
            for (int want = this.targetWorkerCount - (currValidWorkers + this.currentlyProvisioning.size()); want > 0; want -= provisioned.getNodeIds().size()) {
                List<String> newNodes;
                provisioned = workerConfig.getAutoScaler().provision();
                if (provisioned == null || (newNodes = provisioned.getNodeIds()).isEmpty()) {
                    log.warn("NewNodes is empty, returning from provision loop", new Object[0]);
                    break;
                }
                this.currentlyProvisioning.addAll(newNodes);
                this.lastProvisionTime = DateTimes.nowUtc();
                this.scalingStats.addProvisionEvent(provisioned);
                didProvision = true;
            }
            if (!this.currentlyProvisioning.isEmpty()) {
                Duration durSinceLastProvision = new Duration((ReadableInstant)this.lastProvisionTime, (ReadableInstant)DateTimes.nowUtc());
                log.info("%s provisioning. Current wait time: %s", new Object[]{this.currentlyProvisioning, durSinceLastProvision});
                if (durSinceLastProvision.isLongerThan((ReadableDuration)SimpleWorkerProvisioningStrategy.this.config.getMaxScalingDuration().toStandardDuration())) {
                    log.makeAlert("Worker node provisioning taking too long!", new Object[0]).addData("millisSinceLastProvision", (Object)durSinceLastProvision.getMillis()).addData("provisioningCount", (Object)this.currentlyProvisioning.size()).emit();
                    workerConfig.getAutoScaler().terminateWithIds(Lists.newArrayList(this.currentlyProvisioning));
                    this.currentlyProvisioning.clear();
                }
            }
            return didProvision;
        }

        @Override
        public synchronized boolean doTerminate() {
            Collection<? extends TaskRunnerWorkItem> pendingTasks = this.runner.getPendingTasks();
            DefaultWorkerBehaviorConfig workerConfig = PendingTaskBasedWorkerProvisioningStrategy.getDefaultWorkerBehaviorConfig((Supplier<WorkerBehaviorConfig>)SimpleWorkerProvisioningStrategy.this.workerConfigRef, "terminate", log);
            if (workerConfig == null) {
                return false;
            }
            boolean didTerminate = false;
            HashSet workerNodeIds = Sets.newHashSet(workerConfig.getAutoScaler().ipToIdLookup(Lists.newArrayList((Iterable)Iterables.transform(this.runner.getLazyWorkers(), (Function)new Function<Worker, String>(){

                public String apply(Worker input) {
                    return input.getIp();
                }
            }))));
            this.currentlyTerminating.retainAll(workerNodeIds);
            Collection<ImmutableWorkerInfo> workers = this.runner.getWorkers();
            this.updateTargetWorkerCount(workerConfig, pendingTasks, workers);
            if (this.currentlyTerminating.isEmpty()) {
                int excessWorkers = workers.size() + this.currentlyProvisioning.size() - this.targetWorkerCount;
                if (excessWorkers > 0) {
                    Predicate<ImmutableWorkerInfo> isLazyWorker = ProvisioningUtil.createLazyWorkerPredicate(SimpleWorkerProvisioningStrategy.this.config);
                    Collection laziestWorkerIps = Collections2.transform(this.runner.markWorkersLazy(isLazyWorker, excessWorkers), (Function)new Function<Worker, String>(){

                        public String apply(Worker worker) {
                            return worker.getIp();
                        }
                    });
                    if (laziestWorkerIps.isEmpty()) {
                        log.info("Wanted to terminate %,d workers, but couldn't find any lazy ones!", new Object[]{excessWorkers});
                    } else {
                        log.info("Terminating %,d workers (wanted %,d): %s", new Object[]{laziestWorkerIps.size(), excessWorkers, Joiner.on((String)", ").join((Iterable)laziestWorkerIps)});
                        AutoScalingData terminated = workerConfig.getAutoScaler().terminate((List<String>)ImmutableList.copyOf((Collection)laziestWorkerIps));
                        if (terminated != null) {
                            this.currentlyTerminating.addAll(terminated.getNodeIds());
                            this.lastTerminateTime = DateTimes.nowUtc();
                            this.scalingStats.addTerminateEvent(terminated);
                            didTerminate = true;
                        }
                    }
                }
            } else {
                Duration durSinceLastTerminate = new Duration((ReadableInstant)this.lastTerminateTime, (ReadableInstant)DateTimes.nowUtc());
                log.info("%s terminating. Current wait time: %s", new Object[]{this.currentlyTerminating, durSinceLastTerminate});
                if (durSinceLastTerminate.isLongerThan((ReadableDuration)SimpleWorkerProvisioningStrategy.this.config.getMaxScalingDuration().toStandardDuration())) {
                    log.makeAlert("Worker node termination taking too long!", new Object[0]).addData("millisSinceLastTerminate", (Object)durSinceLastTerminate.getMillis()).addData("terminatingCount", (Object)this.currentlyTerminating.size()).emit();
                    this.currentlyTerminating.clear();
                }
            }
            return didTerminate;
        }

        private void updateTargetWorkerCount(DefaultWorkerBehaviorConfig workerConfig, Collection<? extends TaskRunnerWorkItem> pendingTasks, Collection<ImmutableWorkerInfo> zkWorkers) {
            boolean shouldScaleDown;
            int maxWorkerCount;
            Collection validWorkers = Collections2.filter(zkWorkers, ProvisioningUtil.createValidWorkerPredicate(SimpleWorkerProvisioningStrategy.this.config));
            Predicate<ImmutableWorkerInfo> isLazyWorker = ProvisioningUtil.createLazyWorkerPredicate(SimpleWorkerProvisioningStrategy.this.config);
            int minWorkerCount = workerConfig.getAutoScaler().getMinNumWorkers();
            if (minWorkerCount > (maxWorkerCount = workerConfig.getAutoScaler().getMaxNumWorkers())) {
                log.error("Huh? minWorkerCount[%d] > maxWorkerCount[%d]. I give up!", new Object[]{minWorkerCount, maxWorkerCount});
                return;
            }
            if (this.targetWorkerCount < 0) {
                this.targetWorkerCount = Math.max(Math.min(zkWorkers.size(), maxWorkerCount), minWorkerCount);
                log.info("Starting with a target of %,d workers (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            }
            boolean notTakingActions = this.currentlyProvisioning.isEmpty() && this.currentlyTerminating.isEmpty();
            boolean shouldScaleUp = notTakingActions && validWorkers.size() >= this.targetWorkerCount && this.targetWorkerCount < maxWorkerCount && (this.hasTaskPendingBeyondThreshold(pendingTasks) || this.targetWorkerCount < minWorkerCount);
            boolean bl = shouldScaleDown = notTakingActions && validWorkers.size() == this.targetWorkerCount && this.targetWorkerCount > minWorkerCount && Iterables.any((Iterable)validWorkers, isLazyWorker);
            if (shouldScaleUp) {
                this.targetWorkerCount = Math.max(this.targetWorkerCount + 1, minWorkerCount);
                log.info("I think we should scale up to %,d workers (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            } else if (shouldScaleDown) {
                this.targetWorkerCount = Math.min(this.targetWorkerCount - 1, maxWorkerCount);
                log.info("I think we should scale down to %,d workers (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            } else {
                log.info("Our target is %,d workers, and I'm okay with that (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            }
        }

        private boolean hasTaskPendingBeyondThreshold(Collection<? extends TaskRunnerWorkItem> pendingTasks) {
            long now = System.currentTimeMillis();
            for (TaskRunnerWorkItem taskRunnerWorkItem : pendingTasks) {
                Duration timeoutDuration;
                Duration durationSinceInsertion = new Duration(taskRunnerWorkItem.getQueueInsertionTime().getMillis(), now);
                if (!durationSinceInsertion.isEqual((ReadableDuration)(timeoutDuration = SimpleWorkerProvisioningStrategy.this.config.getPendingTaskTimeout().toStandardDuration())) && !durationSinceInsertion.isLongerThan((ReadableDuration)timeoutDuration)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ScalingStats getStats() {
            return this.scalingStats;
        }
    }
}

