/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.helpers;

import com.google.inject.Inject;
import io.druid.indexing.overlord.helpers.OverlordHelper;
import io.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.java.util.common.logger.Logger;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;

public class OverlordHelperManager {
    private static final Logger log = new Logger(OverlordHelperManager.class);
    private final ScheduledExecutorFactory execFactory;
    private final Set<OverlordHelper> helpers;
    private volatile ScheduledExecutorService exec;
    private final Object startStopLock = new Object();
    private volatile boolean started = false;

    @Inject
    public OverlordHelperManager(ScheduledExecutorFactory scheduledExecutorFactory, Set<OverlordHelper> helpers) {
        this.execFactory = scheduledExecutorFactory;
        this.helpers = helpers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                log.info("OverlordHelperManager is starting.", new Object[0]);
                for (OverlordHelper helper : this.helpers) {
                    if (!helper.isEnabled()) continue;
                    if (this.exec == null) {
                        this.exec = this.execFactory.create(1, "Overlord-Helper-Manager-Exec--%d");
                    }
                    helper.schedule(this.exec);
                }
                this.started = true;
                log.info("OverlordHelperManager is started.", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.started) {
                log.info("OverlordHelperManager is stopping.", new Object[0]);
                if (this.exec != null) {
                    this.exec.shutdownNow();
                    this.exec = null;
                }
                this.started = false;
                log.info("OverlordHelperManager is stopped.", new Object[0]);
            }
        }
    }
}

