/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.http;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.druid.indexing.overlord.TaskMaster;
import io.druid.java.util.common.StringUtils;
import io.druid.server.http.RedirectInfo;
import java.net.URL;
import java.util.Set;

public class OverlordRedirectInfo
implements RedirectInfo {
    private static final Set<String> LOCAL_PATHS = ImmutableSet.of((Object)"/druid/indexer/v1/leader", (Object)"/druid/indexer/v1/isLeader");
    private final TaskMaster taskMaster;

    @Inject
    public OverlordRedirectInfo(TaskMaster taskMaster) {
        this.taskMaster = taskMaster;
    }

    public boolean doLocal(String requestURI) {
        return requestURI != null && LOCAL_PATHS.contains(requestURI) || this.taskMaster.isLeader();
    }

    public URL getRedirectURL(String queryString, String requestURI) {
        try {
            String leader = this.taskMaster.getCurrentLeader();
            if (leader == null || leader.isEmpty()) {
                return null;
            }
            String location = StringUtils.format((String)"%s%s", (Object[])new Object[]{leader, requestURI});
            if (queryString != null) {
                location = StringUtils.format((String)"%s?%s", (Object[])new Object[]{location, queryString});
            }
            return new URL(location);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

