/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import io.druid.audit.AuditInfo;
import io.druid.audit.AuditManager;
import io.druid.common.config.JacksonConfigManager;
import io.druid.indexer.TaskLocation;
import io.druid.indexer.TaskStatusPlus;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.actions.TaskActionHolder;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.IndexerMetadataStorageAdapter;
import io.druid.indexing.overlord.TaskMaster;
import io.druid.indexing.overlord.TaskQueue;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.overlord.TaskStorageQueryAdapter;
import io.druid.indexing.overlord.WorkerTaskRunner;
import io.druid.indexing.overlord.autoscaling.ScalingStats;
import io.druid.indexing.overlord.http.security.TaskResourceFilter;
import io.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.metadata.EntryExistsException;
import io.druid.server.http.security.ConfigResourceFilter;
import io.druid.server.http.security.StateResourceFilter;
import io.druid.server.security.Access;
import io.druid.server.security.Action;
import io.druid.server.security.AuthorizationUtils;
import io.druid.server.security.AuthorizerMapper;
import io.druid.server.security.ForbiddenException;
import io.druid.server.security.Resource;
import io.druid.server.security.ResourceAction;
import io.druid.server.security.ResourceType;
import io.druid.tasklogs.TaskLogStreamer;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.Interval;

@Path(value="/druid/indexer/v1")
public class OverlordResource {
    private static final Logger log = new Logger(OverlordResource.class);
    private final TaskMaster taskMaster;
    private final TaskStorageQueryAdapter taskStorageQueryAdapter;
    private final IndexerMetadataStorageAdapter indexerMetadataStorageAdapter;
    private final TaskLogStreamer taskLogStreamer;
    private final JacksonConfigManager configManager;
    private final AuditManager auditManager;
    private final AuthorizerMapper authorizerMapper;
    private AtomicReference<WorkerBehaviorConfig> workerConfigRef = null;

    @Inject
    public OverlordResource(TaskMaster taskMaster, TaskStorageQueryAdapter taskStorageQueryAdapter, IndexerMetadataStorageAdapter indexerMetadataStorageAdapter, TaskLogStreamer taskLogStreamer, JacksonConfigManager configManager, AuditManager auditManager, AuthorizerMapper authorizerMapper) {
        this.taskMaster = taskMaster;
        this.taskStorageQueryAdapter = taskStorageQueryAdapter;
        this.indexerMetadataStorageAdapter = indexerMetadataStorageAdapter;
        this.taskLogStreamer = taskLogStreamer;
        this.configManager = configManager;
        this.auditManager = auditManager;
        this.authorizerMapper = authorizerMapper;
    }

    @POST
    @Path(value="/task")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response taskPost(final Task task, @Context HttpServletRequest req) {
        String dataSource = task.getDataSource();
        ResourceAction resourceAction = new ResourceAction(new Resource(dataSource, ResourceType.DATASOURCE), Action.WRITE);
        Access authResult = AuthorizationUtils.authorizeResourceAction((HttpServletRequest)req, (ResourceAction)resourceAction, (AuthorizerMapper)this.authorizerMapper);
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.getMessage());
        }
        return this.asLeaderWith(this.taskMaster.getTaskQueue(), new Function<TaskQueue, Response>(){

            public Response apply(TaskQueue taskQueue) {
                try {
                    taskQueue.add(task);
                    return Response.ok((Object)ImmutableMap.of((Object)"task", (Object)task.getId())).build();
                }
                catch (EntryExistsException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"Task[%s] already exists!", (Object[])new Object[]{task.getId()}))).build();
                }
            }
        });
    }

    @GET
    @Path(value="/leader")
    @ResourceFilters(value={StateResourceFilter.class})
    @Produces(value={"application/json"})
    public Response getLeader() {
        return Response.ok((Object)this.taskMaster.getCurrentLeader()).build();
    }

    @GET
    @Path(value="/isLeader")
    @Produces(value={"application/json"})
    public Response isLeader() {
        boolean leading = this.taskMaster.isLeader();
        ImmutableMap response = ImmutableMap.of((Object)"leader", (Object)leading);
        if (leading) {
            return Response.ok((Object)response).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
    }

    @GET
    @Path(value="/task/{taskid}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response getTaskPayload(@PathParam(value="taskid") String taskid) {
        return this.optionalTaskResponse(taskid, "payload", this.taskStorageQueryAdapter.getTask(taskid));
    }

    @GET
    @Path(value="/task/{taskid}/status")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response getTaskStatus(@PathParam(value="taskid") String taskid) {
        return this.optionalTaskResponse(taskid, "status", this.taskStorageQueryAdapter.getStatus(taskid));
    }

    @GET
    @Path(value="/task/{taskid}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response getTaskSegments(@PathParam(value="taskid") String taskid) {
        Set<DataSegment> segments = this.taskStorageQueryAdapter.getInsertedSegments(taskid);
        return Response.ok().entity(segments).build();
    }

    @POST
    @Path(value="/task/{taskid}/shutdown")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response doShutdown(final @PathParam(value="taskid") String taskid) {
        return this.asLeaderWith(this.taskMaster.getTaskQueue(), new Function<TaskQueue, Response>(){

            public Response apply(TaskQueue taskQueue) {
                taskQueue.shutdown(taskid);
                return Response.ok((Object)ImmutableMap.of((Object)"task", (Object)taskid)).build();
            }
        });
    }

    @GET
    @Path(value="/worker")
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response getWorkerConfig() {
        if (this.workerConfigRef == null) {
            this.workerConfigRef = this.configManager.watch("worker.config", WorkerBehaviorConfig.class);
        }
        return Response.ok((Object)this.workerConfigRef.get()).build();
    }

    @POST
    @Path(value="/worker")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response setWorkerConfig(WorkerBehaviorConfig workerBehaviorConfig, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        if (!this.configManager.set("worker.config", (Object)workerBehaviorConfig, new AuditInfo(author, comment, req.getRemoteAddr()))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        log.info("Updating Worker configs: %s", new Object[]{workerBehaviorConfig});
        return Response.ok().build();
    }

    @GET
    @Path(value="/worker/history")
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response getWorkerConfigHistory(@QueryParam(value="interval") String interval, @QueryParam(value="count") Integer count) {
        Interval theInterval;
        Interval interval2 = theInterval = interval == null ? null : Intervals.of((String)interval);
        if (theInterval == null && count != null) {
            try {
                List workerEntryList = this.auditManager.fetchAuditHistory("worker.config", "worker.config", count.intValue());
                return Response.ok((Object)workerEntryList).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)e.getMessage())).build();
            }
        }
        List workerEntryList = this.auditManager.fetchAuditHistory("worker.config", "worker.config", theInterval);
        return Response.ok((Object)workerEntryList).build();
    }

    @POST
    @Path(value="/action")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response doAction(final TaskActionHolder holder) {
        return this.asLeaderWith(this.taskMaster.getTaskActionClient(holder.getTask()), new Function<TaskActionClient, Response>(){

            public Response apply(TaskActionClient taskActionClient) {
                HashMap retMap;
                try {
                    Object ret = taskActionClient.submit(holder.getAction());
                    retMap = Maps.newHashMap();
                    retMap.put("result", ret);
                }
                catch (IOException e) {
                    log.warn((Throwable)e, "Failed to perform task action", new Object[0]);
                    return Response.serverError().build();
                }
                return Response.ok().entity((Object)retMap).build();
            }
        });
    }

    @GET
    @Path(value="/waitingTasks")
    @Produces(value={"application/json"})
    public Response getWaitingTasks(final @Context HttpServletRequest req) {
        return this.workItemsResponse(new Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>>(){

            public Collection<? extends TaskRunnerWorkItem> apply(TaskRunner taskRunner) {
                List<Task> allActiveTasks = OverlordResource.this.taskStorageQueryAdapter.getActiveTasks();
                Function raGenerator = task -> Lists.newArrayList((Object[])new ResourceAction[]{new ResourceAction(new Resource(task.getDataSource(), ResourceType.DATASOURCE), Action.READ)});
                ArrayList activeTasks = Lists.newArrayList((Iterable)AuthorizationUtils.filterAuthorizedResources((HttpServletRequest)req, allActiveTasks, (Function)raGenerator, (AuthorizerMapper)OverlordResource.this.authorizerMapper));
                HashSet runnersKnownTasks = Sets.newHashSet((Iterable)Iterables.transform(taskRunner.getKnownTasks(), (Function)new Function<TaskRunnerWorkItem, String>(){

                    public String apply(TaskRunnerWorkItem workItem) {
                        return workItem.getTaskId();
                    }
                }));
                ArrayList waitingTasks = Lists.newArrayList();
                for (Task task2 : activeTasks) {
                    if (runnersKnownTasks.contains(task2.getId())) continue;
                    waitingTasks.add(new TaskRunnerWorkItem(task2.getId(), (ListenableFuture)SettableFuture.create(), DateTimes.EPOCH, DateTimes.EPOCH){

                        @Override
                        public TaskLocation getLocation() {
                            return TaskLocation.unknown();
                        }
                    });
                }
                return waitingTasks;
            }
        });
    }

    @GET
    @Path(value="/pendingTasks")
    @Produces(value={"application/json"})
    public Response getPendingTasks(final @Context HttpServletRequest req) {
        return this.workItemsResponse(new Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>>(){

            public Collection<? extends TaskRunnerWorkItem> apply(TaskRunner taskRunner) {
                return OverlordResource.this.securedTaskRunnerWorkItem(taskRunner.getPendingTasks(), req);
            }
        });
    }

    @GET
    @Path(value="/runningTasks")
    @Produces(value={"application/json"})
    public Response getRunningTasks(final @Context HttpServletRequest req) {
        return this.workItemsResponse(new Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>>(){

            public Collection<? extends TaskRunnerWorkItem> apply(TaskRunner taskRunner) {
                return OverlordResource.this.securedTaskRunnerWorkItem(taskRunner.getRunningTasks(), req);
            }
        });
    }

    @GET
    @Path(value="/completeTasks")
    @Produces(value={"application/json"})
    public Response getCompleteTasks(@QueryParam(value="n") Integer maxTaskStatuses, @Context HttpServletRequest req) {
        Function raGenerator = taskStatus -> {
            String taskId = taskStatus.getId();
            Optional<Task> optionalTask = this.taskStorageQueryAdapter.getTask(taskId);
            if (!optionalTask.isPresent()) {
                throw new WebApplicationException(Response.serverError().entity((Object)StringUtils.format((String)"No task information found for task with id: [%s]", (Object[])new Object[]{taskId})).build());
            }
            return Lists.newArrayList((Object[])new ResourceAction[]{new ResourceAction(new Resource(((Task)optionalTask.get()).getDataSource(), ResourceType.DATASOURCE), Action.READ)});
        };
        ArrayList recentlyFinishedTasks = Lists.newArrayList((Iterable)AuthorizationUtils.filterAuthorizedResources((HttpServletRequest)req, this.taskStorageQueryAdapter.getRecentlyFinishedTaskStatuses(maxTaskStatuses), (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper));
        List completeTasks = recentlyFinishedTasks.stream().map(status -> new TaskStatusPlus(status.getId(), this.taskStorageQueryAdapter.getCreatedTime(status.getId()), DateTimes.EPOCH, status.getStatusCode(), Long.valueOf(status.getDuration()), TaskLocation.unknown())).collect(Collectors.toList());
        return Response.ok(completeTasks).build();
    }

    @DELETE
    @Path(value="/pendingSegments/{dataSource}")
    @Produces(value={"application/json"})
    public Response killPendingSegments(@PathParam(value="dataSource") String dataSource, @QueryParam(value="interval") String deleteIntervalString, @Context HttpServletRequest request) {
        Interval deleteInterval = Intervals.of((String)deleteIntervalString);
        Access authResult = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)request, (Iterable)ImmutableList.of((Object)new ResourceAction(new Resource(dataSource, ResourceType.DATASOURCE), Action.READ), (Object)new ResourceAction(new Resource(dataSource, ResourceType.DATASOURCE), Action.WRITE)), (AuthorizerMapper)this.authorizerMapper);
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.getMessage());
        }
        if (this.taskMaster.isLeader()) {
            int numDeleted = this.indexerMetadataStorageAdapter.deletePendingSegments(dataSource, deleteInterval);
            return Response.ok().entity((Object)ImmutableMap.of((Object)"numDeleted", (Object)numDeleted)).build();
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    @GET
    @Path(value="/workers")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getWorkers() {
        return this.asLeaderWith(this.taskMaster.getTaskRunner(), new Function<TaskRunner, Response>(){

            public Response apply(TaskRunner taskRunner) {
                if (taskRunner instanceof WorkerTaskRunner) {
                    return Response.ok(((WorkerTaskRunner)taskRunner).getWorkers()).build();
                }
                log.debug("Task runner [%s] of type [%s] does not support listing workers", new Object[]{taskRunner, taskRunner.getClass().getCanonicalName()});
                return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Task Runner does not support worker listing")).build();
            }
        });
    }

    @GET
    @Path(value="/scaling")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getScalingState() {
        Optional<ScalingStats> rms = this.taskMaster.getScalingStats();
        if (rms.isPresent()) {
            return Response.ok((Object)rms.get()).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/task/{taskid}/log")
    @Produces(value={"text/plain"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response doGetLog(@PathParam(value="taskid") String taskid, @QueryParam(value="offset") @DefaultValue(value="0") long offset) {
        try {
            Optional stream = this.taskLogStreamer.streamTaskLog(taskid, offset);
            if (stream.isPresent()) {
                return Response.ok((Object)((ByteSource)stream.get()).openStream()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No log was found for this task. The task may not exist, or it may not have begun running yet.").build();
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to stream log for task %s", new Object[]{taskid});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Response workItemsResponse(final Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>> fn) {
        return this.asLeaderWith(this.taskMaster.getTaskRunner(), new Function<TaskRunner, Response>(){

            public Response apply(TaskRunner taskRunner) {
                return Response.ok((Object)Lists.transform((List)Lists.newArrayList((Iterable)((Iterable)fn.apply((Object)taskRunner))), (Function)new Function<TaskRunnerWorkItem, TaskStatusPlus>(){

                    public TaskStatusPlus apply(TaskRunnerWorkItem workItem) {
                        return new TaskStatusPlus(workItem.getTaskId(), workItem.getCreatedTime(), workItem.getQueueInsertionTime(), null, null, workItem.getLocation());
                    }
                })).build();
            }
        });
    }

    private <T> Response optionalTaskResponse(String taskid, String objectType, Optional<T> x) {
        HashMap results = Maps.newHashMap();
        results.put("task", taskid);
        if (x.isPresent()) {
            results.put(objectType, x.get());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)results).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)results).build();
    }

    private <T> Response asLeaderWith(Optional<T> x, Function<T, Response> f) {
        if (x.isPresent()) {
            return (Response)f.apply(x.get());
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    private Collection<? extends TaskRunnerWorkItem> securedTaskRunnerWorkItem(Collection<? extends TaskRunnerWorkItem> collectionToFilter, HttpServletRequest req) {
        Function raGenerator = taskRunnerWorkItem -> {
            String taskId = taskRunnerWorkItem.getTaskId();
            Optional<Task> optionalTask = this.taskStorageQueryAdapter.getTask(taskId);
            if (!optionalTask.isPresent()) {
                throw new WebApplicationException(Response.serverError().entity((Object)StringUtils.format((String)"No task information found for task with id: [%s]", (Object[])new Object[]{taskId})).build());
            }
            return Lists.newArrayList((Object[])new ResourceAction[]{new ResourceAction(new Resource(((Task)optionalTask.get()).getDataSource(), ResourceType.DATASOURCE), Action.READ)});
        };
        return Lists.newArrayList((Iterable)AuthorizationUtils.filterAuthorizedResources((HttpServletRequest)req, collectionToFilter, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper));
    }
}

