/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.http.security;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskStorageQueryAdapter;
import io.druid.java.util.common.StringUtils;
import io.druid.server.http.security.AbstractResourceFilter;
import io.druid.server.security.Access;
import io.druid.server.security.AuthorizationUtils;
import io.druid.server.security.AuthorizerMapper;
import io.druid.server.security.ForbiddenException;
import io.druid.server.security.Resource;
import io.druid.server.security.ResourceAction;
import io.druid.server.security.ResourceType;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;

public class TaskResourceFilter
extends AbstractResourceFilter {
    private final TaskStorageQueryAdapter taskStorageQueryAdapter;

    @Inject
    public TaskResourceFilter(TaskStorageQueryAdapter taskStorageQueryAdapter, AuthorizerMapper authorizerMapper) {
        super(authorizerMapper);
        this.taskStorageQueryAdapter = taskStorageQueryAdapter;
    }

    public ContainerRequest filter(ContainerRequest request) {
        String taskId = (String)Preconditions.checkNotNull((Object)((PathSegment)request.getPathSegments().get(Iterables.indexOf((Iterable)request.getPathSegments(), (Predicate)new Predicate<PathSegment>(){

            public boolean apply(PathSegment input) {
                return input.getPath().equals("task");
            }
        }) + 1)).getPath());
        Optional<Task> taskOptional = this.taskStorageQueryAdapter.getTask(taskId);
        if (!taskOptional.isPresent()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringUtils.format((String)"Cannot find any task with id: [%s]", (Object[])new Object[]{taskId})).build());
        }
        String dataSourceName = (String)Preconditions.checkNotNull((Object)((Task)taskOptional.get()).getDataSource());
        ResourceAction resourceAction = new ResourceAction(new Resource(dataSourceName, ResourceType.DATASOURCE), this.getAction(request));
        Access authResult = AuthorizationUtils.authorizeResourceAction((HttpServletRequest)this.getReq(), (ResourceAction)resourceAction, (AuthorizerMapper)this.getAuthorizerMapper());
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        return request;
    }

    public boolean isApplicable(String requestPath) {
        ImmutableList applicablePaths = ImmutableList.of((Object)"druid/indexer/v1/task/");
        for (String path : applicablePaths) {
            if (!requestPath.startsWith(path) || requestPath.equals(path)) continue;
            return true;
        }
        return false;
    }
}

