/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.ImmutableWorkerInfo;
import io.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import io.druid.indexing.overlord.setup.AffinityConfig;
import io.druid.indexing.overlord.setup.WorkerSelectStrategy;
import io.druid.indexing.overlord.setup.WorkerSelectUtils;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;

public class FillCapacityWorkerSelectStrategy
implements WorkerSelectStrategy {
    private final AffinityConfig affinityConfig;

    @JsonCreator
    public FillCapacityWorkerSelectStrategy(@JsonProperty(value="affinityConfig") AffinityConfig affinityConfig) {
        this.affinityConfig = affinityConfig;
    }

    @JsonProperty
    public AffinityConfig getAffinityConfig() {
        return this.affinityConfig;
    }

    @Override
    public ImmutableWorkerInfo findWorkerForTask(WorkerTaskRunnerConfig config, ImmutableMap<String, ImmutableWorkerInfo> zkWorkers, Task task) {
        return WorkerSelectUtils.selectWorker(task, zkWorkers, config, this.affinityConfig, FillCapacityWorkerSelectStrategy::selectFromEligibleWorkers);
    }

    private static ImmutableWorkerInfo selectFromEligibleWorkers(Map<String, ImmutableWorkerInfo> eligibleWorkers) {
        return eligibleWorkers.values().stream().max(Comparator.comparing(ImmutableWorkerInfo::getCurrCapacityUsed)).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FillCapacityWorkerSelectStrategy that = (FillCapacityWorkerSelectStrategy)o;
        return Objects.equals(this.affinityConfig, that.affinityConfig);
    }

    public int hashCode() {
        return Objects.hash(this.affinityConfig);
    }

    public String toString() {
        return "FillCapacityWorkerSelectStrategy{affinityConfig=" + this.affinityConfig + '}';
    }
}

