/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.ImmutableWorkerInfo;
import io.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import io.druid.indexing.overlord.setup.WorkerSelectStrategy;
import io.druid.js.JavaScriptConfig;
import javax.script.Compilable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JavaScriptWorkerSelectStrategy
implements WorkerSelectStrategy {
    private final String function;
    private SelectorFunction fnSelector;

    @JsonCreator
    public JavaScriptWorkerSelectStrategy(@JsonProperty(value="function") String fn, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkNotNull((Object)fn, (Object)"function must not be null");
        Preconditions.checkState((boolean)config.isEnabled(), (Object)"JavaScript is disabled");
        this.function = fn;
    }

    private SelectorFunction compileSelectorFunction() {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
        try {
            ((Compilable)((Object)engine)).compile("var apply = " + this.function).eval();
            return ((Invocable)((Object)engine)).getInterface(SelectorFunction.class);
        }
        catch (ScriptException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public ImmutableWorkerInfo findWorkerForTask(WorkerTaskRunnerConfig config, ImmutableMap<String, ImmutableWorkerInfo> zkWorkers, Task task) {
        this.fnSelector = this.fnSelector == null ? this.compileSelectorFunction() : this.fnSelector;
        String worker = this.fnSelector.apply(config, zkWorkers, task);
        return worker == null ? null : (ImmutableWorkerInfo)zkWorkers.get((Object)worker);
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptWorkerSelectStrategy that = (JavaScriptWorkerSelectStrategy)o;
        return !(this.function != null ? !this.function.equals(that.function) : that.function != null);
    }

    public int hashCode() {
        return this.function.hashCode();
    }

    public String toString() {
        return "JavaScriptWorkerSelectStrategy{function='" + this.function + '\'' + '}';
    }

    public static interface SelectorFunction {
        public String apply(WorkerTaskRunnerConfig var1, ImmutableMap<String, ImmutableWorkerInfo> var2, Task var3);
    }
}

