/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.setup;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.ImmutableWorkerInfo;
import io.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import io.druid.indexing.overlord.setup.AffinityConfig;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class WorkerSelectUtils {
    private WorkerSelectUtils() {
    }

    @Nullable
    public static ImmutableWorkerInfo selectWorker(Task task, Map<String, ImmutableWorkerInfo> allWorkers, WorkerTaskRunnerConfig workerTaskRunnerConfig, @Nullable AffinityConfig affinityConfig, Function<ImmutableMap<String, ImmutableWorkerInfo>, ImmutableWorkerInfo> workerSelector) {
        Map<String, ImmutableWorkerInfo> runnableWorkers = allWorkers.values().stream().filter(worker -> worker.canRunTask(task) && worker.isValidVersion(workerTaskRunnerConfig.getMinWorkerVersion())).collect(Collectors.toMap(w -> w.getWorker().getHost(), Function.identity()));
        if (affinityConfig == null) {
            return workerSelector.apply((ImmutableMap<String, ImmutableWorkerInfo>)ImmutableMap.copyOf(runnableWorkers));
        }
        Set<String> dataSourceWorkers = affinityConfig.getAffinity().get(task.getDataSource());
        if (dataSourceWorkers == null) {
            return workerSelector.apply(WorkerSelectUtils.getNonAffinityWorkers(affinityConfig, runnableWorkers));
        }
        ImmutableMap dataSourceWorkerMap = ImmutableMap.copyOf((Map)Maps.filterKeys(runnableWorkers, dataSourceWorkers::contains));
        ImmutableWorkerInfo selected = workerSelector.apply((ImmutableMap<String, ImmutableWorkerInfo>)dataSourceWorkerMap);
        if (selected != null) {
            return selected;
        }
        if (affinityConfig.isStrong()) {
            return null;
        }
        return workerSelector.apply(WorkerSelectUtils.getNonAffinityWorkers(affinityConfig, runnableWorkers));
    }

    private static ImmutableMap<String, ImmutableWorkerInfo> getNonAffinityWorkers(AffinityConfig affinityConfig, Map<String, ImmutableWorkerInfo> workerMap) {
        return ImmutableMap.copyOf((Map)Maps.filterKeys(workerMap, workerHost -> !affinityConfig.getAffinityWorkers().contains(workerHost)));
    }
}

