/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.supervisor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import io.druid.indexing.overlord.TaskMaster;
import io.druid.indexing.overlord.http.security.SupervisorResourceFilter;
import io.druid.indexing.overlord.supervisor.SupervisorManager;
import io.druid.indexing.overlord.supervisor.SupervisorReport;
import io.druid.indexing.overlord.supervisor.SupervisorSpec;
import io.druid.indexing.overlord.supervisor.VersionedSupervisorSpec;
import io.druid.java.util.common.StringUtils;
import io.druid.server.security.Access;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthorizationUtils;
import io.druid.server.security.AuthorizerMapper;
import io.druid.server.security.ForbiddenException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/druid/indexer/v1/supervisor")
public class SupervisorResource {
    private final TaskMaster taskMaster;
    private final AuthConfig authConfig;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public SupervisorResource(TaskMaster taskMaster, AuthConfig authConfig, AuthorizerMapper authorizerMapper) {
        this.taskMaster = taskMaster;
        this.authConfig = authConfig;
        this.authorizerMapper = authorizerMapper;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response specPost(final SupervisorSpec spec, final @Context HttpServletRequest req) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                Preconditions.checkArgument((spec.getDataSources() != null && spec.getDataSources().size() > 0 ? 1 : 0) != 0, (Object)"No dataSources found to perform authorization checks");
                Access authResult = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)req, (Iterable)Iterables.transform((Iterable)spec.getDataSources(), (Function)AuthorizationUtils.DATASOURCE_WRITE_RA_GENERATOR), (AuthorizerMapper)SupervisorResource.this.authorizerMapper);
                if (!authResult.isAllowed()) {
                    throw new ForbiddenException(authResult.toString());
                }
                manager.createOrUpdateAndStartSupervisor(spec);
                return Response.ok((Object)ImmutableMap.of((Object)"id", (Object)spec.getId())).build();
            }
        });
    }

    @GET
    @Produces(value={"application/json"})
    public Response specGetAll(final @Context HttpServletRequest req) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                Set authorizedSupervisorIds = SupervisorResource.this.filterAuthorizedSupervisorIds(req, manager, manager.getSupervisorIds());
                return Response.ok((Object)authorizedSupervisorIds).build();
            }
        });
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response specGet(final @PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                Optional<SupervisorSpec> spec = manager.getSupervisorSpec(id);
                if (!spec.isPresent()) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"[%s] does not exist", (Object[])new Object[]{id}))).build();
                }
                return Response.ok((Object)spec.get()).build();
            }
        });
    }

    @GET
    @Path(value="/{id}/status")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response specGetStatus(final @PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                Optional<SupervisorReport> spec = manager.getSupervisorStatus(id);
                if (!spec.isPresent()) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"[%s] does not exist", (Object[])new Object[]{id}))).build();
                }
                return Response.ok((Object)spec.get()).build();
            }
        });
    }

    @POST
    @Path(value="/{id}/shutdown")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response shutdown(final @PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                if (manager.stopAndRemoveSupervisor(id)) {
                    return Response.ok((Object)ImmutableMap.of((Object)"id", (Object)id)).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"[%s] does not exist", (Object[])new Object[]{id}))).build();
            }
        });
    }

    @GET
    @Path(value="/history")
    @Produces(value={"application/json"})
    public Response specGetAllHistory(final @Context HttpServletRequest req) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                Map<String, List<VersionedSupervisorSpec>> supervisorHistory = manager.getSupervisorHistory();
                final Set authorizedSupervisorIds = SupervisorResource.this.filterAuthorizedSupervisorIds(req, manager, supervisorHistory.keySet());
                Map authorizedSupervisorHistory = Maps.filterKeys(supervisorHistory, (Predicate)new Predicate<String>(){

                    public boolean apply(String id) {
                        return authorizedSupervisorIds.contains(id);
                    }
                });
                return Response.ok((Object)authorizedSupervisorHistory).build();
            }
        });
    }

    @GET
    @Path(value="/{id}/history")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response specGetHistory(final @PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                Map<String, List<VersionedSupervisorSpec>> history = manager.getSupervisorHistory();
                if (history.containsKey(id)) {
                    return Response.ok(history.get(id)).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"No history for [%s] (history available for %s)", (Object[])new Object[]{id, history.keySet()}))).build();
            }
        });
    }

    @POST
    @Path(value="/{id}/reset")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response reset(final @PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                if (manager.resetSupervisor(id, null)) {
                    return Response.ok((Object)ImmutableMap.of((Object)"id", (Object)id)).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"[%s] does not exist", (Object[])new Object[]{id}))).build();
            }
        });
    }

    private Response asLeaderWithSupervisorManager(Function<SupervisorManager, Response> f) {
        Optional<SupervisorManager> supervisorManager = this.taskMaster.getSupervisorManager();
        if (supervisorManager.isPresent()) {
            return (Response)f.apply(supervisorManager.get());
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    private Set<String> filterAuthorizedSupervisorIds(HttpServletRequest req, SupervisorManager manager, Collection<String> supervisorIds) {
        Function raGenerator = supervisorId -> {
            Optional<SupervisorSpec> supervisorSpecOptional = manager.getSupervisorSpec((String)supervisorId);
            if (supervisorSpecOptional.isPresent()) {
                return Iterables.transform((Iterable)((SupervisorSpec)supervisorSpecOptional.get()).getDataSources(), (Function)AuthorizationUtils.DATASOURCE_WRITE_RA_GENERATOR);
            }
            return null;
        };
        return Sets.newHashSet((Iterable)AuthorizationUtils.filterAuthorizedResources((HttpServletRequest)req, supervisorIds, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper));
    }
}

