/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.worker.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.java.util.common.ISE;
import java.io.File;
import java.io.InputStream;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class ExecutorLifecycleConfig {
    @JsonProperty
    @NotNull
    private File taskFile = null;
    @JsonProperty
    @NotNull
    private File statusFile = null;
    @JsonProperty
    @Pattern(regexp="\\{stdin\\}")
    private String parentStreamName = "stdin";
    @JsonProperty
    private boolean parentStreamDefined = true;

    public boolean isParentStreamDefined() {
        return this.parentStreamDefined;
    }

    public ExecutorLifecycleConfig setParentStreamDefined(boolean parentStreamDefined) {
        this.parentStreamDefined = parentStreamDefined;
        return this;
    }

    public File getTaskFile() {
        return this.taskFile;
    }

    public ExecutorLifecycleConfig setTaskFile(File taskFile) {
        this.taskFile = taskFile;
        return this;
    }

    public File getStatusFile() {
        return this.statusFile;
    }

    public ExecutorLifecycleConfig setStatusFile(File statusFile) {
        this.statusFile = statusFile;
        return this;
    }

    public String getParentStreamName() {
        return this.parentStreamName;
    }

    public ExecutorLifecycleConfig setParentStreamName(String parentStreamName) {
        this.parentStreamName = parentStreamName;
        return this;
    }

    public InputStream getParentStream() {
        if ("stdin".equals(this.parentStreamName)) {
            return System.in;
        }
        throw new ISE("Unknown stream name[%s]", new Object[]{this.parentStreamName});
    }
}

