/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.initialization;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.server.initialization.ZkPathsConfig;
import org.apache.curator.utils.ZKPaths;

public class IndexerZkConfig {
    @JacksonInject
    private final ZkPathsConfig zkPathsConfig;
    @JsonProperty
    private final String base;
    @JsonProperty
    private final String announcementsPath;
    @JsonProperty
    private final String tasksPath;
    @JsonProperty
    private final String statusPath;

    @JsonCreator
    public IndexerZkConfig(@JacksonInject ZkPathsConfig zkPathsConfig, @JsonProperty(value="base") String base, @JsonProperty(value="announcementsPath") String announcementsPath, @JsonProperty(value="tasksPath") String tasksPath, @JsonProperty(value="statusPath") String statusPath) {
        this.zkPathsConfig = zkPathsConfig;
        this.base = base;
        this.announcementsPath = announcementsPath;
        this.tasksPath = tasksPath;
        this.statusPath = statusPath;
    }

    private String defaultIndexerPath(String subPath) {
        return ZKPaths.makePath((String)this.getBase(), (String)subPath);
    }

    public String getBase() {
        return this.base == null ? this.getZkPathsConfig().defaultPath("indexer") : this.base;
    }

    public String getAnnouncementsPath() {
        return this.announcementsPath == null ? this.defaultIndexerPath("announcements") : this.announcementsPath;
    }

    public String getTasksPath() {
        return this.tasksPath == null ? this.defaultIndexerPath("tasks") : this.tasksPath;
    }

    public String getStatusPath() {
        return this.statusPath == null ? this.defaultIndexerPath("status") : this.statusPath;
    }

    public ZkPathsConfig getZkPathsConfig() {
        return this.zkPathsConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexerZkConfig that = (IndexerZkConfig)o;
        if (this.announcementsPath != null ? !this.announcementsPath.equals(that.announcementsPath) : that.announcementsPath != null) {
            return false;
        }
        if (this.base != null ? !this.base.equals(that.base) : that.base != null) {
            return false;
        }
        if (this.statusPath != null ? !this.statusPath.equals(that.statusPath) : that.statusPath != null) {
            return false;
        }
        if (this.tasksPath != null ? !this.tasksPath.equals(that.tasksPath) : that.tasksPath != null) {
            return false;
        }
        return !(this.zkPathsConfig != null ? !this.zkPathsConfig.equals((Object)that.zkPathsConfig) : that.zkPathsConfig != null);
    }

    public int hashCode() {
        int result = this.zkPathsConfig != null ? this.zkPathsConfig.hashCode() : 0;
        result = 31 * result + (this.base != null ? this.base.hashCode() : 0);
        result = 31 * result + (this.announcementsPath != null ? this.announcementsPath.hashCode() : 0);
        result = 31 * result + (this.tasksPath != null ? this.tasksPath.hashCode() : 0);
        result = 31 * result + (this.statusPath != null ? this.statusPath.hashCode() : 0);
        return result;
    }
}

