/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.metrics.MonitorScheduler;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.indexing.common.actions.SegmentInsertAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.common.task.Task;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.loading.DataSegmentArchiver;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.DataSegmentMover;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.loading.SegmentLoader;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.joda.time.Interval;

public class TaskToolbox {
    private final TaskConfig config;
    private final Task task;
    private final TaskActionClient taskActionClient;
    private final ServiceEmitter emitter;
    private final DataSegmentPusher segmentPusher;
    private final DataSegmentKiller dataSegmentKiller;
    private final DataSegmentArchiver dataSegmentArchiver;
    private final DataSegmentMover dataSegmentMover;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final SegmentHandoffNotifierFactory handoffNotifierFactory;
    private final QueryRunnerFactoryConglomerate queryRunnerFactoryConglomerate;
    private final MonitorScheduler monitorScheduler;
    private final ExecutorService queryExecutorService;
    private final SegmentLoader segmentLoader;
    private final ObjectMapper objectMapper;
    private final File taskWorkDir;
    private final IndexMerger indexMerger;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final IndexMergerV9 indexMergerV9;

    public TaskToolbox(TaskConfig config, Task task, TaskActionClient taskActionClient, ServiceEmitter emitter, DataSegmentPusher segmentPusher, DataSegmentKiller dataSegmentKiller, DataSegmentMover dataSegmentMover, DataSegmentArchiver dataSegmentArchiver, DataSegmentAnnouncer segmentAnnouncer, SegmentHandoffNotifierFactory handoffNotifierFactory, QueryRunnerFactoryConglomerate queryRunnerFactoryConglomerate, ExecutorService queryExecutorService, MonitorScheduler monitorScheduler, SegmentLoader segmentLoader, ObjectMapper objectMapper, File taskWorkDir, IndexMerger indexMerger, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, IndexMergerV9 indexMergerV9) {
        this.config = config;
        this.task = task;
        this.taskActionClient = taskActionClient;
        this.emitter = emitter;
        this.segmentPusher = segmentPusher;
        this.dataSegmentKiller = dataSegmentKiller;
        this.dataSegmentMover = dataSegmentMover;
        this.dataSegmentArchiver = dataSegmentArchiver;
        this.segmentAnnouncer = segmentAnnouncer;
        this.handoffNotifierFactory = handoffNotifierFactory;
        this.queryRunnerFactoryConglomerate = queryRunnerFactoryConglomerate;
        this.queryExecutorService = queryExecutorService;
        this.monitorScheduler = monitorScheduler;
        this.segmentLoader = segmentLoader;
        this.objectMapper = objectMapper;
        this.taskWorkDir = taskWorkDir;
        this.indexMerger = (IndexMerger)Preconditions.checkNotNull((Object)indexMerger, (Object)"Null IndexMerger");
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.indexMergerV9 = (IndexMergerV9)Preconditions.checkNotNull((Object)indexMergerV9, (Object)"Null IndexMergerV9");
    }

    public TaskConfig getConfig() {
        return this.config;
    }

    public TaskActionClient getTaskActionClient() {
        return this.taskActionClient;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public DataSegmentPusher getSegmentPusher() {
        return this.segmentPusher;
    }

    public DataSegmentKiller getDataSegmentKiller() {
        return this.dataSegmentKiller;
    }

    public DataSegmentMover getDataSegmentMover() {
        return this.dataSegmentMover;
    }

    public DataSegmentArchiver getDataSegmentArchiver() {
        return this.dataSegmentArchiver;
    }

    public DataSegmentAnnouncer getSegmentAnnouncer() {
        return this.segmentAnnouncer;
    }

    public SegmentHandoffNotifierFactory getSegmentHandoffNotifierFactory() {
        return this.handoffNotifierFactory;
    }

    public QueryRunnerFactoryConglomerate getQueryRunnerFactoryConglomerate() {
        return this.queryRunnerFactoryConglomerate;
    }

    public ExecutorService getQueryExecutorService() {
        return this.queryExecutorService;
    }

    public MonitorScheduler getMonitorScheduler() {
        return this.monitorScheduler;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Map<DataSegment, File> fetchSegments(List<DataSegment> segments) throws SegmentLoadingException {
        LinkedHashMap retVal = Maps.newLinkedHashMap();
        for (DataSegment segment : segments) {
            retVal.put(segment, this.segmentLoader.getSegmentFiles(segment));
        }
        return retVal;
    }

    public void publishSegments(Iterable<DataSegment> segments) throws IOException {
        ImmutableListMultimap segmentMultimap = Multimaps.index(segments, (Function)new Function<DataSegment, Interval>(){

            public Interval apply(DataSegment segment) {
                return segment.getInterval();
            }
        });
        for (Collection segmentCollection : segmentMultimap.asMap().values()) {
            this.getTaskActionClient().submit(new SegmentInsertAction((Set<DataSegment>)ImmutableSet.copyOf((Collection)segmentCollection)));
        }
    }

    public File getTaskWorkDir() {
        return this.taskWorkDir;
    }

    public IndexIO getIndexIO() {
        return this.indexIO;
    }

    public IndexMerger getIndexMerger() {
        return this.indexMerger;
    }

    public Cache getCache() {
        return this.cache;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public IndexMergerV9 getIndexMergerV9() {
        return this.indexMergerV9;
    }
}

