/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.autoscaling;

import com.google.common.base.Predicate;
import com.metamx.common.ISE;
import io.druid.indexing.overlord.ImmutableWorkerInfo;
import io.druid.indexing.overlord.autoscaling.SimpleWorkerResourceManagementConfig;

public class ResourceManagementUtil {
    public static Predicate<ImmutableWorkerInfo> createValidWorkerPredicate(final SimpleWorkerResourceManagementConfig config) {
        return new Predicate<ImmutableWorkerInfo>(){

            public boolean apply(ImmutableWorkerInfo worker) {
                String minVersion = config.getWorkerVersion();
                if (minVersion == null) {
                    throw new ISE("No minVersion found! It should be set in your runtime properties or configuration database.", new Object[0]);
                }
                return worker.isValidVersion(minVersion);
            }
        };
    }

    public static Predicate<ImmutableWorkerInfo> createLazyWorkerPredicate(final SimpleWorkerResourceManagementConfig config) {
        final Predicate<ImmutableWorkerInfo> isValidWorker = ResourceManagementUtil.createValidWorkerPredicate(config);
        return new Predicate<ImmutableWorkerInfo>(){

            public boolean apply(ImmutableWorkerInfo worker) {
                boolean itHasBeenAWhile = System.currentTimeMillis() - worker.getLastCompletedTaskTime().getMillis() >= config.getWorkerIdleTimeout().toStandardDuration().getMillis();
                return itHasBeenAWhile || !isValidWorker.apply((Object)worker);
            }
        };
    }
}

