/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.http;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.metamx.common.Pair;
import com.metamx.common.logger.Logger;
import com.sun.jersey.spi.container.ResourceFilters;
import io.druid.audit.AuditInfo;
import io.druid.audit.AuditManager;
import io.druid.common.config.JacksonConfigManager;
import io.druid.indexing.common.TaskLocation;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.actions.TaskActionHolder;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskMaster;
import io.druid.indexing.overlord.TaskQueue;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.overlord.TaskStorageQueryAdapter;
import io.druid.indexing.overlord.WorkerTaskRunner;
import io.druid.indexing.overlord.autoscaling.ScalingStats;
import io.druid.indexing.overlord.http.security.TaskResourceFilter;
import io.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import io.druid.metadata.EntryExistsException;
import io.druid.server.http.security.ConfigResourceFilter;
import io.druid.server.http.security.StateResourceFilter;
import io.druid.server.security.Access;
import io.druid.server.security.Action;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthorizationInfo;
import io.druid.server.security.Resource;
import io.druid.server.security.ResourceType;
import io.druid.tasklogs.TaskLogStreamer;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.Interval;

@Path(value="/druid/indexer/v1")
public class OverlordResource {
    private static final Logger log = new Logger(OverlordResource.class);
    private final TaskMaster taskMaster;
    private final TaskStorageQueryAdapter taskStorageQueryAdapter;
    private final TaskLogStreamer taskLogStreamer;
    private final JacksonConfigManager configManager;
    private final AuditManager auditManager;
    private final AuthConfig authConfig;
    private AtomicReference<WorkerBehaviorConfig> workerConfigRef = null;

    @Inject
    public OverlordResource(TaskMaster taskMaster, TaskStorageQueryAdapter taskStorageQueryAdapter, TaskLogStreamer taskLogStreamer, JacksonConfigManager configManager, AuditManager auditManager, AuthConfig authConfig) throws Exception {
        this.taskMaster = taskMaster;
        this.taskStorageQueryAdapter = taskStorageQueryAdapter;
        this.taskLogStreamer = taskLogStreamer;
        this.configManager = configManager;
        this.auditManager = auditManager;
        this.authConfig = authConfig;
    }

    @POST
    @Path(value="/task")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response taskPost(final Task task, @Context HttpServletRequest req) {
        if (this.authConfig.isEnabled()) {
            String dataSource = task.getDataSource();
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)req.getAttribute("Druid-Auth-Token");
            Preconditions.checkNotNull((Object)authorizationInfo, (Object)"Security is enabled but no authorization info found in the request");
            Access authResult = authorizationInfo.isAuthorized(new Resource(dataSource, ResourceType.DATASOURCE), Action.WRITE);
            if (!authResult.isAllowed()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).header("Access-Check-Result", (Object)authResult).build();
            }
        }
        return this.asLeaderWith(this.taskMaster.getTaskQueue(), new Function<TaskQueue, Response>(){

            public Response apply(TaskQueue taskQueue) {
                try {
                    taskQueue.add(task);
                    return Response.ok((Object)ImmutableMap.of((Object)"task", (Object)task.getId())).build();
                }
                catch (EntryExistsException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)String.format("Task[%s] already exists!", task.getId()))).build();
                }
            }
        });
    }

    @GET
    @Path(value="/leader")
    @ResourceFilters(value={StateResourceFilter.class})
    @Produces(value={"application/json"})
    public Response getLeader() {
        return Response.ok((Object)this.taskMaster.getLeader()).build();
    }

    @GET
    @Path(value="/task/{taskid}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response getTaskPayload(@PathParam(value="taskid") String taskid) {
        return this.optionalTaskResponse(taskid, "payload", this.taskStorageQueryAdapter.getTask(taskid));
    }

    @GET
    @Path(value="/task/{taskid}/status")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response getTaskStatus(@PathParam(value="taskid") String taskid) {
        return this.optionalTaskResponse(taskid, "status", this.taskStorageQueryAdapter.getStatus(taskid));
    }

    @GET
    @Path(value="/task/{taskid}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response getTaskSegments(@PathParam(value="taskid") String taskid) {
        Set<DataSegment> segments = this.taskStorageQueryAdapter.getInsertedSegments(taskid);
        return Response.ok().entity(segments).build();
    }

    @POST
    @Path(value="/task/{taskid}/shutdown")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response doShutdown(final @PathParam(value="taskid") String taskid) {
        return this.asLeaderWith(this.taskMaster.getTaskQueue(), new Function<TaskQueue, Response>(){

            public Response apply(TaskQueue taskQueue) {
                taskQueue.shutdown(taskid);
                return Response.ok((Object)ImmutableMap.of((Object)"task", (Object)taskid)).build();
            }
        });
    }

    @GET
    @Path(value="/worker")
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response getWorkerConfig() {
        if (this.workerConfigRef == null) {
            this.workerConfigRef = this.configManager.watch("worker.config", WorkerBehaviorConfig.class);
        }
        return Response.ok((Object)this.workerConfigRef.get()).build();
    }

    @POST
    @Path(value="/worker")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response setWorkerConfig(WorkerBehaviorConfig workerBehaviorConfig, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        if (!this.configManager.set("worker.config", (Object)workerBehaviorConfig, new AuditInfo(author, comment, req.getRemoteAddr()))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        log.info("Updating Worker configs: %s", new Object[]{workerBehaviorConfig});
        return Response.ok().build();
    }

    @GET
    @Path(value="/worker/history")
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response getWorkerConfigHistory(@QueryParam(value="interval") String interval, @QueryParam(value="count") Integer count) {
        Interval theInterval;
        Interval interval2 = theInterval = interval == null ? null : new Interval((Object)interval);
        if (theInterval == null && count != null) {
            try {
                return Response.ok((Object)this.auditManager.fetchAuditHistory("worker.config", "worker.config", count.intValue())).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)e.getMessage())).build();
            }
        }
        return Response.ok((Object)this.auditManager.fetchAuditHistory("worker.config", "worker.config", theInterval)).build();
    }

    @POST
    @Path(value="/action")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response doAction(final TaskActionHolder holder) {
        return this.asLeaderWith(this.taskMaster.getTaskActionClient(holder.getTask()), new Function<TaskActionClient, Response>(){

            public Response apply(TaskActionClient taskActionClient) {
                HashMap retMap;
                try {
                    Object ret = taskActionClient.submit(holder.getAction());
                    retMap = Maps.newHashMap();
                    retMap.put("result", ret);
                }
                catch (IOException e) {
                    log.warn((Throwable)e, "Failed to perform task action", new Object[0]);
                    return Response.serverError().build();
                }
                return Response.ok().entity((Object)retMap).build();
            }
        });
    }

    @GET
    @Path(value="/waitingTasks")
    @Produces(value={"application/json"})
    public Response getWaitingTasks(final @Context HttpServletRequest req) {
        return this.workItemsResponse(new Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>>(){

            public Collection<? extends TaskRunnerWorkItem> apply(TaskRunner taskRunner) {
                ImmutableList activeTasks;
                ImmutableList allActiveTasks = OverlordResource.this.taskStorageQueryAdapter.getActiveTasks();
                if (OverlordResource.this.authConfig.isEnabled()) {
                    final HashMap resourceAccessMap = new HashMap();
                    final AuthorizationInfo authorizationInfo = (AuthorizationInfo)req.getAttribute("Druid-Auth-Token");
                    activeTasks = ImmutableList.copyOf((Iterable)Iterables.filter(allActiveTasks, (Predicate)new Predicate<Task>(){

                        public boolean apply(Task input) {
                            Action action;
                            Resource resource = new Resource(input.getDataSource(), ResourceType.DATASOURCE);
                            Pair key = new Pair((Object)resource, (Object)(action = Action.READ));
                            if (resourceAccessMap.containsKey(key)) {
                                return ((Access)resourceAccessMap.get(key)).isAllowed();
                            }
                            Access access = authorizationInfo.isAuthorized((Resource)key.lhs, (Action)key.rhs);
                            resourceAccessMap.put(key, access);
                            return access.isAllowed();
                        }
                    }));
                } else {
                    activeTasks = allActiveTasks;
                }
                HashSet runnersKnownTasks = Sets.newHashSet((Iterable)Iterables.transform(taskRunner.getKnownTasks(), (Function)new Function<TaskRunnerWorkItem, String>(){

                    public String apply(TaskRunnerWorkItem workItem) {
                        return workItem.getTaskId();
                    }
                }));
                ArrayList waitingTasks = Lists.newArrayList();
                for (Task task : activeTasks) {
                    if (runnersKnownTasks.contains(task.getId())) continue;
                    waitingTasks.add(new TaskRunnerWorkItem(task.getId(), (ListenableFuture)SettableFuture.create(), new DateTime(0L), new DateTime(0L)){

                        @Override
                        public TaskLocation getLocation() {
                            return TaskLocation.unknown();
                        }
                    });
                }
                return waitingTasks;
            }
        });
    }

    @GET
    @Path(value="/pendingTasks")
    @Produces(value={"application/json"})
    public Response getPendingTasks(final @Context HttpServletRequest req) {
        return this.workItemsResponse(new Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>>(){

            public Collection<? extends TaskRunnerWorkItem> apply(TaskRunner taskRunner) {
                if (OverlordResource.this.authConfig.isEnabled()) {
                    return OverlordResource.this.securedTaskRunnerWorkItem(taskRunner.getPendingTasks(), req);
                }
                return taskRunner.getPendingTasks();
            }
        });
    }

    @GET
    @Path(value="/runningTasks")
    @Produces(value={"application/json"})
    public Response getRunningTasks(final @Context HttpServletRequest req) {
        return this.workItemsResponse(new Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>>(){

            public Collection<? extends TaskRunnerWorkItem> apply(TaskRunner taskRunner) {
                if (OverlordResource.this.authConfig.isEnabled()) {
                    return OverlordResource.this.securedTaskRunnerWorkItem(taskRunner.getRunningTasks(), req);
                }
                return taskRunner.getRunningTasks();
            }
        });
    }

    @GET
    @Path(value="/completeTasks")
    @Produces(value={"application/json"})
    public Response getCompleteTasks(@Context HttpServletRequest req) {
        ImmutableList recentlyFinishedTasks;
        if (this.authConfig.isEnabled()) {
            final HashMap resourceAccessMap = new HashMap();
            final AuthorizationInfo authorizationInfo = (AuthorizationInfo)req.getAttribute("Druid-Auth-Token");
            recentlyFinishedTasks = ImmutableList.copyOf((Iterable)Iterables.filter(this.taskStorageQueryAdapter.getRecentlyFinishedTaskStatuses(), (Predicate)new Predicate<TaskStatus>(){

                public boolean apply(TaskStatus input) {
                    Action action;
                    String taskId = input.getId();
                    Optional<Task> optionalTask = OverlordResource.this.taskStorageQueryAdapter.getTask(taskId);
                    if (!optionalTask.isPresent()) {
                        throw new WebApplicationException(Response.serverError().entity((Object)String.format("No task information found for task with id: [%s]", taskId)).build());
                    }
                    Resource resource = new Resource(((Task)optionalTask.get()).getDataSource(), ResourceType.DATASOURCE);
                    Pair key = new Pair((Object)resource, (Object)(action = Action.READ));
                    if (resourceAccessMap.containsKey(key)) {
                        return ((Access)resourceAccessMap.get(key)).isAllowed();
                    }
                    Access access = authorizationInfo.isAuthorized((Resource)key.lhs, (Action)key.rhs);
                    resourceAccessMap.put(key, access);
                    return access.isAllowed();
                }
            }));
        } else {
            recentlyFinishedTasks = this.taskStorageQueryAdapter.getRecentlyFinishedTaskStatuses();
        }
        List completeTasks = Lists.transform(recentlyFinishedTasks, (Function)new Function<TaskStatus, TaskResponseObject>(){

            public TaskResponseObject apply(TaskStatus taskStatus) {
                return new TaskResponseObject(taskStatus.getId(), new DateTime(0L), new DateTime(0L), Optional.of((Object)taskStatus), TaskLocation.unknown());
            }
        });
        return Response.ok((Object)completeTasks).build();
    }

    @GET
    @Path(value="/workers")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getWorkers() {
        return this.asLeaderWith(this.taskMaster.getTaskRunner(), new Function<TaskRunner, Response>(){

            public Response apply(TaskRunner taskRunner) {
                if (taskRunner instanceof WorkerTaskRunner) {
                    return Response.ok(((WorkerTaskRunner)taskRunner).getWorkers()).build();
                }
                log.debug("Task runner [%s] of type [%s] does not support listing workers", new Object[]{taskRunner, taskRunner.getClass().getCanonicalName()});
                return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Task Runner does not support worker listing")).build();
            }
        });
    }

    @GET
    @Path(value="/scaling")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getScalingState() {
        Optional<ScalingStats> rms = this.taskMaster.getScalingStats();
        if (rms.isPresent()) {
            return Response.ok((Object)rms.get()).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/task/{taskid}/log")
    @Produces(value={"text/plain"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response doGetLog(@PathParam(value="taskid") String taskid, @QueryParam(value="offset") @DefaultValue(value="0") long offset) {
        try {
            Optional stream = this.taskLogStreamer.streamTaskLog(taskid, offset);
            if (stream.isPresent()) {
                return Response.ok((Object)((ByteSource)stream.get()).openStream()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No log was found for this task. The task may not exist, or it may not have begun running yet.").build();
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to stream log for task %s", new Object[]{taskid});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Response workItemsResponse(final Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>> fn) {
        return this.asLeaderWith(this.taskMaster.getTaskRunner(), new Function<TaskRunner, Response>(){

            public Response apply(TaskRunner taskRunner) {
                return Response.ok((Object)Lists.transform((List)Lists.newArrayList((Iterable)((Iterable)fn.apply((Object)taskRunner))), (Function)new Function<TaskRunnerWorkItem, TaskResponseObject>(){

                    public TaskResponseObject apply(TaskRunnerWorkItem workItem) {
                        return new TaskResponseObject(workItem.getTaskId(), workItem.getCreatedTime(), workItem.getQueueInsertionTime(), Optional.absent(), workItem.getLocation());
                    }
                })).build();
            }
        });
    }

    private <T> Response optionalTaskResponse(String taskid, String objectType, Optional<T> x) {
        HashMap results = Maps.newHashMap();
        results.put("task", taskid);
        if (x.isPresent()) {
            results.put(objectType, x.get());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)results).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)results).build();
    }

    private <T> Response asLeaderWith(Optional<T> x, Function<T, Response> f) {
        if (x.isPresent()) {
            return (Response)f.apply(x.get());
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    private Collection<? extends TaskRunnerWorkItem> securedTaskRunnerWorkItem(Collection<? extends TaskRunnerWorkItem> collectionToFilter, HttpServletRequest req) {
        final HashMap resourceAccessMap = new HashMap();
        final AuthorizationInfo authorizationInfo = (AuthorizationInfo)req.getAttribute("Druid-Auth-Token");
        return Collections2.filter(collectionToFilter, (Predicate)new Predicate<TaskRunnerWorkItem>(){

            public boolean apply(TaskRunnerWorkItem input) {
                Action action;
                String taskId = input.getTaskId();
                Optional<Task> optionalTask = OverlordResource.this.taskStorageQueryAdapter.getTask(taskId);
                if (!optionalTask.isPresent()) {
                    throw new WebApplicationException(Response.serverError().entity((Object)String.format("No task information found for task with id: [%s]", taskId)).build());
                }
                Resource resource = new Resource(((Task)optionalTask.get()).getDataSource(), ResourceType.DATASOURCE);
                Pair key = new Pair((Object)resource, (Object)(action = Action.READ));
                if (resourceAccessMap.containsKey(key)) {
                    return ((Access)resourceAccessMap.get(key)).isAllowed();
                }
                Access access = authorizationInfo.isAuthorized((Resource)key.lhs, (Action)key.rhs);
                resourceAccessMap.put(key, access);
                return access.isAllowed();
            }
        });
    }

    static class TaskResponseObject {
        private final String id;
        private final DateTime createdTime;
        private final DateTime queueInsertionTime;
        private final Optional<TaskStatus> status;
        private final TaskLocation location;

        private TaskResponseObject(String id, DateTime createdTime, DateTime queueInsertionTime, Optional<TaskStatus> status, TaskLocation location) {
            this.id = id;
            this.createdTime = createdTime;
            this.queueInsertionTime = queueInsertionTime;
            this.status = status;
            this.location = location;
        }

        @JsonValue
        public Map<String, Object> toJson() {
            LinkedHashMap data = Maps.newLinkedHashMap();
            data.put("id", this.id);
            if (this.createdTime.getMillis() > 0L) {
                data.put("createdTime", this.createdTime);
            }
            if (this.queueInsertionTime.getMillis() > 0L) {
                data.put("queueInsertionTime", this.queueInsertionTime);
            }
            if (this.status.isPresent()) {
                data.put("statusCode", ((TaskStatus)this.status.get()).getStatusCode().toString());
                if (((TaskStatus)this.status.get()).isComplete()) {
                    data.put("duration", ((TaskStatus)this.status.get()).getDuration());
                }
            }
            if (this.location != null) {
                data.put("location", this.location);
            }
            return data;
        }
    }
}

