/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.ImmutableWorkerInfo;
import io.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import io.druid.indexing.overlord.setup.WorkerSelectStrategy;
import javax.script.Compilable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JavaScriptWorkerSelectStrategy
implements WorkerSelectStrategy {
    private final SelectorFunction fnSelector;
    private final String function;

    @JsonCreator
    public JavaScriptWorkerSelectStrategy(@JsonProperty(value="function") String fn) {
        Preconditions.checkNotNull((Object)fn, (Object)"function must not be null");
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
        try {
            ((Compilable)((Object)engine)).compile("var apply = " + fn).eval();
        }
        catch (ScriptException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.function = fn;
        this.fnSelector = ((Invocable)((Object)engine)).getInterface(SelectorFunction.class);
    }

    @Override
    public Optional<ImmutableWorkerInfo> findWorkerForTask(WorkerTaskRunnerConfig config, ImmutableMap<String, ImmutableWorkerInfo> zkWorkers, Task task) {
        String worker = this.fnSelector.apply(config, zkWorkers, task);
        return Optional.fromNullable(worker == null ? null : (ImmutableWorkerInfo)zkWorkers.get((Object)worker));
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptWorkerSelectStrategy that = (JavaScriptWorkerSelectStrategy)o;
        return !(this.function != null ? !this.function.equals(that.function) : that.function != null);
    }

    public int hashCode() {
        return this.function.hashCode();
    }

    public String toString() {
        return "JavaScriptWorkerSelectStrategy{function='" + this.function + '\'' + '}';
    }

    public static interface SelectorFunction {
        public String apply(WorkerTaskRunnerConfig var1, ImmutableMap<String, ImmutableWorkerInfo> var2, Task var3);
    }
}

