/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.metamx.common.Granularity;
import com.metamx.common.IAE;
import com.metamx.common.logger.Logger;
import io.druid.granularity.QueryGranularity;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import io.druid.segment.realtime.appenderator.SegmentIdentifier;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class SegmentAllocateAction
implements TaskAction<SegmentIdentifier> {
    private static final Logger log = new Logger(SegmentAllocateAction.class);
    private static final int MAX_ATTEMPTS = 90;
    private final String dataSource;
    private final DateTime timestamp;
    private final QueryGranularity queryGranularity;
    private final Granularity preferredSegmentGranularity;
    private final String sequenceName;
    private final String previousSegmentId;

    public static List<Granularity> granularitiesFinerThan(Granularity gran0) {
        final DateTime epoch = new DateTime(0L);
        ArrayList retVal = Lists.newArrayList();
        for (Granularity gran : Granularity.values()) {
            if (gran.bucket(epoch).toDurationMillis() > gran0.bucket(epoch).toDurationMillis()) continue;
            retVal.add(gran);
        }
        Collections.sort(retVal, new Comparator<Granularity>(){

            @Override
            public int compare(Granularity g1, Granularity g2) {
                return Longs.compare((long)g2.bucket(epoch).toDurationMillis(), (long)g1.bucket(epoch).toDurationMillis());
            }
        });
        return retVal;
    }

    public SegmentAllocateAction(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="timestamp") DateTime timestamp, @JsonProperty(value="queryGranularity") QueryGranularity queryGranularity, @JsonProperty(value="preferredSegmentGranularity") Granularity preferredSegmentGranularity, @JsonProperty(value="sequenceName") String sequenceName, @JsonProperty(value="previousSegmentId") String previousSegmentId) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.timestamp = (DateTime)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
        this.queryGranularity = (QueryGranularity)Preconditions.checkNotNull((Object)queryGranularity, (Object)"queryGranularity");
        this.preferredSegmentGranularity = (Granularity)Preconditions.checkNotNull((Object)preferredSegmentGranularity, (Object)"preferredSegmentGranularity");
        this.sequenceName = (String)Preconditions.checkNotNull((Object)sequenceName, (Object)"sequenceName");
        this.previousSegmentId = previousSegmentId;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public QueryGranularity getQueryGranularity() {
        return this.queryGranularity;
    }

    @JsonProperty
    public Granularity getPreferredSegmentGranularity() {
        return this.preferredSegmentGranularity;
    }

    @JsonProperty
    public String getSequenceName() {
        return this.sequenceName;
    }

    @JsonProperty
    public String getPreviousSegmentId() {
        return this.previousSegmentId;
    }

    @Override
    public TypeReference<SegmentIdentifier> getReturnTypeReference() {
        return new TypeReference<SegmentIdentifier>(){};
    }

    @Override
    public SegmentIdentifier perform(Task task, TaskActionToolbox toolbox) throws IOException {
        block10: {
            Interval rowInterval;
            int attempt = 0;
            while (true) {
                ++attempt;
                if (!task.getDataSource().equals(this.dataSource)) {
                    throw new IAE("Task dataSource must match action dataSource, [%s] != [%s].", new Object[]{task.getDataSource(), this.dataSource});
                }
                IndexerMetadataStorageCoordinator msc = toolbox.getIndexerMetadataStorageCoordinator();
                ArrayList tryIntervals = Lists.newArrayList();
                rowInterval = new Interval(this.queryGranularity.truncate(this.timestamp.getMillis()), this.queryGranularity.next(this.queryGranularity.truncate(this.timestamp.getMillis())));
                ImmutableSet usedSegmentsForRow = ImmutableSet.copyOf((Collection)msc.getUsedSegmentsForInterval(this.dataSource, rowInterval));
                if (usedSegmentsForRow.isEmpty()) {
                    for (Granularity gran : SegmentAllocateAction.granularitiesFinerThan(this.preferredSegmentGranularity)) {
                        tryIntervals.add(gran.bucket(this.timestamp));
                    }
                } else {
                    tryIntervals.add(((DataSegment)usedSegmentsForRow.iterator().next()).getInterval());
                }
                for (Interval tryInterval : tryIntervals) {
                    if (!tryInterval.contains((ReadableInterval)rowInterval)) continue;
                    log.debug("Trying to allocate pending segment for rowInterval[%s], segmentInterval[%s].", new Object[]{rowInterval, tryInterval});
                    TaskLock tryLock = (TaskLock)toolbox.getTaskLockbox().tryLock(task, tryInterval).orNull();
                    if (tryLock != null) {
                        SegmentIdentifier identifier = msc.allocatePendingSegment(this.dataSource, this.sequenceName, this.previousSegmentId, tryInterval, tryLock.getVersion());
                        if (identifier != null) {
                            return identifier;
                        }
                        log.debug("Could not allocate pending segment for rowInterval[%s], segmentInterval[%s].", new Object[]{rowInterval, tryInterval});
                        continue;
                    }
                    log.debug("Could not acquire lock for rowInterval[%s], segmentInterval[%s].", new Object[]{rowInterval, tryInterval});
                }
                if (ImmutableSet.copyOf((Collection)msc.getUsedSegmentsForInterval(this.dataSource, rowInterval)).equals((Object)usedSegmentsForRow)) break block10;
                if (attempt >= 90) break;
                long shortRandomSleep = 50L + (long)(Math.random() * 450.0);
                log.debug("Used segment set changed for rowInterval[%s]. Retrying segment allocation in %,dms (attempt = %,d).", new Object[]{rowInterval, shortRandomSleep, attempt});
                try {
                    Thread.sleep(shortRandomSleep);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Throwables.propagate((Throwable)e);
                }
            }
            log.error("Used segment set changed for rowInterval[%s]. Not trying again (attempt = %,d).", new Object[]{rowInterval, attempt});
            return null;
        }
        return null;
    }

    @Override
    public boolean isAudited() {
        return false;
    }

    public String toString() {
        return "SegmentAllocateAction{dataSource='" + this.dataSource + '\'' + ", timestamp=" + this.timestamp + ", queryGranularity=" + this.queryGranularity + ", preferredSegmentGranularity=" + this.preferredSegmentGranularity + ", sequenceName='" + this.sequenceName + '\'' + ", previousSegmentId='" + this.previousSegmentId + '\'' + '}';
    }
}

