/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableSet;
import io.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.Set;

public class SegmentInsertAction
implements TaskAction<Set<DataSegment>> {
    private final Set<DataSegment> segments;

    @JsonCreator
    public SegmentInsertAction(@JsonProperty(value="segments") Set<DataSegment> segments) {
        this.segments = ImmutableSet.copyOf(segments);
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @Override
    public TypeReference<Set<DataSegment>> getReturnTypeReference() {
        return new TypeReference<Set<DataSegment>>(){};
    }

    @Override
    public Set<DataSegment> perform(Task task, TaskActionToolbox toolbox) throws IOException {
        return new SegmentTransactionalInsertAction(this.segments, null, null).perform(task, toolbox).getSegments();
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    public String toString() {
        return "SegmentInsertAction{segments=" + this.segments + '}';
    }
}

