/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableSet;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.DataSourceMetadata;
import io.druid.indexing.overlord.SegmentPublishResult;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.Set;

public class SegmentTransactionalInsertAction
implements TaskAction<SegmentPublishResult> {
    private final Set<DataSegment> segments;
    private final DataSourceMetadata startMetadata;
    private final DataSourceMetadata endMetadata;

    public SegmentTransactionalInsertAction(Set<DataSegment> segments) {
        this(segments, null, null);
    }

    @JsonCreator
    public SegmentTransactionalInsertAction(@JsonProperty(value="segments") Set<DataSegment> segments, @JsonProperty(value="startMetadata") DataSourceMetadata startMetadata, @JsonProperty(value="endMetadata") DataSourceMetadata endMetadata) {
        this.segments = ImmutableSet.copyOf(segments);
        this.startMetadata = startMetadata;
        this.endMetadata = endMetadata;
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public DataSourceMetadata getStartMetadata() {
        return this.startMetadata;
    }

    @JsonProperty
    public DataSourceMetadata getEndMetadata() {
        return this.endMetadata;
    }

    @Override
    public TypeReference<SegmentPublishResult> getReturnTypeReference() {
        return new TypeReference<SegmentPublishResult>(){};
    }

    @Override
    public SegmentPublishResult perform(Task task, TaskActionToolbox toolbox) throws IOException {
        toolbox.verifyTaskLocks(task, this.segments);
        SegmentPublishResult retVal = toolbox.getIndexerMetadataStorageCoordinator().announceHistoricalSegments(this.segments, this.startMetadata, this.endMetadata);
        ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder().setDimension("dataSource", task.getDataSource()).setDimension("taskType", task.getType());
        if (retVal.isSuccess()) {
            toolbox.getEmitter().emit(metricBuilder.build("segment/txn/success", (Number)1));
        } else {
            toolbox.getEmitter().emit(metricBuilder.build("segment/txn/failure", (Number)1));
        }
        for (DataSegment segment : retVal.getSegments()) {
            metricBuilder.setDimension("interval", segment.getInterval().toString());
            toolbox.getEmitter().emit(metricBuilder.build("segment/added/bytes", (Number)segment.getSize()));
        }
        return retVal;
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    public String toString() {
        return "SegmentInsertAction{segments=" + this.segments + ", startMetadata=" + this.startMetadata + ", endMetadata=" + this.endMetadata + '}';
    }
}

