/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.metamx.common.ISE;
import com.metamx.common.guava.Comparators;
import com.metamx.common.logger.Logger;
import io.druid.data.input.Committer;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.data.input.Rows;
import io.druid.granularity.QueryGranularity;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.index.YeOldePlumberSchool;
import io.druid.indexing.common.task.AbstractFixedIntervalTask;
import io.druid.indexing.common.task.TaskResource;
import io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import io.druid.segment.IndexSpec;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.IOConfig;
import io.druid.segment.indexing.IngestionSpec;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.indexing.TuningConfig;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.plumber.Committers;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.HashBasedNumberedShardSpec;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.NumberedShardSpec;
import io.druid.timeline.partition.ShardSpec;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexTask
extends AbstractFixedIntervalTask {
    private static final Logger log = new Logger(IndexTask.class);
    private static HashFunction hashFunction = Hashing.murmur3_128();
    @JsonIgnore
    private final IndexIngestionSpec ingestionSchema;
    private final ObjectMapper jsonMapper;

    private static boolean shouldIndex(ShardSpec shardSpec, Interval interval, InputRow inputRow, QueryGranularity rollupGran) {
        return interval.contains(inputRow.getTimestampFromEpoch()) && shardSpec.isInChunk(rollupGran.truncate(inputRow.getTimestampFromEpoch()), inputRow);
    }

    private static String makeId(String id, IndexIngestionSpec ingestionSchema) {
        if (id == null) {
            return String.format("index_%s_%s", IndexTask.makeDataSource(ingestionSchema), new DateTime().toString());
        }
        return id;
    }

    private static String makeDataSource(IndexIngestionSpec ingestionSchema) {
        return ingestionSchema.getDataSchema().getDataSource();
    }

    private static Interval makeInterval(IndexIngestionSpec ingestionSchema) {
        GranularitySpec spec = ingestionSchema.getDataSchema().getGranularitySpec();
        return new Interval((ReadableInstant)((Interval)((SortedSet)spec.bucketIntervals().get()).first()).getStart(), (ReadableInstant)((Interval)((SortedSet)spec.bucketIntervals().get()).last()).getEnd());
    }

    static RealtimeTuningConfig convertTuningConfig(ShardSpec shardSpec, int rowFlushBoundary, IndexSpec indexSpec, boolean buildV9Directly) {
        return new RealtimeTuningConfig(Integer.valueOf(rowFlushBoundary), null, null, null, null, null, null, shardSpec, indexSpec, Boolean.valueOf(buildV9Directly), 0, 0, Boolean.valueOf(true), null);
    }

    @JsonCreator
    public IndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="spec") IndexIngestionSpec ingestionSchema, @JacksonInject ObjectMapper jsonMapper, @JsonProperty(value="context") Map<String, Object> context) {
        super(IndexTask.makeId(id, ingestionSchema), taskResource, IndexTask.makeDataSource(ingestionSchema), IndexTask.makeInterval(ingestionSchema), context);
        this.ingestionSchema = ingestionSchema;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public String getType() {
        return "index";
    }

    @JsonProperty(value="spec")
    public IndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        int targetPartitionSize = this.ingestionSchema.getTuningConfig().getTargetPartitionSize();
        TaskLock myLock = (TaskLock)Iterables.getOnlyElement(this.getTaskLocks(toolbox));
        HashSet segments = Sets.newHashSet();
        Sets.SetView validIntervals = Sets.intersection((Set)((Set)granularitySpec.bucketIntervals().get()), this.getDataIntervals());
        if (validIntervals.isEmpty()) {
            throw new ISE("No valid data intervals found. Check your configs!", new Object[0]);
        }
        for (Interval bucket : validIntervals) {
            ArrayList shardSpecs;
            if (targetPartitionSize > 0) {
                shardSpecs = this.determinePartitions(bucket, targetPartitionSize, granularitySpec.getQueryGranularity());
            } else {
                int numShards = this.ingestionSchema.getTuningConfig().getNumShards();
                if (numShards > 0) {
                    shardSpecs = Lists.newArrayList();
                    for (int i = 0; i < numShards; ++i) {
                        shardSpecs.add(new HashBasedNumberedShardSpec(i, numShards, null, this.jsonMapper));
                    }
                } else {
                    shardSpecs = ImmutableList.of((Object)NoneShardSpec.instance());
                }
            }
            for (ShardSpec shardSpec : shardSpecs) {
                Object shardSpecForPublishing = this.ingestionSchema.getTuningConfig().isForceExtendableShardSpecs() ? new NumberedShardSpec(shardSpec.getPartitionNum(), shardSpecs.size()) : shardSpec;
                DataSegment segment = this.generateSegment(toolbox, this.ingestionSchema.getDataSchema(), shardSpec, (ShardSpec)shardSpecForPublishing, bucket, myLock.getVersion());
                segments.add(segment);
            }
        }
        toolbox.publishSegments(segments);
        return TaskStatus.success(this.getId());
    }

    private SortedSet<Interval> getDataIntervals() throws IOException {
        FirehoseFactory firehoseFactory = this.ingestionSchema.getIOConfig().getFirehoseFactory();
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        TreeSet retVal = Sets.newTreeSet((Comparator)Comparators.intervalsByStartThenEnd());
        int unparsed = 0;
        try (Firehose firehose = firehoseFactory.connect(this.ingestionSchema.getDataSchema().getParser());){
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                DateTime dt = new DateTime(inputRow.getTimestampFromEpoch());
                Optional interval = granularitySpec.bucketInterval(dt);
                if (interval.isPresent()) {
                    retVal.add(interval.get());
                    continue;
                }
                ++unparsed;
            }
        }
        if (unparsed > 0) {
            log.warn("Unable to to find a matching interval for [%,d] events", new Object[]{unparsed});
        }
        return retVal;
    }

    private List<ShardSpec> determinePartitions(Interval interval, int targetPartitionSize, QueryGranularity queryGranularity) throws IOException {
        log.info("Determining partitions for interval[%s] with targetPartitionSize[%d]", new Object[]{interval, targetPartitionSize});
        FirehoseFactory firehoseFactory = this.ingestionSchema.getIOConfig().getFirehoseFactory();
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        try (Firehose firehose = firehoseFactory.connect(this.ingestionSchema.getDataSchema().getParser());){
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                if (!interval.contains(inputRow.getTimestampFromEpoch())) continue;
                List groupKey = Rows.toGroupKey((long)queryGranularity.truncate(inputRow.getTimestampFromEpoch()), (InputRow)inputRow);
                collector.add(hashFunction.hashBytes(this.jsonMapper.writeValueAsBytes((Object)groupKey)).asBytes());
            }
        }
        double numRows = collector.estimateCardinality();
        log.info("Estimated approximately [%,f] rows of data.", new Object[]{numRows});
        int numberOfShards = (int)Math.ceil(numRows / (double)targetPartitionSize);
        if ((double)numberOfShards > numRows) {
            numberOfShards = (int)numRows;
        }
        log.info("Will require [%,d] shard(s).", new Object[]{numberOfShards});
        ArrayList shardSpecs = Lists.newArrayList();
        if (numberOfShards == 1) {
            shardSpecs.add(NoneShardSpec.instance());
        } else {
            for (int i = 0; i < numberOfShards; ++i) {
                shardSpecs.add(new HashBasedNumberedShardSpec(i, numberOfShards, null, this.jsonMapper));
            }
        }
        return shardSpecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSegment generateSegment(final TaskToolbox toolbox, DataSchema schema, ShardSpec shardSpecForPartitioning, ShardSpec shardSpecForPublishing, Interval interval, String version) throws IOException {
        File tmpDir = new File(toolbox.getTaskWorkDir(), String.format("%s_%s_%s_%s_%s", this.getDataSource(), interval.getStart(), interval.getEnd(), version, shardSpecForPartitioning.getPartitionNum()));
        FirehoseFactory firehoseFactory = this.ingestionSchema.getIOConfig().getFirehoseFactory();
        int rowFlushBoundary = this.ingestionSchema.getTuningConfig().getRowFlushBoundary();
        final CopyOnWriteArrayList pushedSegments = new CopyOnWriteArrayList();
        DataSegmentPusher wrappedDataSegmentPusher = new DataSegmentPusher(){

            @Deprecated
            public String getPathForHadoop(String dataSource) {
                return this.getPathForHadoop();
            }

            public String getPathForHadoop() {
                return toolbox.getSegmentPusher().getPathForHadoop();
            }

            public DataSegment push(File file, DataSegment segment) throws IOException {
                DataSegment pushedSegment = toolbox.getSegmentPusher().push(file, segment);
                pushedSegments.add(pushedSegment);
                return pushedSegment;
            }
        };
        int myRowFlushBoundary = rowFlushBoundary > 0 ? rowFlushBoundary : toolbox.getConfig().getDefaultRowFlushBoundary();
        FireDepartmentMetrics metrics = new FireDepartmentMetrics();
        Firehose firehose = firehoseFactory.connect(this.ingestionSchema.getDataSchema().getParser());
        Supplier committerSupplier = Committers.supplierFromFirehose((Firehose)firehose);
        Plumber plumber = new YeOldePlumberSchool(interval, version, wrappedDataSegmentPusher, tmpDir, toolbox.getIndexMerger(), toolbox.getIndexMergerV9(), toolbox.getIndexIO()).findPlumber(schema, IndexTask.convertTuningConfig(shardSpecForPublishing, myRowFlushBoundary, this.ingestionSchema.getTuningConfig().getIndexSpec(), this.ingestionSchema.tuningConfig.getBuildV9Directly()), metrics);
        QueryGranularity rollupGran = this.ingestionSchema.getDataSchema().getGranularitySpec().getQueryGranularity();
        try {
            plumber.startJob();
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                if (IndexTask.shouldIndex(shardSpecForPartitioning, interval, inputRow, rollupGran)) {
                    int numRows = plumber.add(inputRow, committerSupplier);
                    if (numRows == -1) {
                        throw new ISE(String.format("Was expecting non-null sink for timestamp[%s]", new DateTime(inputRow.getTimestampFromEpoch())), new Object[0]);
                    }
                    metrics.incrementProcessed();
                    continue;
                }
                metrics.incrementThrownAway();
            }
        }
        finally {
            firehose.close();
        }
        plumber.persist((Committer)committerSupplier.get());
        try {
            plumber.finishJob();
        }
        catch (Throwable throwable) {
            log.info("Task[%s] interval[%s] partition[%d] took in %,d rows (%,d processed, %,d unparseable, %,d thrown away) and output %,d rows", new Object[]{this.getId(), interval, shardSpecForPartitioning.getPartitionNum(), metrics.processed() + metrics.unparseable() + metrics.thrownAway(), metrics.processed(), metrics.unparseable(), metrics.thrownAway(), metrics.rowOutput()});
            throw throwable;
        }
        log.info("Task[%s] interval[%s] partition[%d] took in %,d rows (%,d processed, %,d unparseable, %,d thrown away) and output %,d rows", new Object[]{this.getId(), interval, shardSpecForPartitioning.getPartitionNum(), metrics.processed() + metrics.unparseable() + metrics.thrownAway(), metrics.processed(), metrics.unparseable(), metrics.thrownAway(), metrics.rowOutput()});
        return (DataSegment)Iterables.getOnlyElement(pushedSegments);
    }

    @JsonTypeName(value="index")
    public static class IndexTuningConfig
    implements TuningConfig {
        private static final int DEFAULT_TARGET_PARTITION_SIZE = 5000000;
        private static final int DEFAULT_ROW_FLUSH_BOUNDARY = 75000;
        private static final IndexSpec DEFAULT_INDEX_SPEC = new IndexSpec();
        private static final Boolean DEFAULT_BUILD_V9_DIRECTLY = Boolean.FALSE;
        private final int targetPartitionSize;
        private final int rowFlushBoundary;
        private final int numShards;
        private final IndexSpec indexSpec;
        private final Boolean buildV9Directly;
        private final boolean forceExtendableShardSpecs;

        @JsonCreator
        public IndexTuningConfig(@JsonProperty(value="targetPartitionSize") int targetPartitionSize, @JsonProperty(value="rowFlushBoundary") int rowFlushBoundary, @JsonProperty(value="numShards") @Nullable Integer numShards, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="forceExtendableShardSpecs") boolean forceExtendableShardSpecs) {
            this.targetPartitionSize = targetPartitionSize == 0 ? 5000000 : targetPartitionSize;
            Preconditions.checkArgument((rowFlushBoundary >= 0 ? 1 : 0) != 0, (Object)"rowFlushBoundary should be positive or zero");
            this.rowFlushBoundary = rowFlushBoundary == 0 ? 75000 : rowFlushBoundary;
            this.numShards = numShards == null ? -1 : numShards;
            this.indexSpec = indexSpec == null ? DEFAULT_INDEX_SPEC : indexSpec;
            Preconditions.checkArgument((this.targetPartitionSize == -1 || this.numShards == -1 ? 1 : 0) != 0, (Object)"targetPartitionsSize and shardCount both cannot be set");
            this.buildV9Directly = buildV9Directly == null ? DEFAULT_BUILD_V9_DIRECTLY : buildV9Directly;
            this.forceExtendableShardSpecs = forceExtendableShardSpecs;
        }

        @JsonProperty
        public int getTargetPartitionSize() {
            return this.targetPartitionSize;
        }

        @JsonProperty
        public int getRowFlushBoundary() {
            return this.rowFlushBoundary;
        }

        @JsonProperty
        public int getNumShards() {
            return this.numShards;
        }

        @JsonProperty
        public IndexSpec getIndexSpec() {
            return this.indexSpec;
        }

        @JsonProperty
        public Boolean getBuildV9Directly() {
            return this.buildV9Directly;
        }

        @JsonProperty
        public boolean isForceExtendableShardSpecs() {
            return this.forceExtendableShardSpecs;
        }
    }

    @JsonTypeName(value="index")
    public static class IndexIOConfig
    implements IOConfig {
        private final FirehoseFactory firehoseFactory;

        @JsonCreator
        public IndexIOConfig(@JsonProperty(value="firehose") FirehoseFactory firehoseFactory) {
            this.firehoseFactory = firehoseFactory;
        }

        @JsonProperty(value="firehose")
        public FirehoseFactory getFirehoseFactory() {
            return this.firehoseFactory;
        }
    }

    public static class IndexIngestionSpec
    extends IngestionSpec<IndexIOConfig, IndexTuningConfig> {
        private final DataSchema dataSchema;
        private final IndexIOConfig ioConfig;
        private final IndexTuningConfig tuningConfig;

        @JsonCreator
        public IndexIngestionSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") IndexIOConfig ioConfig, @JsonProperty(value="tuningConfig") IndexTuningConfig tuningConfig) {
            super(dataSchema, (IOConfig)ioConfig, (TuningConfig)tuningConfig);
            this.dataSchema = dataSchema;
            this.ioConfig = ioConfig;
            this.tuningConfig = tuningConfig == null ? new IndexTuningConfig(0, 0, null, null, null, false) : tuningConfig;
        }

        @JsonProperty(value="dataSchema")
        public DataSchema getDataSchema() {
            return this.dataSchema;
        }

        @JsonProperty(value="ioConfig")
        public IndexIOConfig getIOConfig() {
            return this.ioConfig;
        }

        @JsonProperty(value="tuningConfig")
        public IndexTuningConfig getTuningConfig() {
            return this.tuningConfig;
        }
    }
}

