/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.task.MergeTaskBase;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.IndexSpec;
import io.druid.segment.QueryableIndex;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class MergeTask
extends MergeTaskBase {
    @JsonIgnore
    private final List<AggregatorFactory> aggregators;
    private final Boolean rollup;
    private final IndexSpec indexSpec;

    @JsonCreator
    public MergeTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segments") List<DataSegment> segments, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregators, @JsonProperty(value="rollup") Boolean rollup, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="context") Map<String, Object> context) {
        super(id, dataSource, segments, context);
        this.aggregators = (List)Preconditions.checkNotNull(aggregators, (Object)"null aggregations");
        this.rollup = rollup == null ? Boolean.TRUE : rollup;
        this.indexSpec = indexSpec == null ? new IndexSpec() : indexSpec;
    }

    @Override
    public File merge(final TaskToolbox toolbox, Map<DataSegment, File> segments, File outDir) throws Exception {
        return toolbox.getIndexMerger().mergeQueryableIndex(Lists.transform((List)ImmutableList.copyOf(segments.values()), (Function)new Function<File, QueryableIndex>(){

            public QueryableIndex apply(@Nullable File input) {
                try {
                    return toolbox.getIndexIO().loadIndex(input);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }), this.rollup.booleanValue(), this.aggregators.toArray(new AggregatorFactory[this.aggregators.size()]), outDir, this.indexSpec);
    }

    @Override
    public String getType() {
        return "merge";
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregators() {
        return this.aggregators;
    }
}

