/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.util.concurrent.ListenableFuture;
import io.druid.indexing.common.TaskLocation;
import io.druid.indexing.common.TaskStatus;
import org.joda.time.DateTime;

public abstract class TaskRunnerWorkItem {
    private final String taskId;
    private final ListenableFuture<TaskStatus> result;
    private final DateTime createdTime;
    private final DateTime queueInsertionTime;

    public TaskRunnerWorkItem(String taskId, ListenableFuture<TaskStatus> result) {
        this(taskId, result, new DateTime(), new DateTime());
    }

    public TaskRunnerWorkItem(String taskId, ListenableFuture<TaskStatus> result, DateTime createdTime, DateTime queueInsertionTime) {
        this.taskId = taskId;
        this.result = result;
        this.createdTime = createdTime;
        this.queueInsertionTime = queueInsertionTime;
    }

    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @JsonIgnore
    public ListenableFuture<TaskStatus> getResult() {
        return this.result;
    }

    @JsonProperty
    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    @JsonProperty
    public DateTime getQueueInsertionTime() {
        return this.queueInsertionTime;
    }

    public abstract TaskLocation getLocation();

    public String toString() {
        return "TaskRunnerWorkItem{taskId='" + this.taskId + '\'' + ", result=" + this.result + ", createdTime=" + this.createdTime + ", queueInsertionTime=" + this.queueInsertionTime + ", location=" + this.getLocation() + '}';
    }
}

