/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.concurrent.Execs;
import io.druid.concurrent.TaskThreadPriority;
import io.druid.guice.annotations.Self;
import io.druid.indexing.common.TaskLocation;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.TaskToolboxFactory;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerListener;
import io.druid.indexing.overlord.TaskRunnerUtils;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.overlord.autoscaling.ScalingStats;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.SegmentDescriptor;
import io.druid.server.DruidNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class ThreadPoolTaskRunner
implements TaskRunner,
QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ThreadPoolTaskRunner.class);
    private final TaskToolboxFactory toolboxFactory;
    private final TaskConfig taskConfig;
    private final ConcurrentMap<Integer, ListeningExecutorService> exec = new ConcurrentHashMap<Integer, ListeningExecutorService>();
    private final Set<ThreadPoolTaskRunnerWorkItem> runningItems = new ConcurrentSkipListSet<ThreadPoolTaskRunnerWorkItem>(ThreadPoolTaskRunnerWorkItem.access$000());
    private final CopyOnWriteArrayList<Pair<TaskRunnerListener, Executor>> listeners = new CopyOnWriteArrayList();
    private final ServiceEmitter emitter;
    private final TaskLocation location;
    private volatile boolean stopping = false;

    @Inject
    public ThreadPoolTaskRunner(TaskToolboxFactory toolboxFactory, TaskConfig taskConfig, ServiceEmitter emitter, @Self DruidNode node) {
        this.toolboxFactory = (TaskToolboxFactory)Preconditions.checkNotNull((Object)toolboxFactory, (Object)"toolboxFactory");
        this.taskConfig = taskConfig;
        this.emitter = (ServiceEmitter)Preconditions.checkNotNull((Object)emitter, (Object)"emitter");
        this.location = TaskLocation.create(node.getHost(), node.getPort());
    }

    @Override
    public List<Pair<Task, ListenableFuture<TaskStatus>>> restore() {
        return ImmutableList.of();
    }

    @Override
    public void registerListener(TaskRunnerListener listener, Executor executor) {
        for (Pair<TaskRunnerListener, Executor> pair : this.listeners) {
            if (!((TaskRunnerListener)pair.lhs).getListenerId().equals(listener.getListenerId())) continue;
            throw new ISE("Listener [%s] already registered", new Object[]{listener.getListenerId()});
        }
        Pair listenerPair = Pair.of((Object)listener, (Object)executor);
        this.listeners.add((Pair<TaskRunnerListener, Executor>)listenerPair);
        log.info("Registered listener [%s]", new Object[]{listener.getListenerId()});
        for (ThreadPoolTaskRunnerWorkItem item : this.runningItems) {
            TaskRunnerUtils.notifyLocationChanged((Iterable<Pair<TaskRunnerListener, Executor>>)ImmutableList.of((Object)listenerPair), item.getTaskId(), item.getLocation());
        }
    }

    @Override
    public void unregisterListener(String listenerId) {
        for (Pair<TaskRunnerListener, Executor> pair : this.listeners) {
            if (!((TaskRunnerListener)pair.lhs).getListenerId().equals(listenerId)) continue;
            this.listeners.remove(pair);
            log.info("Unregistered listener [%s]", new Object[]{listenerId});
            return;
        }
    }

    private static ListeningExecutorService buildExecutorService(int priority) {
        return MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)("task-runner-%d-priority-" + priority), (Integer)TaskThreadPriority.getThreadPriorityFromTaskPriority((int)priority)));
    }

    @Override
    @LifecycleStop
    public void stop() {
        this.stopping = true;
        for (Map.Entry entry : this.exec.entrySet()) {
            try {
                ((ListeningExecutorService)entry.getValue()).shutdown();
            }
            catch (SecurityException ex) {
                log.wtf((Throwable)ex, "I can't control my own threads!", new Object[0]);
            }
        }
        for (ThreadPoolTaskRunnerWorkItem threadPoolTaskRunnerWorkItem : this.runningItems) {
            boolean graceful;
            Task task = threadPoolTaskRunnerWorkItem.getTask();
            long start = System.currentTimeMillis();
            boolean error = false;
            if (this.taskConfig.isRestoreTasksOnRestart() && task.canRestore()) {
                graceful = true;
                log.info("Starting graceful shutdown of task[%s].", new Object[]{task.getId()});
                try {
                    task.stopGracefully();
                    TaskStatus taskStatus = (TaskStatus)threadPoolTaskRunnerWorkItem.getResult().get(new Interval((ReadableInstant)new DateTime(start), (ReadablePeriod)this.taskConfig.getGracefulShutdownTimeout()).toDurationMillis(), TimeUnit.MILLISECONDS);
                    log.info("Graceful shutdown of task[%s] finished in %,dms.", new Object[]{task.getId(), System.currentTimeMillis() - start});
                    TaskRunnerUtils.notifyStatusChanged(this.listeners, task.getId(), taskStatus);
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Graceful task shutdown failed: %s", new Object[]{task.getDataSource()}).addData("taskId", (Object)task.getId()).addData("dataSource", (Object)task.getDataSource()).emit();
                    log.warn((Throwable)e, "Graceful shutdown of task[%s] aborted with exception.", new Object[]{task.getId()});
                    error = true;
                    TaskRunnerUtils.notifyStatusChanged(this.listeners, task.getId(), TaskStatus.failure(task.getId()));
                }
            } else {
                graceful = false;
                TaskRunnerUtils.notifyStatusChanged(this.listeners, task.getId(), TaskStatus.failure(task.getId()));
            }
            long elapsed = System.currentTimeMillis() - start;
            ServiceMetricEvent.Builder metricBuilder = ServiceMetricEvent.builder().setDimension("task", task.getId()).setDimension("dataSource", task.getDataSource()).setDimension("graceful", String.valueOf(graceful)).setDimension("error", String.valueOf(error));
            this.emitter.emit(metricBuilder.build("task/interrupt/count", (Number)1L));
            this.emitter.emit(metricBuilder.build("task/interrupt/elapsed", (Number)elapsed));
        }
        for (Map.Entry entry : this.exec.entrySet()) {
            try {
                ((ListeningExecutorService)entry.getValue()).shutdownNow();
            }
            catch (SecurityException ex) {
                log.wtf((Throwable)ex, "I can't control my own threads!", new Object[0]);
            }
        }
    }

    @Override
    public ListenableFuture<TaskStatus> run(Task task) {
        TaskToolbox toolbox = this.toolboxFactory.build(task);
        Object taskPriorityObj = task.getContextValue("backgroundThreadPriority");
        int taskPriority = 0;
        if (taskPriorityObj != null) {
            if (taskPriorityObj instanceof Number) {
                taskPriority = ((Number)taskPriorityObj).intValue();
            } else if (taskPriorityObj instanceof String) {
                try {
                    taskPriority = Integer.parseInt(taskPriorityObj.toString());
                }
                catch (NumberFormatException e) {
                    log.error((Throwable)e, "Error parsing task priority [%s] for task [%s]", new Object[]{taskPriorityObj, task.getId()});
                }
            }
        }
        if (!this.exec.containsKey(taskPriority)) {
            ListeningExecutorService executorService = ThreadPoolTaskRunner.buildExecutorService(taskPriority);
            if (this.exec.putIfAbsent(taskPriority, executorService) != null) {
                executorService.shutdownNow();
            }
        }
        ListenableFuture statusFuture = ((ListeningExecutorService)this.exec.get(taskPriority)).submit((Callable)new ThreadPoolTaskRunnerCallable(task, this.location, toolbox));
        final ThreadPoolTaskRunnerWorkItem taskRunnerWorkItem = new ThreadPoolTaskRunnerWorkItem(task, this.location, statusFuture);
        this.runningItems.add(taskRunnerWorkItem);
        Futures.addCallback((ListenableFuture)statusFuture, (FutureCallback)new FutureCallback<TaskStatus>(){

            public void onSuccess(TaskStatus result) {
                ThreadPoolTaskRunner.this.runningItems.remove(taskRunnerWorkItem);
            }

            public void onFailure(Throwable t) {
                ThreadPoolTaskRunner.this.runningItems.remove(taskRunnerWorkItem);
            }
        });
        return statusFuture;
    }

    @Override
    public void shutdown(String taskid) {
        for (TaskRunnerWorkItem taskRunnerWorkItem : this.runningItems) {
            if (!taskRunnerWorkItem.getTaskId().equals(taskid)) continue;
            taskRunnerWorkItem.getResult().cancel(true);
        }
    }

    public Collection<TaskRunnerWorkItem> getRunningTasks() {
        return ImmutableList.copyOf(this.runningItems);
    }

    public Collection<TaskRunnerWorkItem> getPendingTasks() {
        return ImmutableList.of();
    }

    public Collection<TaskRunnerWorkItem> getKnownTasks() {
        return ImmutableList.copyOf(this.runningItems);
    }

    @Override
    public Optional<ScalingStats> getScalingStats() {
        return Optional.absent();
    }

    @Override
    public void start() {
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return this.getQueryRunnerImpl(query);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        return this.getQueryRunnerImpl(query);
    }

    private <T> QueryRunner<T> getQueryRunnerImpl(Query<T> query) {
        QueryRunner<T> queryRunner = null;
        String queryDataSource = (String)Iterables.getOnlyElement((Iterable)query.getDataSource().getNames());
        for (ThreadPoolTaskRunnerWorkItem taskRunnerWorkItem : ImmutableList.copyOf(this.runningItems)) {
            QueryRunner<T> taskQueryRunner;
            Task task = taskRunnerWorkItem.getTask();
            if (!task.getDataSource().equals(queryDataSource) || (taskQueryRunner = task.getQueryRunner(query)) == null) continue;
            if (queryRunner == null) {
                queryRunner = taskQueryRunner;
                continue;
            }
            log.makeAlert("Found too many query runners for datasource", new Object[0]).addData("dataSource", (Object)queryDataSource).emit();
        }
        return queryRunner == null ? new QueryRunner<T>() : queryRunner;
    }

    private class ThreadPoolTaskRunnerCallable
    implements Callable<TaskStatus> {
        private final Task task;
        private final TaskLocation location;
        private final TaskToolbox toolbox;

        public ThreadPoolTaskRunnerCallable(Task task, TaskLocation location, TaskToolbox toolbox) {
            this.task = task;
            this.location = location;
            this.toolbox = toolbox;
        }

        @Override
        public TaskStatus call() {
            TaskStatus status;
            long startTime = System.currentTimeMillis();
            try {
                log.info("Running task: %s", new Object[]{this.task.getId()});
                TaskRunnerUtils.notifyLocationChanged(ThreadPoolTaskRunner.this.listeners, this.task.getId(), this.location);
                TaskRunnerUtils.notifyStatusChanged(ThreadPoolTaskRunner.this.listeners, this.task.getId(), TaskStatus.running(this.task.getId()));
                status = this.task.run(this.toolbox);
            }
            catch (InterruptedException e) {
                if (ThreadPoolTaskRunner.this.stopping) {
                    log.debug((Throwable)e, "Interrupted while running task[%s] during graceful shutdown.", new Object[]{this.task});
                } else {
                    log.warn((Throwable)e, "Interrupted while running task[%s]", new Object[]{this.task});
                }
                status = TaskStatus.failure(this.task.getId());
            }
            catch (Exception e) {
                log.error((Throwable)e, "Exception while running task[%s]", new Object[]{this.task});
                status = TaskStatus.failure(this.task.getId());
            }
            catch (Throwable t) {
                log.error(t, "Uncaught Throwable while running task[%s]", new Object[]{this.task});
                throw t;
            }
            status = status.withDuration(System.currentTimeMillis() - startTime);
            TaskRunnerUtils.notifyStatusChanged(ThreadPoolTaskRunner.this.listeners, this.task.getId(), status);
            return status;
        }
    }

    private static class ThreadPoolTaskRunnerWorkItem
    extends TaskRunnerWorkItem {
        private static final Comparator<ThreadPoolTaskRunnerWorkItem> COMPARATOR = new Comparator<ThreadPoolTaskRunnerWorkItem>(){

            @Override
            public int compare(ThreadPoolTaskRunnerWorkItem lhs, ThreadPoolTaskRunnerWorkItem rhs) {
                return lhs.getTaskId().compareTo(rhs.getTaskId());
            }
        };
        private final Task task;
        private final TaskLocation location;

        private ThreadPoolTaskRunnerWorkItem(Task task, TaskLocation location, ListenableFuture<TaskStatus> result) {
            super(task.getId(), result);
            this.task = task;
            this.location = location;
        }

        public Task getTask() {
            return this.task;
        }

        @Override
        public TaskLocation getLocation() {
            return this.location;
        }

        static /* synthetic */ Comparator access$000() {
            return COMPARATOR;
        }
    }
}

