/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.autoscaling;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.concurrent.ScheduledExecutorFactory;
import com.metamx.emitter.EmittingLogger;
import io.druid.indexing.overlord.ImmutableWorkerInfo;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.overlord.WorkerTaskRunner;
import io.druid.indexing.overlord.autoscaling.AbstractWorkerResourceManagementStrategy;
import io.druid.indexing.overlord.autoscaling.AutoScalingData;
import io.druid.indexing.overlord.autoscaling.ResourceManagementSchedulerConfig;
import io.druid.indexing.overlord.autoscaling.ResourceManagementUtil;
import io.druid.indexing.overlord.autoscaling.ScalingStats;
import io.druid.indexing.overlord.autoscaling.SimpleWorkerResourceManagementConfig;
import io.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import io.druid.indexing.worker.Worker;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class SimpleWorkerResourceManagementStrategy
extends AbstractWorkerResourceManagementStrategy {
    private static final EmittingLogger log = new EmittingLogger(SimpleWorkerResourceManagementStrategy.class);
    private final SimpleWorkerResourceManagementConfig config;
    private final Supplier<WorkerBehaviorConfig> workerConfigRef;
    private final ScalingStats scalingStats;
    private final Object lock = new Object();
    private final Set<String> currentlyProvisioning = Sets.newHashSet();
    private final Set<String> currentlyTerminating = Sets.newHashSet();
    private int targetWorkerCount = -1;
    private DateTime lastProvisionTime = new DateTime();
    private DateTime lastTerminateTime = new DateTime();

    @Inject
    public SimpleWorkerResourceManagementStrategy(SimpleWorkerResourceManagementConfig config, Supplier<WorkerBehaviorConfig> workerConfigRef, ResourceManagementSchedulerConfig resourceManagementSchedulerConfig, ScheduledExecutorFactory factory) {
        this(config, workerConfigRef, resourceManagementSchedulerConfig, factory.create(1, "SimpleResourceManagement-manager--%d"));
    }

    public SimpleWorkerResourceManagementStrategy(SimpleWorkerResourceManagementConfig config, Supplier<WorkerBehaviorConfig> workerConfigRef, ResourceManagementSchedulerConfig resourceManagementSchedulerConfig, ScheduledExecutorService exec) {
        super(resourceManagementSchedulerConfig, exec);
        this.config = config;
        this.workerConfigRef = workerConfigRef;
        this.scalingStats = new ScalingStats(config.getNumEventsToTrack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doProvision(WorkerTaskRunner runner) {
        Collection<? extends TaskRunnerWorkItem> pendingTasks = runner.getPendingTasks();
        Collection<ImmutableWorkerInfo> workers = this.getWorkers(runner);
        Object object = this.lock;
        synchronized (object) {
            List<String> newNodes;
            AutoScalingData provisioned;
            boolean didProvision = false;
            WorkerBehaviorConfig workerConfig = (WorkerBehaviorConfig)this.workerConfigRef.get();
            if (workerConfig == null || workerConfig.getAutoScaler() == null) {
                log.warn("No workerConfig available, cannot provision new workers.", new Object[0]);
                return false;
            }
            Predicate<ImmutableWorkerInfo> isValidWorker = ResourceManagementUtil.createValidWorkerPredicate(this.config);
            int currValidWorkers = Collections2.filter(workers, isValidWorker).size();
            List<String> workerNodeIds = workerConfig.getAutoScaler().ipToIdLookup(Lists.newArrayList((Iterable)Iterables.transform(workers, (Function)new Function<ImmutableWorkerInfo, String>(){

                public String apply(ImmutableWorkerInfo input) {
                    return input.getWorker().getIp();
                }
            })));
            this.currentlyProvisioning.removeAll(workerNodeIds);
            this.updateTargetWorkerCount(workerConfig, pendingTasks, workers);
            for (int want = this.targetWorkerCount - (currValidWorkers + this.currentlyProvisioning.size()); want > 0 && (provisioned = workerConfig.getAutoScaler().provision()) != null && !(newNodes = provisioned.getNodeIds()).isEmpty(); want -= provisioned.getNodeIds().size()) {
                this.currentlyProvisioning.addAll(newNodes);
                this.lastProvisionTime = new DateTime();
                this.scalingStats.addProvisionEvent(provisioned);
                didProvision = true;
            }
            if (!this.currentlyProvisioning.isEmpty()) {
                Duration durSinceLastProvision = new Duration((ReadableInstant)this.lastProvisionTime, (ReadableInstant)new DateTime());
                log.info("%s provisioning. Current wait time: %s", new Object[]{this.currentlyProvisioning, durSinceLastProvision});
                if (durSinceLastProvision.isLongerThan((ReadableDuration)this.config.getMaxScalingDuration().toStandardDuration())) {
                    log.makeAlert("Worker node provisioning taking too long!", new Object[0]).addData("millisSinceLastProvision", (Object)durSinceLastProvision.getMillis()).addData("provisioningCount", (Object)this.currentlyProvisioning.size()).emit();
                    workerConfig.getAutoScaler().terminateWithIds(Lists.newArrayList(this.currentlyProvisioning));
                    this.currentlyProvisioning.clear();
                }
            }
            return didProvision;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean doTerminate(WorkerTaskRunner runner) {
        Collection<? extends TaskRunnerWorkItem> pendingTasks = runner.getPendingTasks();
        Object object = this.lock;
        synchronized (object) {
            WorkerBehaviorConfig workerConfig = (WorkerBehaviorConfig)this.workerConfigRef.get();
            if (workerConfig == null) {
                log.warn("No workerConfig available, cannot terminate workers.", new Object[0]);
                return false;
            }
            boolean didTerminate = false;
            HashSet workerNodeIds = Sets.newHashSet(workerConfig.getAutoScaler().ipToIdLookup(Lists.newArrayList((Iterable)Iterables.transform(runner.getLazyWorkers(), (Function)new Function<Worker, String>(){

                public String apply(Worker input) {
                    return input.getIp();
                }
            }))));
            HashSet stillExisting = Sets.newHashSet();
            for (String s : this.currentlyTerminating) {
                if (!workerNodeIds.contains(s)) continue;
                stillExisting.add(s);
            }
            this.currentlyTerminating.clear();
            this.currentlyTerminating.addAll(stillExisting);
            Collection<ImmutableWorkerInfo> workers = this.getWorkers(runner);
            this.updateTargetWorkerCount(workerConfig, pendingTasks, workers);
            if (this.currentlyTerminating.isEmpty()) {
                int excessWorkers = workers.size() + this.currentlyProvisioning.size() - this.targetWorkerCount;
                if (excessWorkers > 0) {
                    Predicate<ImmutableWorkerInfo> isLazyWorker = ResourceManagementUtil.createLazyWorkerPredicate(this.config);
                    Collection laziestWorkerIps = Collections2.transform(runner.markWorkersLazy(isLazyWorker, excessWorkers), (Function)new Function<Worker, String>(){

                        public String apply(Worker worker) {
                            return worker.getIp();
                        }
                    });
                    if (laziestWorkerIps.isEmpty()) {
                        log.info("Wanted to terminate %,d workers, but couldn't find any lazy ones!", new Object[]{excessWorkers});
                    } else {
                        log.info("Terminating %,d workers (wanted %,d): %s", new Object[]{laziestWorkerIps.size(), excessWorkers, Joiner.on((String)", ").join((Iterable)laziestWorkerIps)});
                        AutoScalingData terminated = workerConfig.getAutoScaler().terminate((List<String>)ImmutableList.copyOf((Collection)laziestWorkerIps));
                        if (terminated != null) {
                            this.currentlyTerminating.addAll(terminated.getNodeIds());
                            this.lastTerminateTime = new DateTime();
                            this.scalingStats.addTerminateEvent(terminated);
                            didTerminate = true;
                        }
                    }
                }
            } else {
                Duration durSinceLastTerminate = new Duration((ReadableInstant)this.lastTerminateTime, (ReadableInstant)new DateTime());
                log.info("%s terminating. Current wait time: %s", new Object[]{this.currentlyTerminating, durSinceLastTerminate});
                if (durSinceLastTerminate.isLongerThan((ReadableDuration)this.config.getMaxScalingDuration().toStandardDuration())) {
                    log.makeAlert("Worker node termination taking too long!", new Object[0]).addData("millisSinceLastTerminate", (Object)durSinceLastTerminate.getMillis()).addData("terminatingCount", (Object)this.currentlyTerminating.size()).emit();
                    this.currentlyTerminating.clear();
                }
            }
            return didTerminate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTargetWorkerCount(WorkerBehaviorConfig workerConfig, Collection<? extends TaskRunnerWorkItem> pendingTasks, Collection<ImmutableWorkerInfo> zkWorkers) {
        Object object = this.lock;
        synchronized (object) {
            boolean shouldScaleDown;
            Collection validWorkers = Collections2.filter(zkWorkers, ResourceManagementUtil.createValidWorkerPredicate(this.config));
            Predicate<ImmutableWorkerInfo> isLazyWorker = ResourceManagementUtil.createLazyWorkerPredicate(this.config);
            int minWorkerCount = workerConfig.getAutoScaler().getMinNumWorkers();
            int maxWorkerCount = workerConfig.getAutoScaler().getMaxNumWorkers();
            if (minWorkerCount > maxWorkerCount) {
                log.error("Huh? minWorkerCount[%d] > maxWorkerCount[%d]. I give up!", new Object[]{minWorkerCount, maxWorkerCount});
                return;
            }
            if (this.targetWorkerCount < 0) {
                this.targetWorkerCount = Math.max(Math.min(zkWorkers.size(), maxWorkerCount), minWorkerCount);
                log.info("Starting with a target of %,d workers (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            }
            boolean notTakingActions = this.currentlyProvisioning.isEmpty() && this.currentlyTerminating.isEmpty();
            boolean shouldScaleUp = notTakingActions && validWorkers.size() >= this.targetWorkerCount && this.targetWorkerCount < maxWorkerCount && (this.hasTaskPendingBeyondThreshold(pendingTasks) || this.targetWorkerCount < minWorkerCount);
            boolean bl = shouldScaleDown = notTakingActions && validWorkers.size() == this.targetWorkerCount && this.targetWorkerCount > minWorkerCount && Iterables.any((Iterable)validWorkers, isLazyWorker);
            if (shouldScaleUp) {
                this.targetWorkerCount = Math.max(this.targetWorkerCount + 1, minWorkerCount);
                log.info("I think we should scale up to %,d workers (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            } else if (shouldScaleDown) {
                this.targetWorkerCount = Math.min(this.targetWorkerCount - 1, maxWorkerCount);
                log.info("I think we should scale down to %,d workers (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            } else {
                log.info("Our target is %,d workers, and I'm okay with that (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasTaskPendingBeyondThreshold(Collection<? extends TaskRunnerWorkItem> pendingTasks) {
        Object object = this.lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            for (TaskRunnerWorkItem taskRunnerWorkItem : pendingTasks) {
                Duration timeoutDuration;
                Duration durationSinceInsertion = new Duration(taskRunnerWorkItem.getQueueInsertionTime().getMillis(), now);
                if (!durationSinceInsertion.isEqual((ReadableDuration)(timeoutDuration = this.config.getPendingTaskTimeout().toStandardDuration())) && !durationSinceInsertion.isLongerThan((ReadableDuration)timeoutDuration)) continue;
                return true;
            }
            return false;
        }
    }

    public Collection<ImmutableWorkerInfo> getWorkers(WorkerTaskRunner runner) {
        return runner.getWorkers();
    }

    @Override
    public ScalingStats getStats() {
        return this.scalingStats;
    }
}

