/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.setup;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.ImmutableWorkerInfo;
import io.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import io.druid.indexing.overlord.setup.WorkerSelectStrategy;
import java.util.Comparator;
import java.util.TreeSet;

public class EqualDistributionWorkerSelectStrategy
implements WorkerSelectStrategy {
    @Override
    public Optional<ImmutableWorkerInfo> findWorkerForTask(WorkerTaskRunnerConfig config, ImmutableMap<String, ImmutableWorkerInfo> zkWorkers, Task task) {
        TreeSet sortedWorkers = Sets.newTreeSet((Comparator)new Comparator<ImmutableWorkerInfo>(){

            @Override
            public int compare(ImmutableWorkerInfo zkWorker, ImmutableWorkerInfo zkWorker2) {
                int retVal = -Ints.compare((int)zkWorker2.getCurrCapacityUsed(), (int)zkWorker.getCurrCapacityUsed());
                if (retVal == 0) {
                    retVal = zkWorker2.getWorker().getVersion().compareTo(zkWorker.getWorker().getVersion());
                }
                return retVal;
            }
        });
        sortedWorkers.addAll(zkWorkers.values());
        String minWorkerVer = config.getMinWorkerVersion();
        for (ImmutableWorkerInfo zkWorker : sortedWorkers) {
            if (!zkWorker.canRunTask(task) || !zkWorker.isValidVersion(minWorkerVer)) continue;
            return Optional.of((Object)zkWorker);
        }
        return Optional.absent();
    }
}

