/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.ImmutableWorkerInfo;
import io.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import io.druid.indexing.overlord.setup.FillCapacityWithAffinityConfig;
import io.druid.indexing.overlord.setup.FillCapacityWorkerSelectStrategy;
import java.util.List;
import java.util.Set;

public class FillCapacityWithAffinityWorkerSelectStrategy
extends FillCapacityWorkerSelectStrategy {
    private final FillCapacityWithAffinityConfig affinityConfig;
    private final Set<String> affinityWorkerHosts = Sets.newHashSet();

    @JsonCreator
    public FillCapacityWithAffinityWorkerSelectStrategy(@JsonProperty(value="affinityConfig") FillCapacityWithAffinityConfig affinityConfig) {
        this.affinityConfig = affinityConfig;
        for (List<String> affinityWorkers : affinityConfig.getAffinity().values()) {
            for (String affinityWorker : affinityWorkers) {
                this.affinityWorkerHosts.add(affinityWorker);
            }
        }
    }

    @JsonProperty
    public FillCapacityWithAffinityConfig getAffinityConfig() {
        return this.affinityConfig;
    }

    @Override
    public Optional<ImmutableWorkerInfo> findWorkerForTask(WorkerTaskRunnerConfig config, ImmutableMap<String, ImmutableWorkerInfo> zkWorkers, Task task) {
        Optional<ImmutableWorkerInfo> retVal;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (String workerHost : zkWorkers.keySet()) {
            if (this.affinityWorkerHosts.contains(workerHost)) continue;
            builder.put((Object)workerHost, zkWorkers.get((Object)workerHost));
        }
        ImmutableMap eligibleWorkers = builder.build();
        List<String> workerHosts = this.affinityConfig.getAffinity().get(task.getDataSource());
        if (workerHosts == null) {
            return super.findWorkerForTask(config, (ImmutableMap<String, ImmutableWorkerInfo>)eligibleWorkers, task);
        }
        ImmutableMap.Builder affinityBuilder = new ImmutableMap.Builder();
        for (String workerHost : workerHosts) {
            ImmutableWorkerInfo zkWorker = (ImmutableWorkerInfo)zkWorkers.get((Object)workerHost);
            if (zkWorker == null) continue;
            affinityBuilder.put((Object)workerHost, (Object)zkWorker);
        }
        ImmutableMap affinityWorkers = affinityBuilder.build();
        if (!affinityWorkers.isEmpty() && (retVal = super.findWorkerForTask(config, (ImmutableMap<String, ImmutableWorkerInfo>)affinityWorkers, task)).isPresent()) {
            return retVal;
        }
        return super.findWorkerForTask(config, (ImmutableMap<String, ImmutableWorkerInfo>)eligibleWorkers, task);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FillCapacityWithAffinityWorkerSelectStrategy that = (FillCapacityWithAffinityWorkerSelectStrategy)o;
        return !(this.affinityConfig != null ? !this.affinityConfig.equals(that.affinityConfig) : that.affinityConfig != null);
    }

    public int hashCode() {
        return this.affinityConfig != null ? this.affinityConfig.hashCode() : 0;
    }
}

