/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.worker.executor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.concurrent.Execs;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.worker.executor.ExecutorLifecycleConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ExecutorService;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;

public class ExecutorLifecycle {
    private static final EmittingLogger log = new EmittingLogger(ExecutorLifecycle.class);
    private final ExecutorLifecycleConfig taskExecutorConfig;
    private final TaskConfig taskConfig;
    private final TaskActionClientFactory taskActionClientFactory;
    private final TaskRunner taskRunner;
    private final ObjectMapper jsonMapper;
    private final ExecutorService parentMonitorExec = Execs.singleThreaded((String)"parent-monitor-%d");
    private volatile Task task = null;
    private volatile ListenableFuture<TaskStatus> statusFuture = null;
    private volatile FileChannel taskLockChannel;
    private volatile FileLock taskLockFileLock;

    @Inject
    public ExecutorLifecycle(ExecutorLifecycleConfig taskExecutorConfig, TaskConfig taskConfig, TaskActionClientFactory taskActionClientFactory, TaskRunner taskRunner, ObjectMapper jsonMapper) {
        this.taskExecutorConfig = taskExecutorConfig;
        this.taskConfig = taskConfig;
        this.taskActionClientFactory = taskActionClientFactory;
        this.taskRunner = taskRunner;
        this.jsonMapper = jsonMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws InterruptedException {
        File taskFile = (File)Preconditions.checkNotNull((Object)this.taskExecutorConfig.getTaskFile(), (Object)"taskFile");
        final File statusFile = (File)Preconditions.checkNotNull((Object)this.taskExecutorConfig.getStatusFile(), (Object)"statusFile");
        final InputStream parentStream = (InputStream)Preconditions.checkNotNull((Object)this.taskExecutorConfig.getParentStream(), (Object)"parentStream");
        try {
            this.task = (Task)this.jsonMapper.readValue(taskFile, Task.class);
            log.info("Running with task: %s", new Object[]{this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.task)});
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        File taskLockFile = this.taskConfig.getTaskLockFile(this.task.getId());
        try {
            ExecutorLifecycle executorLifecycle = this;
            synchronized (executorLifecycle) {
                long startLocking;
                if (this.taskLockChannel == null && this.taskLockFileLock == null) {
                    this.taskLockChannel = FileChannel.open(taskLockFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                    log.info("Attempting to lock file[%s].", new Object[]{taskLockFile});
                    startLocking = System.currentTimeMillis();
                    long timeout = new DateTime(startLocking).plus((ReadablePeriod)this.taskConfig.getDirectoryLockTimeout()).getMillis();
                    while (this.taskLockFileLock == null && System.currentTimeMillis() < timeout) {
                        this.taskLockFileLock = this.taskLockChannel.tryLock();
                        if (this.taskLockFileLock != null) continue;
                        Thread.sleep(100L);
                    }
                    if (this.taskLockFileLock == null) {
                        throw new ISE("Could not acquire lock file[%s] within %,dms.", new Object[]{taskLockFile, timeout - startLocking});
                    }
                } else {
                    throw new ISE("Already started!", new Object[0]);
                }
                log.info("Acquired lock file[%s] in %,dms.", new Object[]{taskLockFile, System.currentTimeMillis() - startLocking});
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.parentMonitorExec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    while (parentStream.read() != -1) {
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Failed to read from stdin", new Object[0]);
                }
                log.info("Triggering JVM shutdown.", new Object[0]);
                System.exit(2);
            }
        });
        try {
            if (!this.task.isReady(this.taskActionClientFactory.create(this.task))) {
                throw new ISE("Task is not ready to run yet!", new Object[]{this.task.getId()});
            }
        }
        catch (Exception e) {
            throw new ISE((Throwable)e, "Failed to run isReady", new Object[]{this.task.getId()});
        }
        this.statusFuture = Futures.transform(this.taskRunner.run(this.task), (Function)new Function<TaskStatus, TaskStatus>(){

            public TaskStatus apply(TaskStatus taskStatus) {
                try {
                    log.info("Task completed with status: %s", new Object[]{ExecutorLifecycle.this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)taskStatus)});
                    File statusFileParent = statusFile.getParentFile();
                    if (statusFileParent != null) {
                        statusFileParent.mkdirs();
                    }
                    ExecutorLifecycle.this.jsonMapper.writeValue(statusFile, (Object)taskStatus);
                    return taskStatus;
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    public void join() {
        try {
            this.statusFuture.get();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() throws Exception {
        this.parentMonitorExec.shutdown();
        ExecutorLifecycle executorLifecycle = this;
        synchronized (executorLifecycle) {
            if (this.taskLockFileLock != null) {
                this.taskLockFileLock.release();
            }
            if (this.taskLockChannel != null) {
                this.taskLockChannel.close();
            }
        }
    }
}

