/*
 * Decompiled with CFR 0.152.
 */
package io.druid.testing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.metamx.common.logger.Logger;
import io.druid.testing.IntegrationTestingConfig;
import io.druid.testing.IntegrationTestingConfigProvider;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ConfigFileConfigProvider
implements IntegrationTestingConfigProvider {
    private static final Logger LOG = new Logger(ConfigFileConfigProvider.class);
    private String routerHost = "";
    private String brokerHost = "";
    private String historicalHost = "";
    private String coordinatorHost = "";
    private String indexerHost = "";
    private String middleManagerHost = "";
    private String zookeeperHosts = "";
    private String kafkaHost = "";
    private Map<String, String> props = null;

    @JsonCreator
    ConfigFileConfigProvider(@JsonProperty(value="configFile") String configFile) {
        this.loadProperties(configFile);
    }

    private void loadProperties(String configFile) {
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            this.props = (Map)jsonMapper.readValue(new File(configFile), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.routerHost = this.props.get("router_host");
        if (null != this.routerHost) {
            this.routerHost = this.routerHost + ":" + this.props.get("router_port");
        }
        this.brokerHost = this.props.get("broker_host") + ":" + this.props.get("broker_port");
        this.historicalHost = this.props.get("historical_host") + ":" + this.props.get("historical_port");
        this.coordinatorHost = this.props.get("coordinator_host") + ":" + this.props.get("coordinator_port");
        this.indexerHost = this.props.get("indexer_host") + ":" + this.props.get("indexer_port");
        this.middleManagerHost = this.props.get("middlemanager_host");
        this.zookeeperHosts = this.props.get("zookeeper_hosts");
        this.kafkaHost = this.props.get("kafka_host") + ":" + this.props.get("kafka_port");
        LOG.info("router: [%s]", new Object[]{this.routerHost});
        LOG.info("broker: [%s]", new Object[]{this.brokerHost});
        LOG.info("coordinator: [%s]", new Object[]{this.coordinatorHost});
        LOG.info("overlord: [%s]", new Object[]{this.indexerHost});
        LOG.info("middle manager: [%s]", new Object[]{this.middleManagerHost});
        LOG.info("zookeepers: [%s]", new Object[]{this.zookeeperHosts});
        LOG.info("kafka: [%s]", new Object[]{this.kafkaHost});
    }

    public IntegrationTestingConfig get() {
        return new IntegrationTestingConfig(){

            @Override
            public String getCoordinatorHost() {
                return ConfigFileConfigProvider.this.coordinatorHost;
            }

            @Override
            public String getIndexerHost() {
                return ConfigFileConfigProvider.this.indexerHost;
            }

            @Override
            public String getRouterHost() {
                return ConfigFileConfigProvider.this.routerHost;
            }

            @Override
            public String getBrokerHost() {
                return ConfigFileConfigProvider.this.brokerHost;
            }

            @Override
            public String getHistoricalHost() {
                return ConfigFileConfigProvider.this.historicalHost;
            }

            @Override
            public String getMiddleManagerHost() {
                return ConfigFileConfigProvider.this.middleManagerHost;
            }

            @Override
            public String getZookeeperHosts() {
                return ConfigFileConfigProvider.this.zookeeperHosts;
            }

            @Override
            public String getKafkaHost() {
                return ConfigFileConfigProvider.this.kafkaHost;
            }

            @Override
            public String getProperty(String keyword) {
                return (String)ConfigFileConfigProvider.this.props.get(keyword);
            }
        };
    }
}

