/*
 * Decompiled with CFR 0.152.
 */
package io.druid.testing;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.testing.IntegrationTestingConfig;
import io.druid.testing.IntegrationTestingConfigProvider;
import javax.validation.constraints.NotNull;

public class DockerConfigProvider
implements IntegrationTestingConfigProvider {
    @JsonProperty
    @NotNull
    private String dockerIp;
    @JsonProperty
    @NotNull
    private String hadoopDir;

    public IntegrationTestingConfig get() {
        return new IntegrationTestingConfig(){

            @Override
            public String getCoordinatorHost() {
                return DockerConfigProvider.this.dockerIp + ":8081";
            }

            @Override
            public String getIndexerHost() {
                return DockerConfigProvider.this.dockerIp + ":8090";
            }

            @Override
            public String getRouterHost() {
                return DockerConfigProvider.this.dockerIp + ":8888";
            }

            @Override
            public String getBrokerHost() {
                return DockerConfigProvider.this.dockerIp + ":8082";
            }

            @Override
            public String getHistoricalHost() {
                return DockerConfigProvider.this.dockerIp + ":8083";
            }

            @Override
            public String getMiddleManagerHost() {
                return DockerConfigProvider.this.dockerIp;
            }

            @Override
            public String getZookeeperHosts() {
                return DockerConfigProvider.this.dockerIp + ":2181";
            }

            @Override
            public String getKafkaHost() {
                return DockerConfigProvider.this.dockerIp + ":9092";
            }

            @Override
            public String getProperty(String prop) {
                if (prop.equals("hadoopTestDir")) {
                    return DockerConfigProvider.this.hadoopDir;
                }
                throw new UnsupportedOperationException("DockerConfigProvider does not support property " + prop);
            }
        };
    }
}

