/*
 * Decompiled with CFR 0.152.
 */
package io.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.Request;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.StatusResponseHandler;
import com.metamx.http.client.response.StatusResponseHolder;
import io.druid.guice.annotations.Global;
import io.druid.testing.IntegrationTestingConfig;
import java.net.URL;
import java.util.List;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class ClientInfoResourceTestClient {
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String broker;
    private final StatusResponseHandler responseHandler;

    @Inject
    ClientInfoResourceTestClient(ObjectMapper jsonMapper, @Global HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.broker = config.getBrokerHost();
        this.responseHandler = new StatusResponseHandler(Charsets.UTF_8);
    }

    private String getBrokerURL() {
        return String.format("http://%s/druid/v2/datasources", this.broker);
    }

    public List<String> getDimensions(String dataSource, String interval) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(String.format("%s/%s/dimensions?interval=%s", this.getBrokerURL(), dataSource, interval))), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while querying[%s] status[%s] content[%s]", new Object[]{this.getBrokerURL(), response.getStatus(), response.getContent()});
            }
            return (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

