/*
 * Decompiled with CFR 0.152.
 */
package io.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.Request;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.StatusResponseHandler;
import com.metamx.http.client.response.StatusResponseHolder;
import io.druid.guice.annotations.Global;
import io.druid.testing.IntegrationTestingConfig;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Interval;

public class CoordinatorResourceTestClient {
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String coordinator;
    private final StatusResponseHandler responseHandler;

    @Inject
    CoordinatorResourceTestClient(ObjectMapper jsonMapper, @Global HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.coordinator = config.getCoordinatorHost();
        this.responseHandler = new StatusResponseHandler(Charsets.UTF_8);
    }

    private String getCoordinatorURL() {
        return String.format("http://%s/druid/coordinator/v1/", this.coordinator);
    }

    private String getIntervalsURL(String dataSource) {
        return String.format("%sdatasources/%s/intervals", this.getCoordinatorURL(), dataSource);
    }

    private String getLoadStatusURL() {
        return String.format("%s%s", this.getCoordinatorURL(), "loadstatus");
    }

    public ArrayList<String> getSegmentIntervals(String dataSource) throws Exception {
        ArrayList segments = null;
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, this.getIntervalsURL(dataSource));
            segments = (ArrayList)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<ArrayList<String>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return segments;
    }

    private Map<String, Integer> getLoadStatus() {
        Map status = null;
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, this.getLoadStatusURL());
            status = (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, Integer>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return status;
    }

    public boolean areSegmentsLoaded(String dataSource) {
        Map<String, Integer> status = this.getLoadStatus();
        return status.containsKey(dataSource) && (double)status.get(dataSource).intValue() == 100.0;
    }

    public void unloadSegmentsForDataSource(String dataSource, Interval interval) {
        try {
            this.makeRequest(HttpMethod.DELETE, String.format("%sdatasources/%s", this.getCoordinatorURL(), dataSource));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void deleteSegmentsDataSource(String dataSource, Interval interval) {
        try {
            this.makeRequest(HttpMethod.DELETE, String.format("%sdatasources/%s/intervals/%s", this.getCoordinatorURL(), dataSource, interval.toString().replace("/", "_")));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private StatusResponseHolder makeRequest(HttpMethod method, String url) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(method, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while making request to url[%s] status[%s] content[%s]", new Object[]{url, response.getStatus(), response.getContent()});
            }
            return response;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

