/*
 * Decompiled with CFR 0.152.
 */
package io.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.metamx.common.ISE;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.Request;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.StatusResponseHandler;
import com.metamx.http.client.response.StatusResponseHolder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class EventReceiverFirehoseTestClient {
    private final String host;
    private final StatusResponseHandler responseHandler;
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String chatID;
    private final ObjectMapper smileMapper;

    public EventReceiverFirehoseTestClient(String host, String chatID, ObjectMapper jsonMapper, HttpClient httpClient, ObjectMapper smileMapper) {
        this.host = host;
        this.jsonMapper = jsonMapper;
        this.responseHandler = new StatusResponseHandler(Charsets.UTF_8);
        this.httpClient = httpClient;
        this.chatID = chatID;
        this.smileMapper = smileMapper;
    }

    private String getURL() {
        return String.format("http://%s/druid/worker/v1/chat/%s/push-events/", this.host, this.chatID);
    }

    public int postEvents(Collection<Map<String, Object>> events, ObjectMapper objectMapper, String mediaType) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(this.getURL())).setContent(mediaType, objectMapper.writeValueAsBytes(events)), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while posting events to url[%s] status[%s] content[%s]", new Object[]{this.getURL(), response.getStatus(), response.getContent()});
            }
            Map responseData = (Map)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, Integer>>(){});
            return (Integer)responseData.get("eventCount");
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int postEventsFromFile(String file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(EventReceiverFirehoseTestClient.class.getResourceAsStream(file)));){
            String s;
            ArrayList<Map<String, Object>> events = new ArrayList<Map<String, Object>>();
            int totalEventsPosted = 0;
            int expectedEventsPosted = 0;
            while ((s = reader.readLine()) != null) {
                events.add((Map)this.jsonMapper.readValue(s, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                ObjectMapper mapper = totalEventsPosted % 2 == 0 ? this.jsonMapper : this.smileMapper;
                String mediaType = totalEventsPosted % 2 == 0 ? "application/json" : "application/x-jackson-smile";
                totalEventsPosted += this.postEvents(events, mapper, mediaType);
                expectedEventsPosted += events.size();
                events = new ArrayList();
            }
            if (totalEventsPosted != expectedEventsPosted) {
                throw new ISE("All events not posted, expected : %d actual : %d", new Object[]{events.size(), totalEventsPosted});
            }
            int n = totalEventsPosted;
            return n;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

